/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.midi.synth;

import app.tuxguitar.midi.synth.TGAudioBuffer;
import app.tuxguitar.midi.synth.TGProgram;
import app.tuxguitar.midi.synth.TGProgramPropertiesUtil;
import app.tuxguitar.midi.synth.TGSynthChannelPendingQueue;
import app.tuxguitar.midi.synth.TGSynthChannelProcessor;
import app.tuxguitar.midi.synth.TGSynthChannelProperties;
import app.tuxguitar.midi.synth.TGSynthModel;
import app.tuxguitar.player.base.MidiChannel;
import app.tuxguitar.player.base.MidiPlayerException;

public class TGSynthChannel
implements MidiChannel {
    public static final String CUSTOM_PROGRAM_PREFIX = "synth.program";
    private int id;
    private int midiBank;
    private int midiProgram;
    private int volume;
    private int balance;
    private TGSynthModel synthesizer;
    private TGSynthChannelProcessor processor;
    private TGSynthChannelProperties parameters;
    private TGSynthChannelPendingQueue pendingEvents;
    private TGProgram program;
    private boolean customProgram;

    public TGSynthChannel(TGSynthModel synthesizer, int id) {
        this.synthesizer = synthesizer;
        this.id = id;
        this.midiBank = 0;
        this.midiProgram = -1;
        this.volume = 127;
        this.balance = 64;
        this.program = new TGProgram();
        this.parameters = new TGSynthChannelProperties();
        this.pendingEvents = new TGSynthChannelPendingQueue(this);
    }

    public int getId() {
        return this.id;
    }

    public TGProgram getProgram() {
        return this.program;
    }

    public void loadProgram(TGProgram program) throws MidiPlayerException {
        this.program.copyFrom(program);
        this.openProcessor();
        this.pendingEvents.dispatch();
    }

    public void updateProgram() {
        this.openProcessor();
    }

    public TGSynthChannelProcessor getProcessor() {
        return this.processor;
    }

    public void openProcessor() {
        if (this.program.getReceiver() != null) {
            if (this.processor == null) {
                this.processor = new TGSynthChannelProcessor();
            }
            this.processor.open(this.synthesizer.getContext(), this.program);
        }
    }

    public void closeProcessor() {
        if (this.processor != null) {
            this.processor.close();
            this.processor = null;
            this.pendingEvents.clear();
        }
    }

    public void fillBuffer(TGAudioBuffer buffer) {
        if (this.processor != null) {
            this.processor.fillBuffer(buffer, this.volume, this.balance);
        }
    }

    public void sendNoteOn(int key, int velocity, int voice, boolean bendMode) throws MidiPlayerException {
        if (this.processor != null && this.processor.getProcessor() != null) {
            this.processor.getProcessor().sendNoteOn(key, velocity, voice, bendMode);
        }
    }

    public void sendNoteOff(int key, int velocity, int voice, boolean bendMode) throws MidiPlayerException {
        if (this.processor != null && this.processor.getProcessor() != null) {
            this.processor.getProcessor().sendNoteOff(key, velocity, voice, bendMode);
        }
    }

    public void sendPitchBend(int value, int voice, boolean bendMode) throws MidiPlayerException {
        if (this.processor != null && this.processor.getProcessor() != null) {
            this.processor.getProcessor().sendPitchBend(value, voice, bendMode);
        } else {
            this.pendingEvents.addPitchBend(value, voice, bendMode);
        }
    }

    public void sendControlChange(int controller, int value) throws MidiPlayerException {
        try {
            if (controller == 0) {
                if (this.midiBank != value) {
                    this.midiBank = value;
                    if (!this.customProgram) {
                        this.closeProcessor();
                    }
                }
            } else if (controller == 7) {
                this.volume = value;
            } else if (controller == 10) {
                this.balance = value;
            } else if (this.processor != null && this.processor.getProcessor() != null) {
                this.processor.getProcessor().sendControlChange(controller, value);
            } else {
                this.pendingEvents.addControlChange(controller, value);
            }
        }
        catch (Throwable throwable) {
            throw new MidiPlayerException(throwable.getMessage(), throwable);
        }
    }

    public void sendProgramChange(int value) throws MidiPlayerException {
        try {
            if (this.midiProgram != value || this.processor == null) {
                this.midiProgram = value;
                if (!this.customProgram) {
                    this.loadProgram(this.synthesizer.getProgram(this.midiBank, this.midiProgram));
                }
            }
        }
        catch (Throwable throwable) {
            throw new MidiPlayerException(throwable.getMessage(), throwable);
        }
    }

    public void sendAllNotesOff() throws MidiPlayerException {
        if (this.processor != null && this.processor.getProcessor() != null) {
            this.processor.getProcessor().sendControlChange(123, 0);
        }
    }

    public void sendParameter(String key, String value) throws MidiPlayerException {
        if ("sendingParams".equals(key)) {
            if (Boolean.valueOf(value).booleanValue()) {
                this.parameters.clear();
            } else {
                TGProgram program = TGProgramPropertiesUtil.getProgram(this.parameters, CUSTOM_PROGRAM_PREFIX);
                boolean bl = this.customProgram = program != null;
                if (this.customProgram) {
                    this.loadProgram(program);
                } else if (this.midiProgram >= 0) {
                    this.loadProgram(this.synthesizer.getProgram(this.midiBank, this.midiProgram));
                } else {
                    this.closeProcessor();
                }
            }
        } else {
            this.parameters.setValue(key, value);
        }
    }

    public boolean isBusy() {
        return this.processor != null && this.processor.isBusy();
    }
}

