/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.midi.synth;

import app.tuxguitar.midi.synth.TGProgram;
import app.tuxguitar.midi.synth.TGProgramElement;
import app.tuxguitar.util.properties.TGProperties;
import app.tuxguitar.util.properties.TGPropertiesUtil;
import java.util.Map;
import java.util.Set;

public final class TGProgramPropertiesUtil {
    public static TGProgram getProgram(TGProperties properties, String prefix) {
        TGProgram program = null;
        TGProgramElement element = TGProgramPropertiesUtil.getElement(properties, prefix);
        if (element != null) {
            program = new TGProgram();
            program.setReceiver(element);
            Integer processorCount = TGPropertiesUtil.getIntegerValue((TGProperties)properties, (String)(prefix + ".output.count"));
            if (processorCount != null) {
                for (int i = 0; i < processorCount; ++i) {
                    TGProgramElement processor = TGProgramPropertiesUtil.getElement(properties, prefix + ".output." + i);
                    if (processor == null) continue;
                    program.addOutput(processor);
                }
            }
        }
        return program;
    }

    public static TGProgramElement getElement(TGProperties properties, String keyPrefix) {
        TGProgramElement element = null;
        String elementId = TGPropertiesUtil.getStringValue((TGProperties)properties, (String)(keyPrefix + ".id"));
        String elementType = TGPropertiesUtil.getStringValue((TGProperties)properties, (String)(keyPrefix + ".type"));
        boolean elementEnabled = TGPropertiesUtil.getBooleanValue((TGProperties)properties, (String)(keyPrefix + ".enabled"), (boolean)true);
        if (elementId != null && elementType != null) {
            element = new TGProgramElement();
            element.setId(elementId);
            element.setType(elementType);
            element.setEnabled(elementEnabled);
            Integer paramCount = TGPropertiesUtil.getIntegerValue((TGProperties)properties, (String)(keyPrefix + ".param.count"));
            if (paramCount != null) {
                for (int i = 0; i < paramCount; ++i) {
                    String paramName = TGPropertiesUtil.getStringValue((TGProperties)properties, (String)(keyPrefix + ".param." + i + ".name"));
                    String paramValue = TGPropertiesUtil.getStringValue((TGProperties)properties, (String)(keyPrefix + ".param." + i + ".value"));
                    if (paramName == null) continue;
                    element.setParameter(paramName, paramValue);
                }
            }
        }
        return element;
    }

    public static void setProgram(TGProperties properties, String prefix, TGProgram program) {
        if (program.getReceiver() != null) {
            TGProgramPropertiesUtil.setElement(properties, prefix, program.getReceiver());
            TGPropertiesUtil.setValue((TGProperties)properties, (String)(prefix + ".output.count"), (int)program.countOutputs());
            for (int i = 0; i < program.countOutputs(); ++i) {
                TGProgramElement processor = program.getOutput(i);
                if (processor == null) continue;
                TGProgramPropertiesUtil.setElement(properties, prefix + ".output." + i, processor);
            }
        }
    }

    public static void setElement(TGProperties properties, String prefix, TGProgramElement element) {
        if (element.getId() != null && element.getType() != null) {
            TGPropertiesUtil.setValue((TGProperties)properties, (String)(prefix + ".id"), (String)element.getId());
            TGPropertiesUtil.setValue((TGProperties)properties, (String)(prefix + ".type"), (String)element.getType());
            TGPropertiesUtil.setValue((TGProperties)properties, (String)(prefix + ".enabled"), (boolean)element.isEnabled());
            Set<Map.Entry<String, String>> parameters = element.getParameters().entrySet();
            TGPropertiesUtil.setValue((TGProperties)properties, (String)(prefix + ".param.count"), (int)parameters.size());
            int index = 0;
            for (Map.Entry<String, String> parameter : parameters) {
                TGPropertiesUtil.setValue((TGProperties)properties, (String)(prefix + ".param." + index + ".name"), (String)parameter.getKey());
                TGPropertiesUtil.setValue((TGProperties)properties, (String)(prefix + ".param." + index + ".value"), (String)parameter.getValue());
                ++index;
            }
        }
    }
}

