/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.midi.synth;

import app.tuxguitar.midi.synth.TGAudioBuffer;
import app.tuxguitar.midi.synth.TGSynthesizer;
import app.tuxguitar.util.TGException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class TGAudioLine {
    public static final AudioFormat AUDIO_FORMAT = new AudioFormat(44100.0f, 16, 2, true, false);
    private SourceDataLine line;

    public TGAudioLine(TGSynthesizer synthesizer) {
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(SourceDataLine.class, AUDIO_FORMAT));
            this.line.open(AUDIO_FORMAT, 2048 * Math.max(synthesizer.getSettings().getAudioBufferSize(), 1));
            this.line.start();
        }
        catch (Throwable e) {
            throw new TGException(e);
        }
    }

    public void write(TGAudioBuffer buffer) {
        this.line.write(buffer.getBuffer(), 0, buffer.getLength());
    }
}

