/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.player.impl.midiport.lv2;

import app.tuxguitar.midi.synth.TGAudioBuffer;
import app.tuxguitar.midi.synth.remote.TGRemoteException;
import app.tuxguitar.player.impl.midiport.lv2.jni.LV2Plugin;
import app.tuxguitar.player.impl.midiport.lv2.remote.LV2RemoteInstance;
import app.tuxguitar.util.TGContext;
import java.util.ArrayList;
import java.util.List;

public class LV2AudioProcessor {
    public static final int BUFFER_SIZE = 512;
    public static final float SAMPLE_RATE = 44100.0f;
    private Object lock = new Object();
    private TGContext context;
    private LV2Plugin plugin;
    private LV2RemoteInstance instance;
    private LV2AudioProcessorUpdateCallback updateCallback;
    private List<byte[]> messages;
    private float[][] inputs;
    private float[][] outputs;

    public LV2AudioProcessor(TGContext context, LV2Plugin plugin) throws TGRemoteException {
        this.context = context;
        this.plugin = plugin;
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        Object object = this.lock;
        synchronized (object) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws TGRemoteException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen()) {
                this.instance = new LV2RemoteInstance(this.context, this.plugin, 512);
                this.messages = new ArrayList<byte[]>();
                this.inputs = new float[this.plugin.getAudioInputPortCount()][512];
                this.outputs = new float[this.plugin.getAudioOutputPortCount()][512];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                this.instance.closeUI();
                this.instance.close();
                this.instance = null;
            }
        }
    }

    public boolean isOpen() {
        return this.instance != null && !this.instance.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMidiMessage(byte[] midiMessage) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                this.messages.add(midiMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillBuffer(TGAudioBuffer buffer) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                this.processMessages();
                this.processAudio(buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessages() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen() && !this.messages.isEmpty()) {
                this.instance.processMidiMessages(this.messages);
                this.messages.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAudio(TGAudioBuffer buffer) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                if (this.inputs.length > 0) {
                    buffer.read(this.inputs);
                }
                boolean updated = this.instance.processAudio(this.inputs, this.outputs);
                if (this.outputs.length > 0) {
                    buffer.write(this.outputs);
                }
                if (this.updateCallback != null && updated) {
                    this.updateCallback.onUpdate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpdateCallback(LV2AudioProcessorUpdateCallback updateCallback) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                this.updateCallback = updateCallback;
            }
        }
    }

    public LV2Plugin getPlugin() {
        return this.plugin;
    }

    public LV2RemoteInstance getInstance() {
        return this.instance;
    }

    public static interface LV2AudioProcessorUpdateCallback {
        public void onUpdate();
    }
}

