/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.jack.sequencer;

import app.tuxguitar.jack.JackClient;
import app.tuxguitar.jack.provider.JackClientProvider;
import app.tuxguitar.jack.sequencer.JackSequencer;
import app.tuxguitar.player.base.MidiPlayerException;
import app.tuxguitar.player.base.MidiSequencer;
import app.tuxguitar.player.base.MidiSequencerProvider;
import app.tuxguitar.util.TGContext;
import java.util.ArrayList;
import java.util.List;

public class JackSequencerProvider
implements MidiSequencerProvider {
    private TGContext context;
    private List<MidiSequencer> jackSequencers;
    private JackClientProvider jackClientProvider;

    public JackSequencerProvider(TGContext context, JackClientProvider jackClientProvider) {
        this.context = context;
        this.jackClientProvider = jackClientProvider;
        this.jackSequencers = new ArrayList<MidiSequencer>();
    }

    public List<MidiSequencer> listSequencers() throws MidiPlayerException {
        JackClient jackClient;
        if (this.jackSequencers.isEmpty() && (jackClient = this.jackClientProvider.getJackClient()) != null) {
            this.jackSequencers.add(new JackSequencer(this.context, jackClient));
        }
        return this.jackSequencers;
    }

    public void clearSequencers() throws MidiPlayerException {
        this.jackSequencers.clear();
    }

    public void closeAll() throws MidiPlayerException {
        for (MidiSequencer sequencer : this.listSequencers()) {
            sequencer.close();
        }
        this.clearSequencers();
    }
}

