/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.jack.sequencer;

import app.tuxguitar.jack.sequencer.JackEvent;
import app.tuxguitar.jack.sequencer.JackSequencer;
import app.tuxguitar.player.base.MidiPlayerException;

public class JackEventDispacher {
    private JackSequencer sequencer;

    public JackEventDispacher(JackSequencer sequencer) {
        this.sequencer = sequencer;
    }

    public void dispatch(JackEvent event) throws MidiPlayerException {
        if (event.getType() == 2) {
            this.sequencer.getTransmitter().sendNoteOn((int)event.getData()[0], (int)event.getData()[1], (int)event.getData()[2], (int)event.getData()[3], event.getData()[4] == 1);
        } else if (event.getType() == 3) {
            this.sequencer.getTransmitter().sendNoteOff((int)event.getData()[0], (int)event.getData()[1], (int)event.getData()[2], (int)event.getData()[3], event.getData()[4] == 1);
        } else if (event.getType() == 6) {
            this.sequencer.getTransmitter().sendPitchBend((int)event.getData()[0], (int)event.getData()[1], (int)event.getData()[2], event.getData()[3] == 1);
        } else if (event.getType() == 5) {
            this.sequencer.getTransmitter().sendControlChange((int)event.getData()[0], (int)event.getData()[1], (int)event.getData()[2]);
        } else if (event.getType() == 4) {
            this.sequencer.getTransmitter().sendProgramChange((int)event.getData()[0], (int)event.getData()[1]);
        } else if (event.getType() == 1 && event.getData()[0] == 81) {
            int usq = event.getData()[1] & 0xFF | (event.getData()[2] & 0xFF) << 8 | (event.getData()[3] & 0xFF) << 16;
            this.sequencer.setTempo((int)(60000.0 / ((double)usq / 1000.0)));
        }
    }
}

