/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.gtp;

import app.tuxguitar.io.gtp.GTPSettings;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.configuration.TGConfigManager;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;

public class GTPSettingsManager {
    public static final String KEY_CHARSET = "charset";
    private TGContext context;
    private TGConfigManager config;
    private GTPSettings settings;

    private GTPSettingsManager(TGContext context) {
        this.context = context;
        this.settings = new GTPSettings();
        this.loadSettings();
    }

    public GTPSettings getSettings() {
        return this.settings;
    }

    public TGConfigManager getConfig() {
        if (this.config == null) {
            this.config = new TGConfigManager(this.context, "tuxguitar-gtp");
        }
        return this.config;
    }

    public void loadSettings() {
        String charsetDefault = System.getProperty("file.encoding");
        if (charsetDefault == null) {
            charsetDefault = "UTF-8";
        }
        this.settings.setCharset(this.getConfig().getStringValue(KEY_CHARSET, charsetDefault));
    }

    public void saveSettings() {
        this.getConfig().setValue(KEY_CHARSET, this.settings.getCharset());
        this.getConfig().save();
    }

    public static GTPSettingsManager getInstance(TGContext context) {
        return (GTPSettingsManager)TGSingletonUtil.getInstance((TGContext)context, (String)GTPSettingsManager.class.getName(), (TGSingletonFactory)new TGSingletonFactory<GTPSettingsManager>(){

            public GTPSettingsManager createInstance(TGContext context) {
                return new GTPSettingsManager(context);
            }
        });
    }
}

