/*
 * Decompiled with CFR 0.152.
 */
package media.sound;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import media.sound.SoftSynthesizer;

public class SoftMidiAudioFileReader
extends AudioFileReader {
    public static final AudioFileFormat.Type MIDI = new AudioFileFormat.Type("MIDI", "mid");
    private static AudioFormat format = new AudioFormat(44100.0f, 16, 2, true, false);

    public AudioFileFormat getAudioFileFormat(Sequence seq) throws UnsupportedAudioFileException, IOException {
        long totallen = seq.getMicrosecondLength() / 1000000L;
        long len = (long)(format.getFrameRate() * (float)(totallen + 4L));
        return new AudioFileFormat(MIDI, format, (int)len);
    }

    public AudioInputStream getAudioInputStream(Sequence seq) throws UnsupportedAudioFileException, IOException {
        Receiver recv;
        AudioInputStream stream;
        SoftSynthesizer synth = new SoftSynthesizer();
        try {
            stream = synth.openStream(format, null);
            recv = synth.getReceiver();
        }
        catch (MidiUnavailableException e) {
            throw new IOException(e.toString());
        }
        float divtype = seq.getDivisionType();
        Track[] tracks = seq.getTracks();
        int[] trackspos = new int[tracks.length];
        int mpq = 500000;
        int seqres = seq.getResolution();
        long lasttick = 0L;
        long curtime = 0L;
        while (true) {
            MidiEvent selevent = null;
            int seltrack = -1;
            for (int i = 0; i < tracks.length; ++i) {
                int trackpos = trackspos[i];
                Track track = tracks[i];
                if (trackpos >= track.size()) continue;
                MidiEvent event = track.get(trackpos);
                if (selevent != null && event.getTick() >= selevent.getTick()) continue;
                selevent = event;
                seltrack = i;
            }
            if (seltrack == -1) break;
            int n = seltrack;
            trackspos[n] = trackspos[n] + 1;
            long tick = selevent.getTick();
            curtime = divtype == 0.0f ? (curtime += (tick - lasttick) * (long)mpq / (long)seqres) : (long)((double)tick * 1000000.0 * (double)divtype / (double)seqres);
            lasttick = tick;
            MidiMessage msg = selevent.getMessage();
            if (msg instanceof MetaMessage) {
                if (divtype != 0.0f || ((MetaMessage)msg).getType() != 81) continue;
                byte[] data = ((MetaMessage)msg).getData();
                mpq = (data[0] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[2] & 0xFF;
                continue;
            }
            recv.send(msg, curtime);
        }
        long totallen = curtime / 1000000L;
        long len = (long)(stream.getFormat().getFrameRate() * (float)(totallen + 4L));
        stream = new AudioInputStream(stream, stream.getFormat(), len);
        return stream;
    }

    @Override
    public AudioInputStream getAudioInputStream(InputStream inputstream) throws UnsupportedAudioFileException, IOException {
        Sequence seq;
        inputstream.mark(200);
        try {
            seq = MidiSystem.getSequence(inputstream);
        }
        catch (InvalidMidiDataException e) {
            inputstream.reset();
            throw new UnsupportedAudioFileException();
        }
        catch (IOException e) {
            inputstream.reset();
            throw new UnsupportedAudioFileException();
        }
        return this.getAudioInputStream(seq);
    }

    @Override
    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        Sequence seq;
        try {
            seq = MidiSystem.getSequence(url);
        }
        catch (InvalidMidiDataException e) {
            throw new UnsupportedAudioFileException();
        }
        catch (IOException e) {
            throw new UnsupportedAudioFileException();
        }
        return this.getAudioFileFormat(seq);
    }

    @Override
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        Sequence seq;
        try {
            seq = MidiSystem.getSequence(file);
        }
        catch (InvalidMidiDataException e) {
            throw new UnsupportedAudioFileException();
        }
        catch (IOException e) {
            throw new UnsupportedAudioFileException();
        }
        return this.getAudioFileFormat(seq);
    }

    @Override
    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        Sequence seq;
        try {
            seq = MidiSystem.getSequence(url);
        }
        catch (InvalidMidiDataException e) {
            throw new UnsupportedAudioFileException();
        }
        catch (IOException e) {
            throw new UnsupportedAudioFileException();
        }
        return this.getAudioInputStream(seq);
    }

    @Override
    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        Sequence seq;
        if (!file.getName().toLowerCase().endsWith(".mid")) {
            throw new UnsupportedAudioFileException();
        }
        try {
            seq = MidiSystem.getSequence(file);
        }
        catch (InvalidMidiDataException e) {
            throw new UnsupportedAudioFileException();
        }
        catch (IOException e) {
            throw new UnsupportedAudioFileException();
        }
        return this.getAudioInputStream(seq);
    }

    @Override
    public AudioFileFormat getAudioFileFormat(InputStream inputstream) throws UnsupportedAudioFileException, IOException {
        Sequence seq;
        inputstream.mark(200);
        try {
            seq = MidiSystem.getSequence(inputstream);
        }
        catch (InvalidMidiDataException e) {
            inputstream.reset();
            throw new UnsupportedAudioFileException();
        }
        catch (IOException e) {
            inputstream.reset();
            throw new UnsupportedAudioFileException();
        }
        return this.getAudioFileFormat(seq);
    }
}

