/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.midi;

import app.tuxguitar.io.midi.base.MidiMessage;
import app.tuxguitar.song.models.TGTimeSignature;
import java.nio.charset.Charset;

public class MidiMessageUtils {
    public static final byte TICK_MOVE = 1;

    private static int fixValue(int value) {
        int fixedValue = value;
        fixedValue = Math.min(fixedValue, 127);
        fixedValue = Math.max(fixedValue, 0);
        return fixedValue;
    }

    private static int fixChannel(int channel) {
        int fixedChannel = channel;
        fixedChannel = Math.min(fixedChannel, 15);
        fixedChannel = Math.max(fixedChannel, 0);
        return fixedChannel;
    }

    public static MidiMessage noteOn(int channel, int note, int velocity) {
        return MidiMessage.shortMessage(144, MidiMessageUtils.fixChannel(channel), MidiMessageUtils.fixValue(note), MidiMessageUtils.fixValue(velocity));
    }

    public static MidiMessage noteOff(int channel, int note, int velocity) {
        return MidiMessage.shortMessage(128, MidiMessageUtils.fixChannel(channel), MidiMessageUtils.fixValue(note), MidiMessageUtils.fixValue(velocity));
    }

    public static MidiMessage controlChange(int channel, int controller, int value) {
        return MidiMessage.shortMessage(176, MidiMessageUtils.fixChannel(channel), MidiMessageUtils.fixValue(controller), MidiMessageUtils.fixValue(value));
    }

    public static MidiMessage programChange(int channel, int instrument) {
        return MidiMessage.shortMessage(192, MidiMessageUtils.fixChannel(channel), MidiMessageUtils.fixValue(instrument));
    }

    public static MidiMessage pitchBend(int channel, int value) {
        return MidiMessage.shortMessage(224, MidiMessageUtils.fixChannel(channel), 0, MidiMessageUtils.fixValue(value));
    }

    public static MidiMessage systemReset() {
        return MidiMessage.shortMessage(255);
    }

    public static MidiMessage trackName(String trackName) {
        return MidiMessage.metaMessage(3, trackName.getBytes(Charset.forName("UTF-8")));
    }

    public static MidiMessage tempoInUSQ(int usq) {
        MidiMessage message = new MidiMessage(2, 81);
        message.setData(new byte[]{(byte)(usq >> 16 & 0xFF), (byte)(usq >> 8 & 0xFF), (byte)(usq & 0xFF)});
        return message;
    }

    public static MidiMessage timeSignature(TGTimeSignature ts) {
        MidiMessage message = new MidiMessage(2, 88);
        message.setData(new byte[]{(byte)ts.getNumerator(), (byte)ts.getDenominator().getIndex(), (byte)(96 / ts.getDenominator().getValue()), 8});
        return message;
    }

    public static MidiMessage endOfTrack() {
        return MidiMessage.metaMessage(47, new byte[0]);
    }
}

