/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.synth;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.main.TGWindow;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.io.synth.TGSynthAudioSettings;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIDropDownSelect;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UISelectItem;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class TGSynthSettingsDialog {
    private TGContext context;

    public TGSynthSettingsDialog(TGContext context) {
        this.context = context;
    }

    public void open(final TGSynthAudioSettings settings, final Runnable onSuccess) {
        final List<MidiToAudioFormat> formats = this.getAvailableFormats();
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UIWindow uiParent = TGWindow.getInstance((TGContext)this.context).getWindow();
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty((String)"tuxguitar-synth-export.options"));
        UITableLayout audioFormatLayout = new UITableLayout();
        UILegendPanel audioFormatGroup = uiFactory.createLegendPanel((UIContainer)dialog);
        audioFormatGroup.setLayout((UILayout)audioFormatLayout);
        audioFormatGroup.setText(TuxGuitar.getProperty((String)"tuxguitar-synth-export.options.audio-format"));
        dialogLayout.set((UIControl)audioFormatGroup, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(400.0f), null, null);
        UILabel eLabel = uiFactory.createLabel((UIContainer)audioFormatGroup);
        eLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-synth-export.options.file-encoding") + ":");
        audioFormatLayout.set((UIControl)eLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UIDropDownSelect eCombo = uiFactory.createDropDownSelect((UIContainer)audioFormatGroup);
        audioFormatLayout.set((UIControl)eCombo, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UILabel tLabel = uiFactory.createLabel((UIContainer)audioFormatGroup);
        tLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-synth-export.options.file-type") + ":");
        audioFormatLayout.set((UIControl)tLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UIDropDownSelect tCombo = uiFactory.createDropDownSelect((UIContainer)audioFormatGroup);
        audioFormatLayout.set((UIControl)tCombo, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        MidiToAudioFormat selectedFormat = null;
        for (MidiToAudioFormat format : formats) {
            eCombo.addItem(new UISelectItem(format.getFormat().getEncoding().toString(), (Object)format));
            if (!this.isSameEncoding(settings.getFormat(), format.getFormat())) continue;
            selectedFormat = format;
        }
        if (selectedFormat != null) {
            eCombo.setSelectedValue(selectedFormat);
            this.updateTypesCombo(settings, formats, (UIDropDownSelect<MidiToAudioFormat>)eCombo, (UIDropDownSelect<AudioFileFormat.Type>)tCombo);
        }
        eCombo.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGSynthSettingsDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                this.this$0.updateTypesCombo(settings, formats, (UIDropDownSelect<MidiToAudioFormat>)eCombo, (UIDropDownSelect<AudioFileFormat.Type>)tCombo);
            }
        });
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGSynthSettingsDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                AudioFileFormat.Type type = (AudioFileFormat.Type)tCombo.getSelectedValue();
                MidiToAudioFormat format = (MidiToAudioFormat)eCombo.getSelectedValue();
                dialog.dispose();
                if (format != null && type != null) {
                    settings.setType(type);
                    settings.setFormat(format.getFormat());
                    onSuccess.run();
                }
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGSynthSettingsDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog((UIWindow)dialog, (int)5);
    }

    private void updateTypesCombo(TGSynthAudioSettings settings, List<MidiToAudioFormat> encodings, UIDropDownSelect<MidiToAudioFormat> eCombo, UIDropDownSelect<AudioFileFormat.Type> tCombo) {
        tCombo.removeItems();
        MidiToAudioFormat encoding = (MidiToAudioFormat)eCombo.getSelectedValue();
        if (encoding != null) {
            for (AudioFileFormat.Type type : encoding.getTypes()) {
                tCombo.addItem(new UISelectItem(type.toString() + " (*." + type.getExtension() + ")", (Object)type));
            }
            tCombo.setSelectedValue((Object)settings.getType());
        }
    }

    public List<MidiToAudioFormat> getAvailableFormats() {
        ArrayList<MidiToAudioFormat> list = new ArrayList<MidiToAudioFormat>();
        AudioFormat srcFormat = TGSynthAudioSettings.DEFAULT_FORMAT;
        AudioFormat.Encoding[] encodings = AudioSystem.getTargetEncodings(srcFormat);
        for (int i = 0; i < encodings.length; ++i) {
            AudioFormat dstFormat = new AudioFormat(encodings[i], srcFormat.getSampleRate(), srcFormat.getSampleSizeInBits(), srcFormat.getChannels(), srcFormat.getFrameSize(), srcFormat.getFrameRate(), srcFormat.isBigEndian());
            AudioInputStream dstStream = new AudioInputStream(null, dstFormat, 0L);
            AudioFileFormat.Type[] dstTypes = AudioSystem.getAudioFileTypes(dstStream);
            if (dstTypes.length <= 0) continue;
            list.add(new MidiToAudioFormat(dstFormat, dstTypes));
        }
        return list;
    }

    public boolean isSameEncoding(AudioFormat f1, AudioFormat f2) {
        if (f1 == null || f2 == null || f1.getEncoding() == null || f2.getEncoding() == null) {
            return false;
        }
        return f1.getEncoding().toString().equals(f2.getEncoding().toString());
    }

    private class MidiToAudioFormat {
        private AudioFormat format;
        private AudioFileFormat.Type[] types;

        public MidiToAudioFormat(AudioFormat format, AudioFileFormat.Type[] types) {
            this.format = format;
            this.types = types;
        }

        public AudioFormat getFormat() {
            return this.format;
        }

        public AudioFileFormat.Type[] getTypes() {
            return this.types;
        }
    }
}

