/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.svg;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.main.TGWindow;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.io.svg.SVGStyles;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UICheckBox;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIDropDownSelect;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UISelectItem;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;

public class SVGStylesDialog
extends SVGStyles {
    private TGContext context;

    public SVGStylesDialog(TGContext context) {
        this.context = context;
    }

    public void configure(final Runnable onSuccess) {
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UIWindow uiParent = TGWindow.getInstance((TGContext)this.context).getWindow();
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty((String)"options"));
        UITableLayout trackLayout = new UITableLayout();
        UILegendPanel track = uiFactory.createLegendPanel((UIContainer)dialog);
        track.setLayout((UILayout)trackLayout);
        track.setText(TuxGuitar.getProperty((String)"track"));
        dialogLayout.set((UIControl)track, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(300.0f), null, null);
        final UILabel trackLabel = uiFactory.createLabel((UIContainer)track);
        trackLabel.setText(TuxGuitar.getProperty((String)"track") + ":");
        trackLayout.set((UIControl)trackLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UIDropDownSelect trackCombo = uiFactory.createDropDownSelect((UIContainer)track);
        TGSong song = TuxGuitar.getInstance().getDocumentManager().getSong();
        for (int number = 1; number <= song.countTracks(); ++number) {
            trackCombo.addItem(new UISelectItem(TuxGuitar.getInstance().getSongManager().getTrack(song, number).getName(), (Object)number));
        }
        trackCombo.setSelectedValue((Object)TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack().getNumber());
        trackLayout.set((UIControl)trackCombo, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
        final UICheckBox trackAllCheck = uiFactory.createCheckBox((UIContainer)track);
        trackAllCheck.setText(TuxGuitar.getProperty((String)"export.all-tracks"));
        trackAllCheck.setSelected(false);
        trackAllCheck.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ SVGStylesDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                trackLabel.setEnabled(!trackAllCheck.isSelected());
                trackCombo.setEnabled(!trackAllCheck.isSelected());
            }
        });
        trackLayout.set((UIControl)trackAllCheck, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(2));
        UITableLayout optionsLayout = new UITableLayout();
        UILegendPanel options = uiFactory.createLegendPanel((UIContainer)dialog);
        options.setLayout((UILayout)optionsLayout);
        options.setText(TuxGuitar.getProperty((String)"options"));
        dialogLayout.set((UIControl)options, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(300.0f), null, null);
        final UICheckBox tablatureEnabled = uiFactory.createCheckBox((UIContainer)options);
        tablatureEnabled.setText(TuxGuitar.getProperty((String)"export.tablature-enabled"));
        tablatureEnabled.setSelected(true);
        optionsLayout.set((UIControl)tablatureEnabled, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
        final UICheckBox scoreEnabled = uiFactory.createCheckBox((UIContainer)options);
        scoreEnabled.setText(TuxGuitar.getProperty((String)"export.score-enabled"));
        scoreEnabled.setSelected(true);
        optionsLayout.set((UIControl)scoreEnabled, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
        final UICheckBox chordNameEnabled = uiFactory.createCheckBox((UIContainer)options);
        chordNameEnabled.setText(TuxGuitar.getProperty((String)"export.chord-name-enabled"));
        chordNameEnabled.setSelected(true);
        optionsLayout.set((UIControl)chordNameEnabled, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
        final UICheckBox chordDiagramEnabled = uiFactory.createCheckBox((UIContainer)options);
        chordDiagramEnabled.setText(TuxGuitar.getProperty((String)"export.chord-diagram-enabled"));
        chordDiagramEnabled.setSelected(true);
        optionsLayout.set((UIControl)chordDiagramEnabled, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
        tablatureEnabled.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ SVGStylesDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                if (!tablatureEnabled.isSelected()) {
                    scoreEnabled.setSelected(true);
                }
            }
        });
        scoreEnabled.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ SVGStylesDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                if (!scoreEnabled.isSelected()) {
                    tablatureEnabled.setSelected(true);
                }
            }
        });
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ SVGStylesDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                Integer selectedTrack = (Integer)trackCombo.getSelectedValue();
                int track = trackAllCheck.isSelected() || selectedTrack == null ? -1 : selectedTrack;
                boolean showScore = scoreEnabled.isSelected();
                boolean showTablature = tablatureEnabled.isSelected();
                boolean showChordName = chordNameEnabled.isSelected();
                boolean showChordDiagram = chordDiagramEnabled.isSelected();
                this.this$0.configure(track, showScore, showTablature, showChordName, showChordDiagram);
                dialog.dispose();
                onSuccess.run();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ SVGStylesDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog((UIWindow)dialog, (int)5);
    }

    public void configure(int track, boolean showScore, boolean showTablature, boolean showChordName, boolean showChordDiagram) {
        this.configureWithDefaults();
        this.setTrack(track);
        this.setFlags(1);
        if (showScore) {
            this.setFlags(this.getFlags() | 4);
        }
        if (showTablature) {
            this.setFlags(this.getFlags() | 8);
        }
        if (showChordName) {
            this.setFlags(this.getFlags() | 0x10);
        }
        if (showChordDiagram) {
            this.setFlags(this.getFlags() | 0x20);
        }
        if (track < 0) {
            this.setFlags(this.getFlags() | 2);
        }
    }
}

