/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.ptb.helper;

public class TrackStartHelper {
    private int section;
    private long[][] voices;
    private boolean measureEmpty;
    private boolean measureRest;
    private long barStart;
    private long barLength;

    public void init(int section, int staffs) {
        this.section = section;
        this.voices = new long[staffs][2];
        this.measureEmpty = true;
        this.measureRest = false;
        this.barStart = 0L;
        this.barLength = 0L;
    }

    public int getSection() {
        return this.section;
    }

    public void initVoices(long start) {
        for (int i = 0; i < this.voices.length; ++i) {
            for (int j = 0; j < this.voices[i].length; ++j) {
                this.voices[i][j] = this.fixValue(start);
            }
        }
        this.measureEmpty = true;
        this.measureRest = false;
    }

    public long getMaxStart() {
        long result = 960L;
        for (int i = 0; i < this.voices.length; ++i) {
            for (int j = 0; j < this.voices[i].length; ++j) {
                result = Math.max(result, this.voices[i][j]);
            }
        }
        if (this.measureRest && this.measureEmpty) {
            result = Math.max(result, this.barStart + this.barLength);
        }
        return this.fixValue(result);
    }

    public long getVoiceStart(int staff, int voice) {
        return this.voices[staff][voice];
    }

    public void setVoiceStart(int staff, int voice, long start) {
        this.voices[staff][voice] = this.fixValue(start);
    }

    public long getBarStart() {
        return this.barStart;
    }

    public void setBarStart(long barStart) {
        this.barStart = barStart;
    }

    public long getBarLength() {
        return this.barLength;
    }

    public void setBarLength(long barLength) {
        this.barLength = barLength;
    }

    public void checkBeat(boolean rest) {
        this.measureEmpty = this.measureEmpty && rest;
        this.measureRest = true;
    }

    public long fixValue(long value) {
        return value % 480L + 10L > 480L ? value + (480L - value % 480L) : value;
    }
}

