/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.ptb;

import app.tuxguitar.io.base.TGFileFormat;
import app.tuxguitar.io.base.TGFileFormatDetector;
import app.tuxguitar.io.ptb.PTInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PTFileFormatDetector
implements TGFileFormatDetector {
    public static final String PTB_VERSION = "ptab-4";

    public TGFileFormat getFileFormat(InputStream is) {
        try {
            String version = this.readVersion(is);
            if (PTB_VERSION.equals(version)) {
                return PTInputStream.FILE_FORMAT;
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private String readVersion(InputStream is) {
        try {
            byte[] ptabHeader = new byte[4];
            byte[] ptabVersion = new byte[]{0, 0};
            is.read(ptabHeader);
            is.read(ptabVersion);
            String header = new String(ptabHeader);
            String version = String.valueOf((ptabVersion[1] & 0xFF) << 8 | ptabVersion[0] & 0xFF);
            return new String(header + "-" + version);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

