/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.tg.v08;

import app.tuxguitar.io.base.TGFileFormat;
import app.tuxguitar.io.base.TGFileFormatException;
import app.tuxguitar.io.base.TGSongReader;
import app.tuxguitar.io.base.TGSongReaderHandle;
import app.tuxguitar.io.tg.TGFileFormatVersion;
import app.tuxguitar.io.tg.v08.TGStream;
import app.tuxguitar.io.tg.v15.TGFileFormatDetectorImpl;
import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGChannel;
import app.tuxguitar.song.models.TGChannelParameter;
import app.tuxguitar.song.models.TGColor;
import app.tuxguitar.song.models.TGDivisionType;
import app.tuxguitar.song.models.TGDuration;
import app.tuxguitar.song.models.TGMarker;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGMeasureHeader;
import app.tuxguitar.song.models.TGNote;
import app.tuxguitar.song.models.TGNoteEffect;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.song.models.TGString;
import app.tuxguitar.song.models.TGTempo;
import app.tuxguitar.song.models.TGTimeSignature;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.song.models.TGVoice;
import app.tuxguitar.song.models.effects.TGEffectBend;
import java.io.DataInputStream;
import java.io.IOException;

public class TGSongReaderImpl
extends TGStream
implements TGSongReader {
    public static final TGFileFormatVersion SUPPORTED_FORMAT = new TGFileFormatVersion(TG_FORMAT, "TG_DEVEL-0.8");
    private DataInputStream dataInputStream;
    private TGFactory factory;

    public TGFileFormat getFileFormat() {
        return TG_FORMAT;
    }

    public void read(TGSongReaderHandle handle) throws TGFileFormatException {
        try {
            this.factory = handle.getFactory();
            this.dataInputStream = new DataInputStream(handle.getInputStream());
            TGFileFormat fileFormat = new TGFileFormatDetectorImpl(SUPPORTED_FORMAT).getFileFormat(this.dataInputStream);
            if (fileFormat == null || !fileFormat.equals((Object)this.getFileFormat())) {
                throw new TGFileFormatException("error.unsupported-version");
            }
            TGSong song = this.read();
            this.dataInputStream.close();
            handle.setSong(song);
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable);
        }
    }

    private TGSong read() {
        TGSong song = this.factory.newSong();
        song.setName(this.readString());
        song.setArtist(this.readString());
        song.setAlbum(this.readString());
        song.setAuthor(this.readString());
        int headerCount = this.readShort();
        long headerStart = 960L;
        TGMeasureHeader lastHeader = null;
        for (int i = 0; i < headerCount; ++i) {
            TGMeasureHeader header = this.readMeasureHeader(i + 1, headerStart, lastHeader);
            song.addMeasureHeader(header);
            headerStart += header.getLength();
            lastHeader = header;
        }
        int trackCount = this.readByte();
        for (int i = 0; i < trackCount; ++i) {
            song.addTrack(this.readTrack(i + 1, song));
        }
        return song;
    }

    private TGTrack readTrack(int number, TGSong song) {
        TGTrack track = this.factory.newTrack();
        track.setNumber(number);
        track.setName(this.readString());
        this.readChannel(song, track);
        int measureCount = song.countMeasureHeaders();
        TGMeasure lastMeasure = null;
        for (int i = 0; i < measureCount; ++i) {
            TGMeasure measure = this.readMeasure(song.getMeasureHeader(i), lastMeasure);
            track.addMeasure(measure);
            lastMeasure = measure;
        }
        int stringCount = this.readByte();
        for (int i = 0; i < stringCount; ++i) {
            track.getStrings().add(this.readInstrumentString(i + 1));
        }
        track.setOffset(-24 + this.readByte());
        this.readColor(track.getColor());
        return track;
    }

    private TGMeasureHeader readMeasureHeader(int number, long start, TGMeasureHeader lastMeasureHeader) {
        int header = this.readHeader();
        TGMeasureHeader measureHeader = this.factory.newHeader();
        measureHeader.setNumber(number);
        measureHeader.setStart(start);
        if ((header & 1) != 0) {
            this.readTimeSignature(measureHeader.getTimeSignature());
        } else if (lastMeasureHeader != null) {
            measureHeader.getTimeSignature().copyFrom(lastMeasureHeader.getTimeSignature());
        }
        if ((header & 2) != 0) {
            this.readTempo(measureHeader.getTempo());
        } else if (lastMeasureHeader != null) {
            measureHeader.getTempo().copyFrom(lastMeasureHeader.getTempo());
        }
        measureHeader.setRepeatOpen((header & 4) != 0);
        if ((header & 8) != 0) {
            measureHeader.setRepeatClose((int)this.readShort());
        }
        if ((header & 0x10) != 0) {
            measureHeader.setMarker(this.readMarker(number));
        }
        measureHeader.setTripletFeel(lastMeasureHeader != null ? lastMeasureHeader.getTripletFeel() : 1);
        if ((header & 0x20) != 0) {
            measureHeader.setTripletFeel(this.readByte());
        }
        return measureHeader;
    }

    private TGMeasure readMeasure(TGMeasureHeader measureHeader, TGMeasure lastMeasure) {
        int header = this.readHeader();
        TGMeasure measure = this.factory.newMeasure(measureHeader);
        TGBeat previous = null;
        int componentCount = this.readShort();
        for (int i = 0; i < componentCount; ++i) {
            previous = this.readComponent(measure, previous);
        }
        measure.setClef(lastMeasure == null ? 1 : lastMeasure.getClef());
        if ((header & 1) != 0) {
            measure.setClef(this.readByte());
        }
        measure.setKeySignature(lastMeasure == null ? 0 : lastMeasure.getKeySignature());
        if ((header & 2) != 0) {
            measure.setKeySignature(this.readByte());
        }
        return measure;
    }

    private void readChannel(TGSong song, TGTrack track) {
        int header = this.readHeader();
        TGChannel channel = this.factory.newChannel();
        TGChannelParameter gmChannel1Param = this.factory.newChannelParameter();
        TGChannelParameter gmChannel2Param = this.factory.newChannelParameter();
        int channel1 = this.readByte() & 0xFF;
        gmChannel1Param.setKey("gm-channel-1");
        gmChannel1Param.setValue(Integer.toString(channel1));
        int channel2 = this.readByte() & 0xFF;
        gmChannel2Param.setKey("gm-channel-2");
        gmChannel2Param.setValue(Integer.toString(channel2));
        channel.setBank(channel1 == 9 ? (short)128 : 0);
        channel.setProgram((short)this.readByte());
        channel.setVolume((short)this.readByte());
        channel.setBalance((short)this.readByte());
        channel.setChorus((short)this.readByte());
        channel.setReverb((short)this.readByte());
        channel.setPhaser((short)this.readByte());
        channel.setTremolo((short)this.readByte());
        track.setSolo((header & 1) != 0);
        track.setMute((header & 2) != 0);
        for (int i = 0; i < song.countChannels(); ++i) {
            TGChannel channelAux = song.getChannel(i);
            for (int n = 0; n < channelAux.countParameters(); ++n) {
                TGChannelParameter channelParameter = channelAux.getParameter(n);
                if (!channelParameter.getKey().equals("gm-channel-1") || !Integer.toString(channel1).equals(channelParameter.getValue())) continue;
                channel.setChannelId(channelAux.getChannelId());
            }
        }
        if (channel.getChannelId() <= 0) {
            channel.setChannelId(song.countChannels() + 1);
            channel.setName(new TGSongManager(this.factory).createChannelNameFromProgram(song, channel));
            channel.addParameter(gmChannel1Param);
            channel.addParameter(gmChannel2Param);
            song.addChannel(channel);
        }
        track.setChannelId(channel.getChannelId());
    }

    private TGBeat readComponent(TGMeasure measure, TGBeat previous) {
        TGBeat beat = previous;
        int header = this.readHeader();
        if (beat == null) {
            beat = this.factory.newBeat();
            beat.setStart(measure.getStart());
            measure.addBeat(beat);
        } else if ((header & 0x10) != 0) {
            beat = this.factory.newBeat();
            beat.setStart(previous.getStart() + previous.getVoice(0).getDuration().getTime());
            measure.addBeat(beat);
        }
        TGVoice voice = beat.getVoice(0);
        voice.setEmpty(false);
        if ((header & 0x20) != 0) {
            this.readDuration(voice.getDuration());
        } else if (previous != null && !previous.equals(beat)) {
            voice.getDuration().copyFrom(previous.getVoice(0).getDuration());
        }
        if ((header & 1) != 0) {
            TGNote note = this.factory.newNote();
            note.setValue(this.readByte());
            note.setVelocity(this.readByte());
            note.setString(this.readByte());
            note.setTiedNote((header & 4) != 0);
            if ((header & 8) != 0) {
                this.readNoteEffect(note.getEffect());
            }
            voice.addNote(note);
        }
        return beat;
    }

    private TGString readInstrumentString(int number) {
        TGString string = this.factory.newString();
        string.setNumber(number);
        string.setValue(this.readByte());
        return string;
    }

    private void readTempo(TGTempo tempo) {
        tempo.setQuarterValue((int)this.readShort());
    }

    private void readTimeSignature(TGTimeSignature timeSignature) {
        timeSignature.setNumerator(this.readByte());
        this.readDuration(timeSignature.getDenominator());
    }

    private void readDuration(TGDuration duration) {
        int header = this.readHeader();
        duration.setDotted((header & 1) != 0);
        duration.setDoubleDotted((header & 2) != 0);
        duration.setValue(this.readByte());
        if ((header & 4) != 0) {
            this.readDivisionType(duration.getDivision());
        }
    }

    private void readDivisionType(TGDivisionType divisionType) {
        divisionType.setEnters(this.readByte());
        divisionType.setTimes(this.readByte());
    }

    private void readNoteEffect(TGNoteEffect effect) {
        int header = this.readHeader();
        effect.setVibrato((header & 1) != 0);
        effect.setDeadNote((header & 4) != 0);
        effect.setSlide((header & 8) != 0);
        effect.setHammer((header & 0x10) != 0);
        if ((header & 2) != 0) {
            effect.setBend(this.readBendEffect());
        }
    }

    private TGEffectBend readBendEffect() {
        TGEffectBend bend = this.factory.newEffectBend();
        int count = this.readByte();
        for (int i = 0; i < count; ++i) {
            int position = this.readByte();
            int value = this.readByte();
            bend.addPoint(position, value > 0 ? value / 2 : value);
        }
        return bend;
    }

    private TGMarker readMarker(int measure) {
        TGMarker marker = this.factory.newMarker();
        marker.setMeasure(measure);
        marker.setTitle(this.readString());
        this.readColor(marker.getColor());
        return marker;
    }

    private void readColor(TGColor color) {
        color.setR((int)this.readShort());
        color.setG((int)this.readShort());
        color.setB((int)this.readShort());
    }

    private int readByte() {
        try {
            return this.dataInputStream.read();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private int readHeader() {
        try {
            return this.dataInputStream.read();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private short readShort() {
        try {
            return this.dataInputStream.readShort();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private String readString() {
        try {
            int length = this.dataInputStream.read();
            char[] chars = new char[length];
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = this.dataInputStream.readChar();
            }
            return String.copyValueOf(chars);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

