/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.tools.custom.tuner;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.tools.custom.tuner.TGTunerDialog;
import app.tuxguitar.app.tools.custom.tuner.TGTunerSettings;
import app.tuxguitar.app.util.TGMessageDialogUtil;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIDropDownSelect;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UIScale;
import app.tuxguitar.ui.widget.UISelectItem;
import app.tuxguitar.ui.widget.UITextArea;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;

public class TGTunerSettingsDialog {
    private TGTunerDialog tunerDialog = null;
    private UIDropDownSelect<Float> sampleRateCombo = null;
    private UIDropDownSelect<Integer> sampleSizeCombo = null;
    private UIDropDownSelect<Integer> bufferSizeCombo = null;
    private UIDropDownSelect<Integer> FFTSizeCombo = null;
    private UIScale noiseGate = null;
    private UILabel noiseGateValue = null;
    private UITextArea settingsInfo = null;
    private boolean updated;

    public TGTunerSettingsDialog(TGTunerDialog dialog) {
        this.tunerDialog = dialog;
        this.updated = false;
    }

    public void show() {
        UIFactory uiFactory = this.tunerDialog.getUIFactory();
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(this.tunerDialog.getWindow(), true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        dialog.setText(TuxGuitar.getProperty((String)"tuner.settings"));
        UITableLayout sampleLayout = new UITableLayout();
        UILegendPanel sampleComposite = uiFactory.createLegendPanel((UIContainer)dialog);
        sampleComposite.setLayout((UILayout)sampleLayout);
        sampleComposite.setText(TuxGuitar.getProperty((String)"tuner.sound-format"));
        dialogLayout.set((UIControl)sampleComposite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel sampleRateLabel = uiFactory.createLabel((UIContainer)sampleComposite);
        sampleRateLabel.setText(TuxGuitar.getProperty((String)"tuner.sample-rate") + ":");
        sampleLayout.set((UIControl)sampleRateLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        this.sampleRateCombo = uiFactory.createDropDownSelect((UIContainer)sampleComposite);
        this.sampleRateCombo.addItem(new UISelectItem("48000", (Object)Float.valueOf(48000.0f)));
        this.sampleRateCombo.addItem(new UISelectItem("44100", (Object)Float.valueOf(44100.0f)));
        this.sampleRateCombo.addItem(new UISelectItem("22050", (Object)Float.valueOf(22050.0f)));
        this.sampleRateCombo.addItem(new UISelectItem("11025", (Object)Float.valueOf(11025.0f)));
        this.sampleRateCombo.addItem(new UISelectItem("8000", (Object)Float.valueOf(8000.0f)));
        this.sampleRateCombo.addSelectionListener((UISelectionListener)new UpdatedListener());
        sampleLayout.set(this.sampleRateCombo, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UILabel sampleSizeLabel = uiFactory.createLabel((UIContainer)sampleComposite);
        sampleSizeLabel.setText(TuxGuitar.getProperty((String)"tuner.sample-size") + ":");
        sampleLayout.set((UIControl)sampleSizeLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        this.sampleSizeCombo = uiFactory.createDropDownSelect((UIContainer)sampleComposite);
        this.sampleSizeCombo.addItem(new UISelectItem("16", (Object)16));
        this.sampleSizeCombo.addItem(new UISelectItem("8", (Object)8));
        this.sampleSizeCombo.addSelectionListener((UISelectionListener)new UpdatedListener());
        sampleLayout.set(this.sampleSizeCombo, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UITableLayout analyzeLayout = new UITableLayout();
        UILegendPanel analyzeComposite = uiFactory.createLegendPanel((UIContainer)dialog);
        analyzeComposite.setLayout((UILayout)analyzeLayout);
        analyzeComposite.setText(TuxGuitar.getProperty((String)"tuner.sampling-and-analyze"));
        dialogLayout.set((UIControl)analyzeComposite, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel bufferSizeLabel = uiFactory.createLabel((UIContainer)analyzeComposite);
        bufferSizeLabel.setText(TuxGuitar.getProperty((String)"tuner.sampling-buffer-size") + ":");
        analyzeLayout.set((UIControl)bufferSizeLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        this.bufferSizeCombo = uiFactory.createDropDownSelect((UIContainer)analyzeComposite);
        this.bufferSizeCombo.addItem(new UISelectItem("512", (Object)512));
        this.bufferSizeCombo.addItem(new UISelectItem("1024", (Object)1024));
        this.bufferSizeCombo.addItem(new UISelectItem("2048", (Object)2048));
        this.bufferSizeCombo.addItem(new UISelectItem("4096", (Object)4096));
        this.bufferSizeCombo.addItem(new UISelectItem("8192", (Object)8192));
        this.bufferSizeCombo.addItem(new UISelectItem("16348", (Object)16348));
        this.bufferSizeCombo.addSelectionListener((UISelectionListener)new UpdatedListener());
        analyzeLayout.set(this.bufferSizeCombo, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UILabel FFTSizeLabel = uiFactory.createLabel((UIContainer)analyzeComposite);
        FFTSizeLabel.setText(TuxGuitar.getProperty((String)"tuner.fourier-buffer-size") + ":");
        analyzeLayout.set((UIControl)FFTSizeLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        this.FFTSizeCombo = uiFactory.createDropDownSelect((UIContainer)analyzeComposite);
        this.FFTSizeCombo.addItem(new UISelectItem("1024", (Object)1024));
        this.FFTSizeCombo.addItem(new UISelectItem("2048", (Object)2048));
        this.FFTSizeCombo.addItem(new UISelectItem("4096", (Object)4096));
        this.FFTSizeCombo.addItem(new UISelectItem("8192", (Object)8192));
        this.FFTSizeCombo.addItem(new UISelectItem("16384", (Object)16384));
        this.FFTSizeCombo.addItem(new UISelectItem("32768", (Object)32768));
        this.FFTSizeCombo.addSelectionListener((UISelectionListener)new UpdatedListener());
        analyzeLayout.set(this.FFTSizeCombo, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UITableLayout noiseGateLayout = new UITableLayout();
        final UILegendPanel noiseGateComposite = uiFactory.createLegendPanel((UIContainer)dialog);
        noiseGateComposite.setLayout((UILayout)noiseGateLayout);
        noiseGateComposite.setText(TuxGuitar.getProperty((String)"tuner.noise-gate"));
        dialogLayout.set((UIControl)noiseGateComposite, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.noiseGate = uiFactory.createHorizontalScale((UIContainer)noiseGateComposite);
        this.noiseGate.setMaximum(100);
        this.noiseGate.setIncrement(5);
        this.noiseGate.setIncrement(1);
        this.noiseGate.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGTunerSettingsDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                this.this$0.noiseGateValue.setText(Integer.valueOf(this.this$0.noiseGate.getValue()).toString() + "%");
                noiseGateComposite.layout();
            }
        });
        this.noiseGate.addSelectionListener((UISelectionListener)new UpdatedListener());
        noiseGateLayout.set((UIControl)this.noiseGate, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        this.noiseGateValue = uiFactory.createLabel((UIContainer)noiseGateComposite);
        noiseGateLayout.set((UIControl)this.noiseGateValue, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        UITableLayout infoLayout = new UITableLayout();
        UILegendPanel infoComposite = uiFactory.createLegendPanel((UIContainer)dialog);
        infoComposite.setLayout((UILayout)infoLayout);
        infoComposite.setText(TuxGuitar.getProperty((String)"tuner.info"));
        dialogLayout.set((UIControl)infoComposite, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.settingsInfo = uiFactory.createTextArea((UIContainer)infoComposite, true, false);
        infoLayout.set((UIControl)this.settingsInfo, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(400.0f), Float.valueOf(100.0f), null);
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(5), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGTunerSettingsDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                this.this$0.dispose(dialog, true);
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonExit = uiFactory.createButton((UIContainer)buttons);
        buttonExit.setText(TuxGuitar.getProperty((String)"close"));
        buttonExit.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGTunerSettingsDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                this.this$0.dispose(dialog, false);
            }
        });
        buttonsLayout.set((UIControl)buttonExit, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonExit, "margin_right", (Object)Float.valueOf(0.0f));
        this.loadSettings(this.tunerDialog.getTuner().getSettings(), dialog);
        TGDialogUtil.openDialog((UIWindow)dialog, (int)5);
    }

    private void loadSettings(TGTunerSettings settings, UIWindow dialog) {
        block3: {
            boolean loadedDefaults = false;
            if (settings == null) {
                settings = TGTunerSettings.getDefaults();
                loadedDefaults = true;
            }
            try {
                this.sampleRateCombo.setSelectedValue((Object)Float.valueOf(settings.getSampleRate()));
                this.sampleSizeCombo.setSelectedValue((Object)settings.getSampleSize());
                this.FFTSizeCombo.setSelectedValue((Object)settings.getFFTSize());
                this.bufferSizeCombo.setSelectedValue((Object)settings.getBufferSize());
                this.noiseGate.setValue((int)Math.round(settings.getThreshold() * 100.0));
                this.noiseGateValue.setText(Integer.valueOf(this.noiseGate.getValue()).toString() + "%");
            }
            catch (Exception ex) {
                if (loadedDefaults) break block3;
                TGMessageDialogUtil.errorMessage((TGContext)this.getContext(), (UIWindow)dialog, (String)"Failed to load TuxGuitar settings.\nLoading defaults.");
                this.loadSettings(TGTunerSettings.getDefaults(), dialog);
            }
        }
    }

    private void dispose(UIWindow dialog, boolean saveWanted) {
        try {
            if (this.updated & saveWanted) {
                TGTunerSettings settings = new TGTunerSettings();
                settings.setSampleRate(this.getSampleRate());
                settings.setSampleSize(this.getSampleSize());
                settings.setBufferSize(this.getBufferSize());
                settings.setFFTSize(this.getFFTSize());
                settings.setThreshold((float)this.noiseGate.getValue() / 100.0f);
                settings.setWaitPeriod(100);
                this.checkBufferValues(settings);
                this.tunerDialog.getTuner().setSettings(settings);
            }
            this.tunerDialog.getTuner().resumeFromPause();
            dialog.dispose();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TGMessageDialogUtil.errorMessage((TGContext)this.getContext(), (UIWindow)dialog, (String)ex.getMessage());
        }
    }

    private float getSampleRate() {
        Float value = (Float)this.sampleRateCombo.getSelectedValue();
        return value != null ? value.floatValue() : 0.0f;
    }

    private int getSampleSize() {
        Integer value = (Integer)this.sampleSizeCombo.getSelectedValue();
        return value != null ? value : 0;
    }

    private int getFFTSize() {
        Integer value = (Integer)this.FFTSizeCombo.getSelectedValue();
        return value != null ? value : 0;
    }

    private int getBufferSize() {
        Integer value = (Integer)this.bufferSizeCombo.getSelectedValue();
        return value != null ? value : 0;
    }

    private void checkBufferValues(TGTunerSettings settings) throws Exception {
        if (settings.bufferSize % settings.sampleSize != 0 || settings.bufferSize > settings.fftSize) {
            throw new Exception("Invalid sampling buffer size");
        }
    }

    private TGContext getContext() {
        return this.tunerDialog.getContext();
    }

    private class UpdatedListener
    implements UISelectionListener {
        private UpdatedListener() {
        }

        public void onSelect(UISelectionEvent event) {
            TGTunerSettingsDialog.this.updated = true;
            TGTunerSettingsDialog.this.settingsInfo.setText(" Minimal freq diff = " + this.getMinimalFrequencyDiff() + "Hz   \n Time to fill the buffer = " + this.getTimeToFillBuffer() + " sec");
        }

        private double getMinimalFrequencyDiff() {
            return (double)TGTunerSettingsDialog.this.getSampleRate() / (double)TGTunerSettingsDialog.this.getFFTSize();
        }

        private double getTimeToFillBuffer() {
            return (float)TGTunerSettingsDialog.this.getBufferSize() / TGTunerSettingsDialog.this.getSampleRate();
        }
    }
}

