/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.image;

import app.tuxguitar.app.printer.PrintController;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.graphics.control.TGController;
import app.tuxguitar.graphics.control.TGFactoryImpl;
import app.tuxguitar.graphics.control.print.TGPrintDocument;
import app.tuxguitar.graphics.control.print.TGPrintLayout;
import app.tuxguitar.graphics.control.print.TGPrintPainter;
import app.tuxguitar.io.base.TGFileFormatException;
import app.tuxguitar.io.base.TGSongStream;
import app.tuxguitar.io.base.TGSongStreamContext;
import app.tuxguitar.io.image.ImageExporterSettings;
import app.tuxguitar.io.image.ImageFormat;
import app.tuxguitar.io.image.ImageWriter;
import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.resource.UIImage;
import app.tuxguitar.ui.resource.UIInset;
import app.tuxguitar.ui.resource.UIPainter;
import app.tuxguitar.ui.resource.UIResourceFactory;
import app.tuxguitar.ui.resource.UISize;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.error.TGErrorManager;
import java.util.ArrayList;
import java.util.List;

public class ImageExporterStream
implements TGSongStream {
    private static final int PAGE_WIDTH = 550;
    private static final int PAGE_HEIGHT = 800;
    private static final int MARGIN_TOP = 20;
    private static final int MARGIN_BOTTOM = 20;
    private static final int MARGIN_LEFT = 20;
    private static final int MARGIN_RIGHT = 20;
    private TGContext context;
    private TGSongStreamContext streamContext;

    public ImageExporterStream(TGContext context, TGSongStreamContext streamContext) {
        this.context = context;
        this.streamContext = streamContext;
    }

    public void process() throws TGFileFormatException {
        ImageExporterSettings settings = (ImageExporterSettings)this.streamContext.getAttribute(ImageExporterSettings.class.getName());
        if (settings != null) {
            TGSong song = (TGSong)this.streamContext.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
            TGSongManager manager = new TGSongManager((TGFactory)new TGFactoryImpl());
            TGSong clonedSong = song.clone(manager.getFactory());
            UISize pageSize = new UISize(550.0f, 800.0f);
            UIInset pageMargins = new UIInset(20.0f, 20.0f, 20.0f, 20.0f);
            UIFactory factory = this.getUIFactory();
            PrintController controller = new PrintController(this.context, clonedSong, manager, (UIResourceFactory)factory);
            TGPrintLayout layout = new TGPrintLayout((TGController)controller, settings.getStyles());
            layout.loadStyles(1.0f);
            layout.updateSong();
            layout.makeDocument((TGPrintDocument)new PrintDocumentImpl(pageSize, pageMargins, settings.getFormat(), settings.getPath()));
        }
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance((TGContext)this.context).getFactory();
    }

    private class PrintDocumentImpl
    implements TGPrintDocument {
        private TGPrintPainter painter;
        private UISize size;
        private UIInset margins;
        private String path;
        private List<UIImage> pages;
        private ImageFormat format;

        public PrintDocumentImpl(UISize size, UIInset margins, ImageFormat format, String path) {
            this.size = size;
            this.margins = margins;
            this.path = path;
            this.painter = new TGPrintPainter();
            this.pages = new ArrayList<UIImage>();
            this.format = format;
        }

        public UIPainter getPainter() {
            return this.painter;
        }

        public UISize getSize() {
            return this.size;
        }

        public UIInset getMargins() {
            return this.margins;
        }

        public void pageStart() {
            int width = Math.round(this.size.getWidth());
            int height = Math.round(this.size.getHeight());
            UIFactory factory = ImageExporterStream.this.getUIFactory();
            UIImage page = factory.createImage((float)width, (float)height);
            this.painter.setHandle(page.createPainter());
            this.pages.add(page);
        }

        public void pageFinish() {
            this.painter.dispose();
        }

        public void start() {
        }

        public void finish() {
            try {
                ImageWriter.write(this.format, this.path, this.pages);
                for (UIImage uiImage : this.pages) {
                    uiImage.dispose();
                }
            }
            catch (Throwable throwable) {
                TGErrorManager.getInstance((TGContext)ImageExporterStream.this.context).handleError(throwable);
            }
        }

        public boolean isTransparentBackground() {
            return true;
        }

        public boolean isPaintable(int page) {
            return true;
        }
    }
}

