/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.toolbar.main;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.system.icons.TGIconManager;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.component.tab.TablatureEditor;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBarItemConfig;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBarSection;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.editor.util.TGSyncProcessLocked;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.player.base.MidiPlayer;
import app.tuxguitar.song.models.TGTempo;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UIDisposeEvent;
import app.tuxguitar.ui.event.UIDisposeListener;
import app.tuxguitar.ui.event.UIMouseDownListener;
import app.tuxguitar.ui.event.UIMouseEvent;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIImageView;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.util.TGContext;

public class TGMainToolBarSectionTempo
extends TGMainToolBarSection
implements TGEventListener {
    private UIImageView tempoImage;
    private UILabel tempoLabel;
    private TGSyncProcessLocked redrawProcess;
    private int currentTempoBase;
    private boolean currentTempoDotted;
    private int currentTempoValue;

    public TGMainToolBarSectionTempo(TGContext context, UIPanel parentPanel) {
        super(context);
        UIFactory uiFactory = TGApplication.getInstance(this.getContext()).getFactory();
        this.tempoImage = uiFactory.createImageView((UIContainer)parentPanel);
        this.controls.add(this.tempoImage);
        this.tempoLabel = uiFactory.createLabel((UIContainer)parentPanel);
        this.tempoLabel.addMouseDownListener(new UIMouseDownListener(){

            public void onMouseDown(UIMouseEvent event) {
                new TGActionProcessor(TGMainToolBarSectionTempo.this.getContext(), "action.gui.open-tempo-dialog").process();
            }
        });
        this.tempoImage.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TuxGuitar.getInstance().getEditorManager().removeRedrawListener((TGEventListener)TGMainToolBarSectionTempo.this);
            }
        });
        this.controls.add(this.tempoLabel);
        this.loadIcons();
        this.createSyncProcesses();
        this.appendListeners();
    }

    private void createSyncProcesses() {
        this.redrawProcess = new TGSyncProcessLocked(this.getContext(), new Runnable(){

            @Override
            public void run() {
                TGMainToolBarSectionTempo.this.updateItems();
            }
        });
    }

    private void appendListeners() {
        TuxGuitar.getInstance().getEditorManager().addRedrawListener((TGEventListener)this);
    }

    public void processEvent(TGEvent event) {
        int type;
        if ("ui-redraw".equals(event.getEventType()) && ((type = ((Integer)event.getAttribute("redrawMode")).intValue()) == 2 || type == 3)) {
            this.redrawProcess.process();
        }
    }

    @Override
    public void loadIcons() {
        this.updateTempoIcon();
    }

    private void updateTempoIcon() {
        if (this.currentTempoBase != 0) {
            this.tempoImage.setImage(TuxGuitar.getInstance().getIconManager().getDuration(this.currentTempoBase, this.currentTempoDotted));
        } else {
            this.tempoImage.setImage(TGIconManager.getInstance(this.getContext()).getImageByName("4.png"));
        }
    }

    @Override
    public void loadProperties() {
        if (this.currentTempoValue != 0) {
            this.tempoLabel.setText("= " + String.valueOf(this.currentTempoValue));
        } else {
            this.tempoLabel.setText("= 120");
        }
    }

    @Override
    public void updateItems() {
        int tempoValue;
        TGTempo tempo;
        int tempoPercent = 100;
        MidiPlayer midiPlayer = MidiPlayer.getInstance((TGContext)this.getContext());
        if (midiPlayer.isRunning() && midiPlayer.getCurrentTempo() != null) {
            tempo = midiPlayer.getCurrentTempo();
            tempoPercent = midiPlayer.getMode().getCurrentPercent();
            this.tempoLabel.setIgnoreEvents(true);
        } else {
            tempo = TablatureEditor.getInstance(this.getContext()).getTablature().getCaret().getMeasure().getTempo();
            this.tempoLabel.setIgnoreEvents(false);
        }
        if (tempo.getBase() != this.currentTempoBase || tempo.isDotted() != this.currentTempoDotted) {
            this.currentTempoBase = tempo.getBase();
            this.currentTempoDotted = tempo.isDotted();
            this.updateTempoIcon();
        }
        if ((tempoValue = tempo.getRawValue() * tempoPercent / 100) != this.currentTempoValue) {
            this.currentTempoValue = tempoValue;
            this.tempoLabel.setText("= " + String.valueOf(this.currentTempoValue));
        }
    }

    @Override
    public void addToolBarItem(TGMainToolBarItemConfig toolBarItemConfig) {
    }
}

