/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.toolbar.main;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.action.TGActionProcessorListener;
import app.tuxguitar.app.system.icons.TGIconManager;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBarItem;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBarItemConfig;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBarItemMenuItem;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.menu.UIMenuActionItem;
import app.tuxguitar.ui.menu.UIMenuItem;
import app.tuxguitar.ui.toolbar.UIToolBar;
import app.tuxguitar.ui.toolbar.UIToolMenuItem;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.util.TGContext;
import java.util.ArrayList;
import java.util.List;

public class TGMainToolBarItemMenu
extends TGMainToolBarItem {
    private UIToolMenuItem menuItem;
    private List<TGMainToolBarItemConfig> toolBarMenuItemConfigs;
    private List<TGMainToolBarItemMenuItem> toolBarMenuItems;
    private boolean displaySelectedItemIcon;

    public TGMainToolBarItemMenu(TGMainToolBarItemConfig config) {
        super(config);
        this.displaySelectedItemIcon = config.displaySelectedItemIcon();
        this.toolBarMenuItemConfigs = config.getSubItemConfigs();
        this.toolBarMenuItems = new ArrayList<TGMainToolBarItemMenuItem>();
    }

    @Override
    public UIControl getControl() {
        return null;
    }

    public void createMenu(UIToolBar toolBar, TGContext context) {
        this.menuItem = toolBar.createMenuItem();
        for (TGMainToolBarItemConfig toolBarMenuItemConfig : this.toolBarMenuItemConfigs) {
            if (toolBarMenuItemConfig.getType() == 0) {
                this.menuItem.getMenu().createSeparator();
                continue;
            }
            TGMainToolBarItemMenuItem toolBarMenuItem = new TGMainToolBarItemMenuItem(toolBarMenuItemConfig);
            UIMenuActionItem menuActionItem = this.menuItem.getMenu().createActionItem();
            TGActionProcessorListener actionProcessorListener = new TGActionProcessorListener(context, toolBarMenuItemConfig.getActionName());
            for (String key : toolBarMenuItemConfig.getAttributes().keySet()) {
                actionProcessorListener.setAttribute(key, toolBarMenuItemConfig.getAttributes().get(key));
            }
            menuActionItem.addSelectionListener((UISelectionListener)actionProcessorListener);
            toolBarMenuItem.setMenuItem((UIMenuItem)menuActionItem);
            this.toolBarMenuItems.add(toolBarMenuItem);
        }
    }

    @Override
    public void update(TGContext context, boolean running) {
        for (TGMainToolBarItemMenuItem toolBarMenuItem : this.toolBarMenuItems) {
            toolBarMenuItem.update(context, running);
            if (!this.displaySelectedItemIcon || !toolBarMenuItem.isChecked()) continue;
            this.menuItem.setImage(TGIconManager.getInstance(context).getImageByName(toolBarMenuItem.getIconFileName()));
        }
    }

    @Override
    public void loadIcons(TGIconManager iconManager) {
        this.menuItem.setImage(iconManager.getImageByName(this.getIconFileName()));
        for (TGMainToolBarItemMenuItem toolBarMenuItem : this.toolBarMenuItems) {
            toolBarMenuItem.loadIcons(iconManager);
        }
    }

    @Override
    public void loadProperties() {
        this.menuItem.setToolTipText(TuxGuitar.getProperty(this.getText()));
        for (TGMainToolBarItemMenuItem toolBarMenuItem : this.toolBarMenuItems) {
            toolBarMenuItem.loadProperties();
        }
    }
}

