/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.toolbar.main;

import app.tuxguitar.app.system.icons.TGIconManager;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBarItemConfig;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBarItemUpdater;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.util.TGContext;
import java.util.HashMap;
import java.util.Map;

public abstract class TGMainToolBarItem {
    public static final int SEPARATOR = 0;
    public static final int ACTION_ITEM = 1;
    public static final int CHECKABLE_ITEM = 2;
    public static final int MENU = 3;
    public static final int TIME_COUNTER = 4;
    public static final int TEMPO_INDICATOR = 5;
    protected String actionName;
    protected String iconFileName;
    protected String text;
    protected TGMainToolBarItemUpdater updater;
    protected Map<String, Object> attributes;

    protected TGMainToolBarItem(TGMainToolBarItemConfig config) {
        this.actionName = config.getActionName();
        this.iconFileName = config.getIconFileName();
        this.text = config.getText();
        this.updater = config.getUpdater();
        this.attributes = new HashMap<String, Object>();
    }

    public abstract UIControl getControl();

    public String getText() {
        return this.text;
    }

    protected void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public String getIconFileName() {
        return this.iconFileName;
    }

    public void update(TGContext context, boolean running) {
    }

    public void loadProperties() {
    }

    public void loadIcons(TGIconManager iconManager) {
    }

    public void setLayoutProperties(UITableLayout layout) {
    }
}

