/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.toolbar.edit;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.action.TGActionProcessorListener;
import app.tuxguitar.app.system.icons.TGIconManager;
import app.tuxguitar.app.view.component.tab.Caret;
import app.tuxguitar.app.view.toolbar.edit.TGEditToolBar;
import app.tuxguitar.app.view.toolbar.edit.TGEditToolBarSection;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.resource.UIImage;
import app.tuxguitar.ui.toolbar.UIToolBar;
import app.tuxguitar.ui.toolbar.UIToolCheckableItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TGEditToolBarSectionDynamic
extends TGEditToolBarSection {
    private static final String SECTION_TITLE = "dynamic";
    private static final String VELOCITY_VALUE = "velocity";
    private List<UIToolCheckableItem> menuItems;
    private Map<Integer, String> dynamicNameKeys = new HashMap<Integer, String>();

    public TGEditToolBarSectionDynamic(TGEditToolBar toolBar) {
        super(toolBar, SECTION_TITLE);
        this.dynamicNameKeys.put(15, "dynamic.piano-pianissimo");
        this.dynamicNameKeys.put(31, "dynamic.pianissimo");
        this.dynamicNameKeys.put(47, "dynamic.piano");
        this.dynamicNameKeys.put(63, "dynamic.mezzo-piano");
        this.dynamicNameKeys.put(79, "dynamic.mezzo-forte");
        this.dynamicNameKeys.put(95, "dynamic.forte");
        this.dynamicNameKeys.put(111, "dynamic.fortissimo");
        this.dynamicNameKeys.put(127, "dynamic.forte-fortissimo");
    }

    @Override
    public void createSectionToolBars() {
        UIToolBar toolBar = this.createToolBar();
        this.menuItems = new ArrayList<UIToolCheckableItem>();
        this.menuItems.add(this.createToolItem(toolBar, 15));
        this.menuItems.add(this.createToolItem(toolBar, 31));
        this.menuItems.add(this.createToolItem(toolBar, 47));
        this.menuItems.add(this.createToolItem(toolBar, 63));
        toolBar = this.createToolBar();
        this.menuItems.add(this.createToolItem(toolBar, 79));
        this.menuItems.add(this.createToolItem(toolBar, 95));
        this.menuItems.add(this.createToolItem(toolBar, 111));
        this.menuItems.add(this.createToolItem(toolBar, 127));
    }

    @Override
    public void loadSectionProperties() {
        for (UIToolCheckableItem menuItem : this.menuItems) {
            Integer velocity = (Integer)menuItem.getData(VELOCITY_VALUE);
            String nameKey = this.getNameKey(velocity);
            if (nameKey == null) continue;
            menuItem.setToolTipText(this.getText(nameKey));
        }
    }

    @Override
    public void loadSectionIcons() {
        for (UIToolCheckableItem menuItem : this.menuItems) {
            Integer velocity = (Integer)menuItem.getData(VELOCITY_VALUE);
            UIImage icon = this.getDynamicIcon(velocity);
            if (icon == null) continue;
            menuItem.setImage(icon);
        }
    }

    @Override
    public void updateSectionItems() {
        Caret caret = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret();
        int selection = caret.getSelectedNote() != null ? caret.getSelectedNote().getVelocity() : caret.getVelocity();
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        for (UIToolCheckableItem menuItem : this.menuItems) {
            menuItem.setEnabled(!running);
            Integer velocity = (Integer)menuItem.getData(VELOCITY_VALUE);
            String nameKey = this.getNameKey(velocity);
            if (nameKey == null) continue;
            menuItem.setChecked(velocity == selection);
        }
    }

    private UIToolCheckableItem createToolItem(UIToolBar toolBar, int velocity) {
        UIToolCheckableItem menuItem = toolBar.createCheckItem();
        menuItem.setData(VELOCITY_VALUE, (Object)velocity);
        menuItem.addSelectionListener((UISelectionListener)this.createChangeVelocityAction(velocity));
        return menuItem;
    }

    private String getNameKey(int velocity) {
        if (this.dynamicNameKeys.containsKey(velocity)) {
            return this.dynamicNameKeys.get(velocity);
        }
        return null;
    }

    private UIImage getDynamicIcon(int velocity) {
        TGIconManager iconManager = this.getIconManager();
        if (velocity == 15) {
            return iconManager.getImageByName("dynamic_ppp.png");
        }
        if (velocity == 31) {
            return iconManager.getImageByName("dynamic_pp.png");
        }
        if (velocity == 47) {
            return iconManager.getImageByName("dynamic_p.png");
        }
        if (velocity == 63) {
            return iconManager.getImageByName("dynamic_mp.png");
        }
        if (velocity == 79) {
            return iconManager.getImageByName("dynamic_mf.png");
        }
        if (velocity == 95) {
            return iconManager.getImageByName("dynamic_f.png");
        }
        if (velocity == 111) {
            return iconManager.getImageByName("dynamic_ff.png");
        }
        if (velocity == 127) {
            return iconManager.getImageByName("dynamic_fff.png");
        }
        return null;
    }

    public TGActionProcessorListener createChangeVelocityAction(Integer velocity) {
        TGActionProcessorListener tgActionProcessor = this.createActionProcessor("action.note.general.velocity");
        tgActionProcessor.setAttribute(VELOCITY_VALUE, velocity);
        return tgActionProcessor;
    }
}

