/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.toolbar.edit;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.action.TGActionProcessorListener;
import app.tuxguitar.app.view.component.tab.TablatureEditor;
import app.tuxguitar.app.view.toolbar.edit.TGEditToolBar;
import app.tuxguitar.app.view.toolbar.edit.TGEditToolBarSection;
import app.tuxguitar.document.TGDocumentManager;
import app.tuxguitar.editor.action.duration.TGSetDivisionTypeDurationAction;
import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.models.TGDivisionType;
import app.tuxguitar.song.models.TGDuration;
import app.tuxguitar.song.models.TGNote;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.menu.UIMenuCheckableItem;
import app.tuxguitar.ui.resource.UIImage;
import app.tuxguitar.ui.toolbar.UIToolActionItem;
import app.tuxguitar.ui.toolbar.UIToolActionMenuItem;
import app.tuxguitar.ui.toolbar.UIToolBar;
import app.tuxguitar.ui.toolbar.UIToolCheckableItem;
import app.tuxguitar.util.TGContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TGEditToolBarSectionDuration
extends TGEditToolBarSection {
    private static final String SECTION_TITLE = "duration";
    private static final String DURATION_VALUE = "duration";
    private UIToolCheckableItem dotted;
    private UIToolCheckableItem doubleDotted;
    private UIToolActionMenuItem divisionTypeItem;
    private UIToolCheckableItem tiedNote;
    private List<UIToolCheckableItem> durationToolItems;
    private List<UIMenuCheckableItem> divisionTypeMenuItems;
    private Map<Integer, String> durationNameKeys;
    private Map<Integer, String> durationActions;

    public TGEditToolBarSectionDuration(TGEditToolBar toolBar) {
        super(toolBar, "duration");
        this.createDurationNames();
        this.createDurationActions();
    }

    @Override
    public void createSectionToolBars() {
        UIToolBar toolBar1 = this.createToolBar();
        UIToolBar toolBar2 = this.createToolBar();
        this.durationToolItems = new ArrayList<UIToolCheckableItem>();
        this.durationToolItems.add(this.createDurationToolItem(toolBar1, 1));
        this.durationToolItems.add(this.createDurationToolItem(toolBar1, 2));
        this.durationToolItems.add(this.createDurationToolItem(toolBar1, 4));
        this.durationToolItems.add(this.createDurationToolItem(toolBar1, 8));
        this.durationToolItems.add(this.createDurationToolItem(toolBar1, 16));
        this.durationToolItems.add(this.createDurationToolItem(toolBar1, 32));
        this.durationToolItems.add(this.createDurationToolItem(toolBar2, 64));
        this.dotted = toolBar2.createCheckItem();
        this.dotted.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.change-dotted"));
        this.doubleDotted = toolBar2.createCheckItem();
        this.doubleDotted.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.change-double-dotted"));
        this.tiedNote = toolBar2.createCheckItem();
        this.tiedNote.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.tied"));
        this.divisionTypeItem = toolBar2.createActionMenuItem();
        this.divisionTypeItem.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGEditToolBarSectionDuration.this.toggleDivisionType();
            }
        });
        this.divisionTypeMenuItems = new ArrayList<UIMenuCheckableItem>();
        for (int i = 0; i < TGDivisionType.DIVISION_TYPES.length; ++i) {
            UIMenuCheckableItem item = this.createDivisionTypeMenuItem(TGDivisionType.DIVISION_TYPES[i]);
            this.divisionTypeMenuItems.add(item);
            item.addSelectionListener((UISelectionListener)this.createDivisionTypeAction(TGDivisionType.DIVISION_TYPES[i]));
        }
    }

    @Override
    public void updateSectionItems() {
        TGNote note = this.getTablature().getCaret().getSelectedNote();
        TGDuration duration = this.getTablature().getCaret().getDuration();
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        this.dotted.setChecked(duration.isDotted());
        this.dotted.setEnabled(!running);
        this.doubleDotted.setChecked(duration.isDoubleDotted());
        this.doubleDotted.setEnabled(!running);
        this.divisionTypeItem.setEnabled(!running);
        this.tiedNote.setEnabled(!running);
        this.tiedNote.setChecked(note != null && note.isTiedNote());
        this.updateDurationToolItems(duration.getValue(), running);
        this.updateDivisionTypeMenuItems(duration.getDivision(), running);
    }

    @Override
    public void loadSectionProperties() {
        TGDuration duration = this.getTablature().getCaret().getDuration();
        this.dotted.setToolTipText(this.getText("duration.dotted"));
        this.doubleDotted.setToolTipText(this.getText("duration.doubledotted"));
        this.divisionTypeItem.setToolTipText(this.getText("duration.division-type"));
        this.tiedNote.setToolTipText(this.getText("duration.tiednote"));
        this.loadDurationToolProperties(duration.getValue());
        this.loadDivisionTypeMenuProperties();
    }

    @Override
    public void loadSectionIcons() {
        this.dotted.setImage(this.getIconManager().getImageByName("dotted.png"));
        this.doubleDotted.setImage(this.getIconManager().getImageByName("doubledotted.png"));
        this.tiedNote.setImage(this.getIconManager().getImageByName("tiednote.png"));
        this.loadDurationToolIcons();
    }

    private UIToolCheckableItem createDurationToolItem(UIToolBar toolBar, int value) {
        UIToolCheckableItem toolItem = toolBar.createCheckItem();
        toolItem.setData("duration", (Object)value);
        String action = this.findDurationAction(value);
        if (action != null) {
            toolItem.addSelectionListener((UISelectionListener)this.createActionProcessor(action));
        }
        return toolItem;
    }

    private void updateDurationToolItems(int selection, boolean running) {
        for (UIToolCheckableItem uiToolItem : this.durationToolItems) {
            Integer value = (Integer)uiToolItem.getData("duration");
            String nameKey = this.findDurationNameKey(value);
            if (nameKey == null) continue;
            uiToolItem.setEnabled(!running);
            uiToolItem.setChecked(value == selection);
        }
    }

    private void loadDurationToolIcons() {
        for (UIToolActionItem uIToolActionItem : this.durationToolItems) {
            Integer value = (Integer)uIToolActionItem.getData("duration");
            UIImage icon = this.findDurationIcon(value);
            if (icon == null) continue;
            uIToolActionItem.setImage(icon);
        }
    }

    private void loadDurationToolProperties(int selection) {
        for (UIToolActionItem uIToolActionItem : this.durationToolItems) {
            Integer value = (Integer)uIToolActionItem.getData("duration");
            String nameKey = this.findDurationNameKey(value);
            if (nameKey == null) continue;
            uIToolActionItem.setToolTipText(this.getText(nameKey));
        }
    }

    private void createDurationNames() {
        this.durationNameKeys = new HashMap<Integer, String>();
        this.durationNameKeys.put(1, "duration.whole");
        this.durationNameKeys.put(2, "duration.half");
        this.durationNameKeys.put(4, "duration.quarter");
        this.durationNameKeys.put(8, "duration.eighth");
        this.durationNameKeys.put(16, "duration.sixteenth");
        this.durationNameKeys.put(32, "duration.thirtysecond");
        this.durationNameKeys.put(64, "duration.sixtyfourth");
    }

    private void createDurationActions() {
        this.durationActions = new HashMap<Integer, String>();
        this.durationActions.put(1, "action.note.duration.set-whole");
        this.durationActions.put(2, "action.note.duration.set-half");
        this.durationActions.put(4, "action.note.duration.set-quarter");
        this.durationActions.put(8, "action.note.duration.set-eighth");
        this.durationActions.put(16, "action.note.duration.set-sixteenth");
        this.durationActions.put(32, "action.note.duration.set-thirty-second");
        this.durationActions.put(64, "action.note.duration.set-sixty-fourth");
    }

    private String findDurationNameKey(int value) {
        if (this.durationNameKeys.containsKey(value)) {
            return this.durationNameKeys.get(value);
        }
        return null;
    }

    private String findDurationAction(int value) {
        if (this.durationActions.containsKey(value)) {
            return this.durationActions.get(value);
        }
        return null;
    }

    private UIImage findDurationIcon(int value) {
        return this.getIconManager().getDuration(value);
    }

    private void toggleDivisionType() {
        TGDuration duration = TablatureEditor.getInstance(this.getToolBar().getContext()).getTablature().getCaret().getDuration();
        TGDivisionType divisionType = null;
        divisionType = duration.getDivision().isEqual(TGDivisionType.NORMAL) ? this.createDivisionType(TGDivisionType.DIVISION_TYPES[1]) : this.createDivisionType(TGDivisionType.NORMAL);
        this.createDivisionTypeAction(divisionType).process();
    }

    private UIMenuCheckableItem createDivisionTypeMenuItem(TGDivisionType divisionType) {
        UIMenuCheckableItem uiMenuItem = this.divisionTypeItem.getMenu().createRadioItem();
        uiMenuItem.setData(TGDivisionType.class.getName(), (Object)divisionType);
        return uiMenuItem;
    }

    private void updateDivisionTypeMenuItems(TGDivisionType selection, boolean running) {
        for (int i = 0; i < this.divisionTypeMenuItems.size(); ++i) {
            UIMenuCheckableItem uiMenuItem = this.divisionTypeMenuItems.get(i);
            TGDivisionType divisionType = (TGDivisionType)uiMenuItem.getData(TGDivisionType.class.getName());
            uiMenuItem.setChecked(divisionType.isEqual(selection));
        }
        this.divisionTypeItem.setImage(this.getIconManager().getDivisionType(selection.getEnters()));
    }

    private void loadDivisionTypeMenuProperties() {
        for (UIMenuCheckableItem uiMenuItem : this.divisionTypeMenuItems) {
            TGDivisionType divisionType = (TGDivisionType)uiMenuItem.getData(TGDivisionType.class.getName());
            uiMenuItem.setText(TuxGuitar.getProperty("duration.division-type." + Integer.toString(divisionType.getEnters())));
        }
    }

    private TGDivisionType createDivisionType(TGDivisionType tgDivisionTypeSrc) {
        TGFactory tgFactory = TGDocumentManager.getInstance((TGContext)this.getToolBar().getContext()).getSongManager().getFactory();
        TGDivisionType tgDivisionTypeDst = tgFactory.newDivisionType();
        tgDivisionTypeDst.copyFrom(tgDivisionTypeSrc);
        return tgDivisionTypeDst;
    }

    private TGActionProcessorListener createDivisionTypeAction(TGDivisionType tgDivisionType) {
        TGActionProcessorListener tgActionProcessor = this.createActionProcessor("action.note.duration.set-division-type");
        tgActionProcessor.setAttribute(TGSetDivisionTypeDurationAction.PROPERTY_DIVISION_TYPE, this.createDivisionType(tgDivisionType));
        return tgActionProcessor;
    }
}

