/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.menu.impl;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.view.menu.TGMenuItem;
import app.tuxguitar.graphics.control.TGTrackImpl;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.menu.UIMenu;
import app.tuxguitar.ui.menu.UIMenuActionItem;
import app.tuxguitar.ui.menu.UIMenuCheckableItem;
import app.tuxguitar.ui.menu.UIMenuItem;

public class TrackMenu
extends TGMenuItem {
    private UIMenu menu;
    private UIMenuActionItem first;
    private UIMenuActionItem previous;
    private UIMenuActionItem next;
    private UIMenuActionItem last;
    private UIMenuActionItem addTrack;
    private UIMenuActionItem cloneTrack;
    private UIMenuActionItem removeTrack;
    private UIMenuActionItem moveUp;
    private UIMenuActionItem moveDown;
    private UIMenuCheckableItem changeSolo;
    private UIMenuCheckableItem changeMute;
    private UIMenuActionItem lyrics;
    private UIMenuActionItem properties;

    public TrackMenu(UIMenu menu) {
        this.menu = menu;
    }

    public UIMenu getMenu() {
        return this.menu;
    }

    @Override
    public void showItems() {
        if (!this.isDisposed()) {
            this.first = this.menu.createActionItem();
            this.first.addSelectionListener((UISelectionListener)this.createActionProcessor("action.track.go-first"));
            this.previous = this.menu.createActionItem();
            this.previous.addSelectionListener((UISelectionListener)this.createActionProcessor("action.track.go-previous"));
            this.next = this.menu.createActionItem();
            this.next.addSelectionListener((UISelectionListener)this.createActionProcessor("action.track.go-next"));
            this.last = this.menu.createActionItem();
            this.last.addSelectionListener((UISelectionListener)this.createActionProcessor("action.track.go-last"));
            this.menu.createSeparator();
            this.addTrack = this.menu.createActionItem();
            this.addTrack.addSelectionListener((UISelectionListener)this.createActionProcessor("action.track.add-new"));
            this.cloneTrack = this.menu.createActionItem();
            this.cloneTrack.addSelectionListener((UISelectionListener)this.createActionProcessor("action.track.clone"));
            this.removeTrack = this.menu.createActionItem();
            this.removeTrack.addSelectionListener((UISelectionListener)this.createActionProcessor("action.track.remove"));
            this.menu.createSeparator();
            this.moveUp = this.menu.createActionItem();
            this.moveUp.addSelectionListener((UISelectionListener)this.createActionProcessor("action.track.move-up"));
            this.moveDown = this.menu.createActionItem();
            this.moveDown.addSelectionListener((UISelectionListener)this.createActionProcessor("action.track.move-down"));
            this.menu.createSeparator();
            this.changeSolo = this.menu.createCheckItem();
            this.changeSolo.addSelectionListener((UISelectionListener)this.createActionProcessor("action.track.change-solo"));
            this.changeMute = this.menu.createCheckItem();
            this.changeMute.addSelectionListener((UISelectionListener)this.createActionProcessor("action.track.change-mute"));
            this.menu.createSeparator();
            this.lyrics = this.menu.createActionItem();
            this.lyrics.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.toggle-lyric-editor"));
            this.properties = this.menu.createActionItem();
            this.properties.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-track-properties-dialog"));
            this.loadIcons();
            this.loadProperties();
        }
    }

    @Override
    public void loadProperties() {
        if (!this.isDisposed()) {
            this.setMenuItemTextAndAccelerator((UIMenuItem)this.first, "track.first", "action.track.go-first");
            this.setMenuItemTextAndAccelerator((UIMenuItem)this.previous, "track.previous", "action.track.go-previous");
            this.setMenuItemTextAndAccelerator((UIMenuItem)this.next, "track.next", "action.track.go-next");
            this.setMenuItemTextAndAccelerator((UIMenuItem)this.last, "track.last", "action.track.go-last");
            this.setMenuItemTextAndAccelerator((UIMenuItem)this.addTrack, "track.add", "action.track.add-new");
            this.setMenuItemTextAndAccelerator((UIMenuItem)this.cloneTrack, "track.clone", "action.track.clone");
            this.setMenuItemTextAndAccelerator((UIMenuItem)this.removeTrack, "track.remove", "action.track.remove");
            this.setMenuItemTextAndAccelerator((UIMenuItem)this.moveUp, "track.move-up", "action.track.move-up");
            this.setMenuItemTextAndAccelerator((UIMenuItem)this.moveDown, "track.move-down", "action.track.move-down");
            this.setMenuItemTextAndAccelerator((UIMenuItem)this.changeSolo, "track.solo", "action.track.change-solo");
            this.setMenuItemTextAndAccelerator((UIMenuItem)this.changeMute, "track.mute", "action.track.change-mute");
            this.setMenuItemTextAndAccelerator((UIMenuItem)this.lyrics, "track.lyrics", "action.gui.toggle-lyric-editor");
            this.setMenuItemTextAndAccelerator((UIMenuItem)this.properties, "track.properties", "action.gui.open-track-properties-dialog");
        }
    }

    @Override
    public void update() {
        if (!this.isDisposed()) {
            TGTrackImpl track = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack();
            int tracks = track.getSong().countTracks();
            boolean isFirst = track.getNumber() == 1;
            boolean isLast = track.getNumber() == tracks;
            boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
            this.first.setEnabled(!isFirst);
            this.previous.setEnabled(!isFirst);
            this.next.setEnabled(!isLast);
            this.last.setEnabled(!isLast);
            this.addTrack.setEnabled(!running);
            this.cloneTrack.setEnabled(!running);
            this.removeTrack.setEnabled(!running);
            this.moveUp.setEnabled(!running && tracks > 1);
            this.moveDown.setEnabled(!running && tracks > 1);
            this.changeSolo.setChecked(track.isSolo());
            this.changeMute.setChecked(track.isMute());
            this.properties.setEnabled(!running);
        }
    }

    public void loadIcons() {
        this.first.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("track_first.png"));
        this.previous.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("track_previous.png"));
        this.next.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("track_next.png"));
        this.last.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("track_last.png"));
        this.addTrack.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("track_add.png"));
        this.cloneTrack.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("track_clone.png"));
        this.removeTrack.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("track_remove.png"));
        this.moveUp.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("arrow_up.png"));
        this.moveDown.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("arrow_down.png"));
        this.changeSolo.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("track_solo.png"));
        this.changeMute.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("track_mute.png"));
    }

    public boolean isDisposed() {
        return this.menu == null || this.menu.isDisposed();
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.menu.dispose();
        }
    }
}

