/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.menu.impl;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.action.TGActionProcessorListener;
import app.tuxguitar.app.view.menu.TGMenuItem;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.song.models.TGChord;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.menu.UIMenu;
import app.tuxguitar.ui.menu.UIMenuActionItem;
import app.tuxguitar.ui.menu.UIMenuItem;
import app.tuxguitar.ui.menu.UIMenuSubMenuItem;

public class ChordMenuItem
extends TGMenuItem {
    private UIMenuSubMenuItem chordMenuItem;
    private UIMenuActionItem insertChord;
    private UIMenuActionItem[] subMenuItems;
    private long lastEdit;

    public ChordMenuItem(UIMenuSubMenuItem chordMenuItem) {
        this.chordMenuItem = chordMenuItem;
    }

    public ChordMenuItem(UIMenu parent) {
        this(parent.createSubMenuItem());
    }

    @Override
    public void showItems() {
        this.insertChord = this.chordMenuItem.getMenu().createActionItem();
        this.insertChord.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-chord-dialog"));
        this.chordMenuItem.getMenu().createSeparator();
        this.addItems();
        this.loadIcons();
        this.loadProperties();
    }

    public void addItems() {
        this.disposeItems();
        this.subMenuItems = new UIMenuActionItem[TuxGuitar.getInstance().getCustomChordManager().countChords()];
        for (int i = 0; i < this.subMenuItems.length; ++i) {
            TGChord chord = TuxGuitar.getInstance().getCustomChordManager().getChord(i);
            this.subMenuItems[i] = this.chordMenuItem.getMenu().createActionItem();
            this.subMenuItems[i].setText(chord.getName());
            this.subMenuItems[i].addSelectionListener((UISelectionListener)this.createInsertChordAction(chord));
        }
    }

    public void disposeItems() {
        if (this.subMenuItems != null) {
            for (int i = 0; i < this.subMenuItems.length; ++i) {
                this.subMenuItems[i].dispose();
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.chordMenuItem.setEnabled(enabled);
    }

    @Override
    public void update() {
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        if (this.lastEdit != TuxGuitar.getInstance().getCustomChordManager().getLastEdit()) {
            this.addItems();
            this.lastEdit = TuxGuitar.getInstance().getCustomChordManager().getLastEdit();
        }
        this.insertChord.setEnabled(!running);
        for (int i = 0; i < this.subMenuItems.length; ++i) {
            this.subMenuItems[i].setEnabled(!running);
        }
    }

    @Override
    public void loadProperties() {
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.chordMenuItem, "chord", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.insertChord, "insert.chord", "action.gui.open-chord-dialog");
    }

    public void loadIcons() {
        this.insertChord.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("chord.png"));
    }

    public TGActionProcessorListener createInsertChordAction(TGChord chord) {
        TGActionProcessorListener tgActionProcessor = this.createActionProcessor("action.beat.general.insert-chord");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_CHORD, chord);
        return tgActionProcessor;
    }
}

