/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.transport;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.action.TGActionProcessorListener;
import app.tuxguitar.app.system.icons.TGColorManager;
import app.tuxguitar.app.transport.TGTransport;
import app.tuxguitar.app.transport.TGTransportCache;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.component.tab.TablatureEditor;
import app.tuxguitar.app.view.main.TGWindow;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.document.TGDocumentManager;
import app.tuxguitar.editor.util.TGProcess;
import app.tuxguitar.editor.util.TGSyncProcess;
import app.tuxguitar.editor.util.TGSyncProcessLocked;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.player.base.MidiPlayer;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGMeasureHeader;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UIDisposeEvent;
import app.tuxguitar.ui.event.UIDisposeListener;
import app.tuxguitar.ui.event.UIMouseDownListener;
import app.tuxguitar.ui.event.UIMouseEvent;
import app.tuxguitar.ui.event.UIMouseMoveListener;
import app.tuxguitar.ui.event.UIMouseUpListener;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.resource.UIColor;
import app.tuxguitar.ui.resource.UIColorModel;
import app.tuxguitar.ui.resource.UICursor;
import app.tuxguitar.ui.resource.UIFont;
import app.tuxguitar.ui.toolbar.UIToolActionItem;
import app.tuxguitar.ui.toolbar.UIToolBar;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILayoutContainer;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UIProgressBar;
import app.tuxguitar.ui.widget.UISpinner;
import app.tuxguitar.ui.widget.UIToggleButton;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class TGTransportDialog
implements TGEventListener {
    private static final int PLAY_MODE_DELAY = 250;
    private static final String COLOR_BACKGROUND = "widget.transport.backgroundColor";
    private static final String COLOR_FOREGROUND = "widget.transport.foregroundColor";
    private static final TGColorManager.TGSkinnableColor[] SKINNABLE_COLORS = new TGColorManager.TGSkinnableColor[]{new TGColorManager.TGSkinnableColor("widget.transport.backgroundColor", new UIColorModel(0, 0, 0)), new TGColorManager.TGSkinnableColor("widget.transport.foregroundColor", new UIColorModel(0, 0, 255))};
    private TGContext context;
    private UIWindow dialog;
    private UILabel label;
    private UIProgressBar tickProgress;
    private UIToggleButton metronome;
    private UIToggleButton countInToggle;
    private UISpinner countInTicks;
    private UIButton mode;
    private UIToolBar toolBar;
    private UIToolActionItem first;
    private UIToolActionItem last;
    private UIToolActionItem previous;
    private UIToolActionItem next;
    private UIToolActionItem stop;
    private UIToolActionItem play;
    private TGProcess loadPropertiesProcess;
    private TGProcess loadIconsProcess;
    private TGProcess updateItemsProcess;
    private TGProcess redrawPlayModeProcess;
    private boolean editingTickScale;
    private long redrawTime;
    private boolean isRunning;
    private TreeMap<Long, TGMeasureHeader> headerMap;

    public TGTransportDialog(TGContext context) {
        this.context = context;
        this.createSyncProcesses();
        this.headerMap = new TreeMap();
    }

    public void show() {
        UIFactory factory = this.getUIFactory();
        this.dialog = factory.createWindow(TGWindow.getInstance(this.context).getWindow(), false, false);
        this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        this.dialog.setLayout((UILayout)new UITableLayout());
        this.dialog.setText(TuxGuitar.getProperty("transport"));
        this.initComposites();
        this.initToolBar();
        this.redrawProgress();
        this.addListeners();
        this.dialog.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TGTransportDialog.this.removeListeners();
                TuxGuitar.getInstance().updateCache(true);
            }
        });
        TGDialogUtil.openDialog(this.dialog, 5);
    }

    public void addListeners() {
        TuxGuitar.getInstance().getSkinManager().addLoader(this);
        TuxGuitar.getInstance().getLanguageManager().addLoader(this);
        TuxGuitar.getInstance().getEditorManager().addRedrawListener((TGEventListener)this);
        TuxGuitar.getInstance().getEditorManager().addUpdateListener((TGEventListener)this);
    }

    public void removeListeners() {
        TuxGuitar.getInstance().getSkinManager().removeLoader(this);
        TuxGuitar.getInstance().getLanguageManager().removeLoader(this);
        TuxGuitar.getInstance().getEditorManager().removeRedrawListener((TGEventListener)this);
        TuxGuitar.getInstance().getEditorManager().removeUpdateListener((TGEventListener)this);
    }

    private void initComposites() {
        UIPanel composite = this.getUIFactory().createPanel((UIContainer)this.dialog, true);
        composite.setLayout((UILayout)new UITableLayout(Float.valueOf(0.0f)));
        UITableLayout parentLayout = (UITableLayout)this.dialog.getLayout();
        parentLayout.set((UIControl)composite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.initOptions((UILayoutContainer)composite);
        this.initProgress((UILayoutContainer)composite);
    }

    private void initOptions(UILayoutContainer parent) {
        UIFactory factory = this.getUIFactory();
        UITableLayout parentLayout = (UITableLayout)parent.getLayout();
        UITableLayout compositeLayout = new UITableLayout();
        UIPanel composite = factory.createPanel((UIContainer)parent, false);
        composite.setLayout((UILayout)compositeLayout);
        parentLayout.set((UIControl)composite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(true), null, null, null, null, Float.valueOf(0.0f));
        this.metronome = factory.createToggleButton((UIContainer)composite);
        this.metronome.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.transport.metronome"));
        compositeLayout.set((UIControl)this.metronome, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(true));
        compositeLayout.set((UIControl)this.metronome, "minimum_packed_width", (Object)Float.valueOf(100.0f));
        this.mode = factory.createButton((UIContainer)composite);
        this.mode.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.gui.open-transport-mode-dialog"));
        compositeLayout.set((UIControl)this.mode, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(true));
        final MidiPlayer player = MidiPlayer.getInstance((TGContext)this.context);
        this.countInToggle = factory.createToggleButton((UIContainer)composite);
        this.countInToggle.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.transport.count-down"));
        this.countInTicks = factory.createSpinner((UIContainer)composite);
        this.countInTicks.setMinimum(1);
        this.countInTicks.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGTransportDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                player.getCountDown().setTickCount(this.this$0.countInTicks.getValue());
            }
        });
        compositeLayout.set((UIControl)this.countInToggle, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(true));
        compositeLayout.set((UIControl)this.countInTicks, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        this.loadOptionIcons();
    }

    private void initProgress(UILayoutContainer parent) {
        UIPanel composite = this.getUIFactory().createPanel((UIContainer)parent, false);
        composite.setLayout((UILayout)new UITableLayout());
        UITableLayout parentLayout = (UITableLayout)parent.getLayout();
        parentLayout.set((UIControl)composite, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), null, null, null, null, Float.valueOf(0.0f));
        this.initLabel((UILayoutContainer)composite);
        this.initScale((UILayoutContainer)composite);
    }

    private void initLabel(UILayoutContainer parent) {
        UIFactory factory = this.getUIFactory();
        final UIFont font = factory.createFont("Minisystem", 24.0f, false, false);
        TGColorManager tgColorManager = TGColorManager.getInstance(this.context);
        tgColorManager.appendSkinnableColors(SKINNABLE_COLORS);
        UIColor background = tgColorManager.getColor(COLOR_BACKGROUND);
        UIColor foreground = tgColorManager.getColor(COLOR_FOREGROUND);
        UITableLayout parentLayout = (UITableLayout)parent.getLayout();
        UITableLayout labelContainerLayout = new UITableLayout();
        UIPanel labelContainer = factory.createPanel((UIContainer)parent, false);
        labelContainer.setLayout((UILayout)labelContainerLayout);
        labelContainer.setBgColor(background);
        parentLayout.set((UIControl)labelContainer, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.label = factory.createLabel((UIContainer)labelContainer);
        this.label.setBgColor(background);
        this.label.setFgColor(foreground);
        this.label.setFont(font);
        labelContainer.addDisposeListener(new UIDisposeListener(){
            final /* synthetic */ TGTransportDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onDispose(UIDisposeEvent event) {
                font.dispose();
            }
        });
        labelContainerLayout.set((UIControl)this.label, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
    }

    private void initScale(UILayoutContainer parent) {
        UIFactory factory = this.getUIFactory();
        this.tickProgress = factory.createProgressBar((UIContainer)parent);
        this.tickProgress.setCursor(UICursor.HAND);
        this.tickProgress.setValue(960);
        this.tickProgress.addMouseDownListener(new UIMouseDownListener(){

            public void onMouseDown(UIMouseEvent event) {
                TGTransportDialog.this.setEditingTickScale(true);
                TGTransportDialog.this.updateProgressBar(event.getPosition().getX());
            }
        });
        this.tickProgress.addMouseUpListener(new UIMouseUpListener(){

            public void onMouseUp(UIMouseEvent event) {
                new TGSyncProcessLocked(TGTransportDialog.this.context, new Runnable(){

                    @Override
                    public void run() {
                        TGTransportDialog.this.gotoMeasure(TGTransportDialog.this.getSongManager().getMeasureHeaderAt(TGTransportDialog.this.getDocumentManager().getSong(), (long)TGTransportDialog.this.tickProgress.getValue()), true);
                        TGTransportDialog.this.setEditingTickScale(false);
                    }
                }).process();
            }
        });
        this.tickProgress.addMouseMoveListener(new UIMouseMoveListener(){

            public void onMouseMove(UIMouseEvent event) {
                TGTransportDialog.this.updateProgressBar(event.getPosition().getX());
            }
        });
        UITableLayout parentLayout = (UITableLayout)parent.getLayout();
        parentLayout.set((UIControl)this.tickProgress, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        parentLayout.set((UIControl)this.tickProgress, "packed_height", (Object)Float.valueOf(10.0f));
    }

    private void updateProgressBar(float x) {
        if (this.isEditingTickScale()) {
            float width = this.tickProgress.getBounds().getWidth();
            float selection = (float)this.tickProgress.getMinimum() + x * (float)(this.tickProgress.getMaximum() - this.tickProgress.getMinimum()) / width;
            this.tickProgress.setValue(Math.round(Math.max(960.0f, selection)));
            this.redrawProgress();
        }
    }

    private void initToolBar() {
        if (this.toolBar != null && !this.toolBar.isDisposed()) {
            this.toolBar.dispose();
        }
        this.toolBar = this.getUIFactory().createHorizontalToolBar((UIContainer)this.dialog);
        this.first = this.toolBar.createActionItem();
        this.first.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.measure.go-first"));
        this.previous = this.toolBar.createActionItem();
        this.previous.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.measure.go-previous"));
        this.stop = this.toolBar.createActionItem();
        this.stop.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.transport.stop"));
        this.play = this.toolBar.createActionItem();
        this.play.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.transport.play"));
        this.next = this.toolBar.createActionItem();
        this.next.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.measure.go-next"));
        this.last = this.toolBar.createActionItem();
        this.last.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.measure.go-last"));
        UITableLayout uiLayout = (UITableLayout)this.dialog.getLayout();
        uiLayout.set((UIControl)this.toolBar, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.updateItems(true);
        this.loadProperties();
    }

    public void updateItems() {
        this.updateItems(false);
    }

    public void updateItems(boolean force) {
        if (!this.isDisposed()) {
            boolean lastStatusRunning = this.isRunning;
            MidiPlayer player = MidiPlayer.getInstance((TGContext)this.context);
            this.isRunning = player.isRunning();
            if (force || lastStatusRunning != this.isRunning) {
                this.updateHeaderMap();
                this.first.setImage(TuxGuitar.getInstance().getIconManager().getTransportFirst());
                this.last.setImage(TuxGuitar.getInstance().getIconManager().getTransportLast());
                this.previous.setImage(TuxGuitar.getInstance().getIconManager().getTransportPrevious());
                this.next.setImage(TuxGuitar.getInstance().getIconManager().getTransportNext());
                this.stop.setImage(TuxGuitar.getInstance().getIconManager().getTransportStop());
                if (this.isRunning) {
                    this.play.setImage(TuxGuitar.getInstance().getIconManager().getTransportPause());
                } else {
                    this.play.setImage(TuxGuitar.getInstance().getIconManager().getTransportPlay());
                    this.metronome.setText("");
                }
                this.loadPlayText();
            }
            TGMeasureHeader first = this.getSongManager().getFirstMeasureHeader(this.getDocumentManager().getSong());
            TGMeasureHeader last = this.getSongManager().getLastMeasureHeader(this.getDocumentManager().getSong());
            this.tickProgress.setMinimum((int)first.getStart());
            this.tickProgress.setMaximum((int)(last.getStart() + last.getLength()) - 1);
            this.metronome.setSelected(player.isMetronomeEnabled());
            this.countInToggle.setSelected(player.getCountDown().isEnabled());
            if (player.getCountDown().getTickCount() == 0) {
                TGMeasureHeader currentHeader = this.getSongManager().getMeasureHeaderAt(player.getSong(), TablatureEditor.getInstance(this.context).getTablature().getCaret().getPosition());
                this.countInTicks.setValue(currentHeader.getTimeSignature().getNumerator());
            } else {
                this.countInTicks.setValue(player.getCountDown().getTickCount());
            }
            this.countInTicks.setEnabled(player.getCountDown().isEnabled());
            this.redrawProgress();
        }
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.dialog.setText(TuxGuitar.getProperty("transport"));
            this.stop.setToolTipText(TuxGuitar.getProperty("transport.stop"));
            this.first.setToolTipText(TuxGuitar.getProperty("transport.first"));
            this.last.setToolTipText(TuxGuitar.getProperty("transport.last"));
            this.previous.setToolTipText(TuxGuitar.getProperty("transport.previous"));
            this.next.setToolTipText(TuxGuitar.getProperty("transport.next"));
            this.metronome.setToolTipText(TuxGuitar.getProperty("transport.metronome"));
            this.mode.setToolTipText(TuxGuitar.getProperty("transport.mode"));
            this.countInToggle.setToolTipText(TuxGuitar.getProperty("transport.count-down"));
            this.loadPlayText();
        }
    }

    public void loadPlayText() {
        String property = TuxGuitar.getProperty(this.isRunning ? "transport.pause" : "transport.start");
        this.play.setToolTipText(property);
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.initToolBar();
            this.loadOptionIcons();
            this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
            this.dialog.layout();
        }
    }

    private void loadOptionIcons() {
        this.metronome.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("transport_metronome.png"));
        this.mode.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("transport_mode.png"));
        this.countInToggle.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("transport_count_in.png"));
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.dialog.dispose();
        }
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public boolean isEditingTickScale() {
        return this.editingTickScale;
    }

    public void setEditingTickScale(boolean editingTickScale) {
        this.editingTickScale = editingTickScale;
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.context).getFactory();
    }

    public TGDocumentManager getDocumentManager() {
        return TGDocumentManager.getInstance((TGContext)this.context);
    }

    public TGSongManager getSongManager() {
        return this.getDocumentManager().getSongManager();
    }

    public void gotoMeasure(TGMeasureHeader header, boolean moveCaret) {
        TGTransport.getInstance(this.context).gotoMeasure(header, moveCaret);
    }

    public void updateTickLabel(String value) {
        String oldValue = this.label.getText();
        this.label.setText(value);
        if (oldValue == null || oldValue.length() != value.length()) {
            UIPanel uiPanel = (UIPanel)this.label.getParent();
            uiPanel.layout();
        }
    }

    public void redrawProgress() {
        if (!this.isDisposed() && !TuxGuitar.getInstance().isLocked()) {
            if (this.isEditingTickScale()) {
                this.updateTickLabel(Long.toString(this.tickProgress.getValue()));
            } else if (!MidiPlayer.getInstance((TGContext)this.context).isRunning()) {
                long tickPosition = TablatureEditor.getInstance(this.context).getTablature().getCaret().getPosition();
                this.updateTickLabel(Long.toString(tickPosition));
                this.tickProgress.setValue((int)tickPosition);
            }
        }
    }

    public void redrawPlayingMode() {
        if (!this.isDisposed()) {
            MidiPlayer player = MidiPlayer.getInstance((TGContext)this.context);
            if (!this.isEditingTickScale() && player.isRunning()) {
                TGTransportCache transportCache = TGTransport.getInstance(this.context).getCache();
                long time = System.currentTimeMillis();
                if (time > this.redrawTime + 250L) {
                    long position = transportCache.getPlayStart() + (player.getTickPosition() - transportCache.getPlayTick());
                    this.updateTickLabel(Long.toString(position));
                    this.tickProgress.setValue((int)position);
                    this.redrawTime = time;
                    TGSong song = TGDocumentManager.getInstance((TGContext)this.context).getSong();
                    TGMeasureHeader first = song != null ? TablatureEditor.getInstance(this.context).getTablature().getSongManager().getFirstMeasureHeader(song) : null;
                    Map.Entry<Long, TGMeasureHeader> entry = this.headerMap.floorEntry(position);
                    TGMeasureHeader current = entry != null ? entry.getValue() : first;
                    Integer currentTempo = Math.round((float)current.getTempo().getRawValue() * (float)player.getMode().getCurrentPercent() / 100.0f);
                    this.metronome.setText(currentTempo.toString());
                }
            }
        }
    }

    public void createSyncProcesses() {
        this.loadPropertiesProcess = new TGSyncProcess(this.context, new Runnable(){

            @Override
            public void run() {
                TGTransportDialog.this.loadProperties();
            }
        });
        this.loadIconsProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            @Override
            public void run() {
                TGTransportDialog.this.loadIcons();
            }
        });
        this.updateItemsProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            @Override
            public void run() {
                TGTransportDialog.this.updateItems();
            }
        });
        this.redrawPlayModeProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            @Override
            public void run() {
                TGTransportDialog.this.redrawPlayingMode();
            }
        });
    }

    public void processRedrawEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("redrawMode");
        if (type == 2 || type == 3) {
            this.redrawPlayModeProcess.process();
        }
    }

    public void processUpdateEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("updateMode");
        if (type == 1) {
            this.updateItemsProcess.process();
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-skin".equals(event.getEventType())) {
            this.loadIconsProcess.process();
        } else if ("language".equals(event.getEventType())) {
            this.loadPropertiesProcess.process();
        } else if ("ui-redraw".equals(event.getEventType())) {
            this.processRedrawEvent(event);
        } else if ("ui-update".equals(event.getEventType())) {
            this.processUpdateEvent(event);
        }
    }

    public static TGTransportDialog getInstance(TGContext context) {
        return (TGTransportDialog)TGSingletonUtil.getInstance((TGContext)context, (String)TGTransportDialog.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGTransportDialog>(){

            public TGTransportDialog createInstance(TGContext context) {
                return new TGTransportDialog(context);
            }
        });
    }

    private void updateHeaderMap() {
        TGSong song = TGDocumentManager.getInstance((TGContext)this.context).getSong();
        this.headerMap.clear();
        TreeSet<TGMeasureHeader> headers = new TreeSet<TGMeasureHeader>(Comparator.comparingLong(TGMeasureHeader::getStart));
        for (int i = 0; i < song.countMeasureHeaders(); ++i) {
            headers.add(song.getMeasureHeader(i));
        }
        for (TGMeasureHeader header : headers) {
            this.headerMap.put(header.getStart(), header);
        }
    }
}

