/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.track;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.system.icons.TGIconManager;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.util.TGMessageDialogUtil;
import app.tuxguitar.app.view.controller.TGViewContext;
import app.tuxguitar.app.view.dialog.track.TGTrackTuningChooserDialog;
import app.tuxguitar.app.view.dialog.track.TGTrackTuningChooserHandler;
import app.tuxguitar.app.view.dialog.track.TGTrackTuningModel;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.editor.util.TGSyncProcessLocked;
import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.helpers.tuning.TuningGroup;
import app.tuxguitar.song.helpers.tuning.TuningPreset;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.song.models.TGString;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UIMouseDoubleClickListener;
import app.tuxguitar.ui.event.UIMouseEvent;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIDropDownSelect;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILayoutContainer;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UISelectItem;
import app.tuxguitar.ui.widget.UISpinner;
import app.tuxguitar.ui.widget.UITable;
import app.tuxguitar.ui.widget.UITableItem;
import app.tuxguitar.ui.widget.UITextField;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGMusicKeyUtils;
import java.util.ArrayList;
import java.util.List;

public class TGTrackTuningDialog {
    private static final float MINIMUM_BUTTON_WIDTH = 80.0f;
    private static final float MINIMUM_BUTTON_HEIGHT = 25.0f;
    private TGViewContext context;
    private UIWindow dialog;
    private TuningGroup allTuningsGroup;
    private List<TGTrackTuningModel> tuning;
    private UITable<TGTrackTuningModel> tuningTable;
    private UISpinner offsetSpinner;
    private UIButton buttonEdit;
    private UIButton buttonDelete;
    private UIButton buttonMoveUp;
    private UIButton buttonMoveDown;
    private UIPanel presetsPanel;
    private UIButton buttonPresetSave;
    private UIButton buttonPresetSaveAs;
    private UIButton buttonPresetDelete;
    private UITextField newPresetName;
    private TuningPreset currentSelectedPreset;
    private boolean isNewPreset;

    public TGTrackTuningDialog(TGViewContext context) {
        this.context = context;
        TuningGroup tgTunings = TuxGuitar.getInstance().getTuningManager().getTgTuningsGroup();
        TuningGroup customTunings = TuxGuitar.getInstance().getTuningManager().getCustomTuningsGroup();
        customTunings.setName(TuxGuitar.getProperty("tuning.preset.select"));
        this.allTuningsGroup = new TuningGroup();
        this.allTuningsGroup.addGroup(customTunings);
        for (TuningGroup group : tgTunings.getGroups()) {
            this.allTuningsGroup.addGroup(group);
        }
    }

    public void show() {
        TGTrack track = this.findTrack();
        if (!track.isPercussion()) {
            this.tuning = TGTrackTuningDialog.getTuningFromTrack(track);
            UIFactory factory = this.getUIFactory();
            UIWindow parent = (UIWindow)this.context.getAttribute("parent");
            UITableLayout dialogLayout = new UITableLayout();
            this.dialog = factory.createWindow(parent, true, false);
            this.dialog.setLayout((UILayout)dialogLayout);
            this.dialog.setText(TuxGuitar.getProperty("tuning"));
            UITableLayout leftUpperPanelLayout = new UITableLayout();
            UILegendPanel leftUpperPanel = factory.createLegendPanel((UIContainer)this.dialog);
            leftUpperPanel.setLayout((UILayout)leftUpperPanelLayout);
            leftUpperPanel.setText(TuxGuitar.getProperty("tuning.presets"));
            dialogLayout.set((UIControl)leftUpperPanel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            UITableLayout leftLowerPanelLayout = new UITableLayout();
            UILegendPanel leftLowerPanel = factory.createLegendPanel((UIContainer)this.dialog);
            leftLowerPanel.setLayout((UILayout)leftLowerPanelLayout);
            leftLowerPanel.setText(TuxGuitar.getProperty("tuning.strings"));
            dialogLayout.set((UIControl)leftLowerPanel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            UITableLayout rightPanelLayout = new UITableLayout();
            UILegendPanel rightPanel = factory.createLegendPanel((UIContainer)this.dialog);
            rightPanel.setLayout((UILayout)rightPanelLayout);
            rightPanel.setText(TuxGuitar.getProperty("options"));
            dialogLayout.set((UIControl)rightPanel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(2), Integer.valueOf(1));
            UITableLayout bottomPanelLayout = new UITableLayout(Float.valueOf(0.0f));
            UIPanel bottomPanel = factory.createPanel((UIContainer)this.dialog, false);
            bottomPanel.setLayout((UILayout)bottomPanelLayout);
            dialogLayout.set((UIControl)bottomPanel, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(2));
            this.initTuningPresets((UILayoutContainer)leftUpperPanel);
            this.initTuningStringTable((UILayoutContainer)leftLowerPanel);
            this.initTuningOptions((UILayoutContainer)rightPanel, track);
            this.initButtons((UILayoutContainer)bottomPanel);
            this.updateTuningControls();
            TGDialogUtil.openDialog(this.dialog, 5);
        }
    }

    private TuningPreset findTuningInGroup(List<TGTrackTuningModel> tuningModel, TuningGroup group) {
        if (group.getGroups() != null && !group.getGroups().isEmpty()) {
            for (TuningGroup searchGroup : group.getGroups()) {
                TuningPreset found = this.findTuningInGroup(this.tuning, searchGroup);
                if (found == null) continue;
                return found;
            }
        } else {
            for (TuningPreset preset : group.getTunings()) {
                if (!this.areTuningsEqual(tuningModel, preset)) continue;
                return preset;
            }
        }
        return null;
    }

    private TuningPreset findTuningInGroup(String tuningName, TuningGroup group) {
        if (group.getGroups() != null && !group.getGroups().isEmpty()) {
            for (TuningGroup searchGroup : group.getGroups()) {
                TuningPreset found = this.findTuningInGroup(tuningName, searchGroup);
                if (found == null) continue;
                return found;
            }
        } else {
            for (TuningPreset preset : group.getTunings()) {
                if (!tuningName.equals(preset.getName())) continue;
                return preset;
            }
        }
        return null;
    }

    private String findUnsavedPresetName() {
        String name = TuxGuitar.getProperty("file.save.default-name") + " ";
        int n = 1;
        TuningGroup customTuningsGroup = (TuningGroup)this.allTuningsGroup.getGroups().get(0);
        while (this.findTuningInGroup(name + String.valueOf(n), customTuningsGroup) != null) {
            ++n;
        }
        return name + String.valueOf(n);
    }

    private void populateGroupsDropDown(UIDropDownSelect<TuningGroup> select, TuningGroup group, TuningGroup groupToSelect) {
        select.setIgnoreEvents(true);
        select.removeItems();
        if (group != null) {
            for (TuningGroup subGroup : group.getGroups()) {
                boolean wasEmpty = select.getItemCount() == 0;
                select.addItem(new UISelectItem(subGroup.getName(), (Object)subGroup));
                if ((!wasEmpty || groupToSelect != null) && subGroup != groupToSelect) continue;
                select.setSelectedValue((Object)subGroup);
            }
        }
        select.setEnabled(select.getItemCount() > 0);
        select.setIgnoreEvents(false);
    }

    private void populateTuningsDropDown(UIDropDownSelect<TuningPreset> select, TuningGroup group, TuningPreset presetToSelect) {
        select.setIgnoreEvents(true);
        select.removeItems();
        if (group != null) {
            for (TuningPreset tuning : group.getTunings()) {
                select.addItem(new UISelectItem(this.tuningPresetLabel(tuning), (Object)tuning));
            }
            if (presetToSelect != null) {
                select.setSelectedValue((Object)presetToSelect);
                this.currentSelectedPreset = presetToSelect;
            } else {
                this.currentSelectedPreset = null;
            }
        }
        select.setEnabled(select.getItemCount() > 0);
        select.setIgnoreEvents(false);
    }

    private String tuningPresetLabel(TuningPreset preset) {
        StringBuilder label = new StringBuilder();
        label.append(preset.getName()).append(" - ");
        int[] values = preset.getValues();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                label.append(" ");
            }
            label.append(TGMusicKeyUtils.sharpNoteName((int)values[values.length - i - 1]));
        }
        return label.toString();
    }

    private void initTuningPresets(UILayoutContainer parent) {
        UIFactory factory = this.getUIFactory();
        UITableLayout parentLayout = (UITableLayout)parent.getLayout();
        UITableLayout panelLayout = new UITableLayout();
        UIPanel panel = factory.createPanel((UIContainer)parent, false);
        panel.setLayout((UILayout)panelLayout);
        parentLayout.set((UIControl)panel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.presetsPanel = factory.createPanel((UIContainer)panel, false);
        panelLayout.set((UIControl)this.presetsPanel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
        panelLayout.set((UIControl)this.presetsPanel, "packed_width", (Object)Float.valueOf(450.0f));
        panelLayout.set((UIControl)this.presetsPanel, "packed_height", (Object)Float.valueOf(110.0f));
    }

    private void initTuningStringTable(UILayoutContainer parent) {
        UIFactory factory = this.getUIFactory();
        UITableLayout parentLayout = (UITableLayout)parent.getLayout();
        UITableLayout panelLayout = new UITableLayout();
        UIPanel panel = factory.createPanel((UIContainer)parent, false);
        panel.setLayout((UILayout)panelLayout);
        parentLayout.set((UIControl)panel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.tuningTable = factory.createTable((UIContainer)panel, true);
        this.tuningTable.setColumns(2);
        this.tuningTable.setColumnName(0, TuxGuitar.getProperty("tuning.label"));
        this.tuningTable.setColumnName(1, TuxGuitar.getProperty("tuning.value"));
        this.tuningTable.addMouseDoubleClickListener(new UIMouseDoubleClickListener(){

            public void onMouseDoubleClick(UIMouseEvent event) {
                TGTrackTuningDialog.this.onEditTuningModel();
            }
        });
        panelLayout.set(this.tuningTable, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(true));
        panelLayout.set(this.tuningTable, "packed_width", (Object)Float.valueOf(320.0f));
        panelLayout.set(this.tuningTable, "packed_height", (Object)Float.valueOf(200.0f));
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttonsPanel = factory.createPanel((UIContainer)panel, false);
        buttonsPanel.setLayout((UILayout)buttonsLayout);
        panelLayout.set((UIControl)buttonsPanel, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        UIButton buttonAdd = factory.createButton((UIContainer)buttonsPanel);
        buttonAdd.setImage(TGIconManager.getInstance(this.context.getContext()).getListAdd());
        buttonAdd.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTrackTuningDialog.this.onAddTuningModel();
            }
        });
        this.buttonEdit = factory.createButton((UIContainer)buttonsPanel);
        this.buttonEdit.setImage(TGIconManager.getInstance(this.context.getContext()).getListEdit());
        this.buttonEdit.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTrackTuningDialog.this.onEditTuningModel();
            }
        });
        this.buttonMoveUp = factory.createButton((UIContainer)buttonsPanel);
        this.buttonMoveUp.setImage(TGIconManager.getInstance(this.context.getContext()).getImageByName("arrow_up.png"));
        this.buttonMoveUp.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTrackTuningDialog.this.moveString(-1);
            }
        });
        this.buttonMoveDown = factory.createButton((UIContainer)buttonsPanel);
        this.buttonMoveDown.setImage(TGIconManager.getInstance(this.context.getContext()).getImageByName("arrow_down.png"));
        this.buttonMoveDown.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTrackTuningDialog.this.moveString(1);
            }
        });
        this.buttonDelete = factory.createButton((UIContainer)buttonsPanel);
        this.buttonDelete.setImage(TGIconManager.getInstance(this.context.getContext()).getImageByName("list_remove.png"));
        this.buttonDelete.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTrackTuningDialog.this.onRemoveTuningModel();
            }
        });
        this.tuningTable.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTrackTuningDialog.this.updateTuningButtons();
            }
        });
        buttonsLayout.set((UIControl)buttonAdd, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        buttonsLayout.set((UIControl)this.buttonDelete, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        buttonsLayout.set((UIControl)this.buttonMoveUp, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
        buttonsLayout.set((UIControl)this.buttonMoveDown, Integer.valueOf(1), Integer.valueOf(4), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        buttonsLayout.set((UIControl)this.buttonEdit, Integer.valueOf(1), Integer.valueOf(5), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
    }

    private void updatePresetsPanel(TuningGroup selectGroup, TuningPreset selectPreset) {
        if (selectGroup != null && selectPreset != null) {
            return;
        }
        UIFactory factory = this.getUIFactory();
        TuningGroup group = null;
        int nDropDown = 0;
        boolean bl = this.isNewPreset = selectGroup == null && selectPreset == null;
        List<TuningGroup> selectedGroupsList = selectGroup == null ? (selectPreset == null ? this.findParentGroups((TuningGroup)this.allTuningsGroup.getGroups().get(0)) : this.findParentGroups(selectPreset)) : this.findParentGroups(selectGroup);
        if (selectedGroupsList == null || selectedGroupsList.size() == 0) {
            return;
        }
        if (selectGroup != null || selectPreset != null || this.currentSelectedPreset == null || !this.isCustomTuningPreset(this.currentSelectedPreset)) {
            for (UIControl control : this.presetsPanel.getChildren()) {
                control.dispose();
            }
            UITableLayout presetsPanelLayout = new UITableLayout(Float.valueOf(0.0f));
            this.presetsPanel.setLayout((UILayout)presetsPanelLayout);
            group = selectedGroupsList.get(0);
            while (group.getGroups().size() > 0) {
                UIDropDownSelect groupSelect = factory.createDropDownSelect((UIContainer)this.presetsPanel);
                presetsPanelLayout.set((UIControl)groupSelect, Integer.valueOf(1 + nDropDown), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
                TuningGroup selectedGroupInList = null;
                if (selectedGroupsList.size() > nDropDown + 1) {
                    selectedGroupInList = selectedGroupsList.get(nDropDown + 1);
                }
                this.populateGroupsDropDown((UIDropDownSelect<TuningGroup>)groupSelect, group, selectedGroupInList);
                groupSelect.addSelectionListener(new UISelectionListener(){

                    public void onSelect(UISelectionEvent event) {
                        TGTrackTuningDialog.this.onSelectGroup((UIDropDownSelect<TuningGroup>)((UIDropDownSelect)event.getComponent()));
                    }
                });
                ++nDropDown;
                group = selectedGroupInList != null ? selectedGroupInList : (TuningGroup)group.getGroups().get(0);
            }
            UIDropDownSelect tuningSelect = factory.createDropDownSelect((UIContainer)this.presetsPanel);
            presetsPanelLayout.set((UIControl)tuningSelect, Integer.valueOf(1 + nDropDown), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
            TuningPreset toSelect = null;
            if (selectPreset != null) {
                toSelect = selectPreset;
            } else if (selectGroup != null && group.getTunings().size() > 0) {
                toSelect = (TuningPreset)group.getTunings().get(0);
            }
            this.populateTuningsDropDown((UIDropDownSelect<TuningPreset>)tuningSelect, group, toSelect);
            if (tuningSelect.getSelectedValue() != null) {
                this.updateTuningTable((TuningPreset)tuningSelect.getSelectedValue());
            }
            tuningSelect.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    TGTrackTuningDialog.this.onSelectPreset((UIDropDownSelect<TuningPreset>)((UIDropDownSelect)event.getComponent()));
                }
            });
            if (this.currentSelectedPreset == null || this.isCustomTuningPreset(this.currentSelectedPreset)) {
                this.buttonPresetDelete = factory.createButton((UIContainer)this.presetsPanel);
                this.buttonPresetDelete.setImage(TGIconManager.getInstance(this.context.getContext()).getImageByName("list_remove.png"));
                this.buttonPresetDelete.setToolTipText(TuxGuitar.getProperty("tuning.preset.delete"));
                this.buttonPresetDelete.addSelectionListener(new UISelectionListener(){

                    public void onSelect(UISelectionEvent event) {
                        TGTrackTuningDialog.this.onDeletePreset();
                    }
                });
                presetsPanelLayout.set((UIControl)this.buttonPresetDelete, Integer.valueOf(1 + nDropDown), Integer.valueOf(2), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
                this.buttonPresetSave = factory.createButton((UIContainer)this.presetsPanel);
                this.buttonPresetSave.setImage(TGIconManager.getInstance(this.context.getContext()).getImageByName("save.png"));
                this.buttonPresetSave.setToolTipText(TuxGuitar.getProperty("tuning.preset.save"));
                this.buttonPresetSave.addSelectionListener(new UISelectionListener(){

                    public void onSelect(UISelectionEvent event) {
                        TGTrackTuningDialog.this.onSavePreset();
                    }
                });
                presetsPanelLayout.set((UIControl)this.buttonPresetSave, Integer.valueOf(1 + nDropDown), Integer.valueOf(3), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
                this.newPresetName = factory.createTextField((UIContainer)this.presetsPanel);
                this.newPresetName.setEnabled(true);
                this.newPresetName.setTextLimit(Integer.valueOf(20));
                presetsPanelLayout.set((UIControl)this.newPresetName, Integer.valueOf(2 + nDropDown), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
                this.buttonPresetSaveAs = factory.createButton((UIContainer)this.presetsPanel);
                this.buttonPresetSaveAs.setImage(TGIconManager.getInstance(this.context.getContext()).getImageByName("save-as.png"));
                this.buttonPresetSaveAs.setToolTipText(TuxGuitar.getProperty("tuning.preset.saveas"));
                this.buttonPresetSaveAs.addSelectionListener(new UISelectionListener(){

                    public void onSelect(UISelectionEvent event) {
                        TGTrackTuningDialog.this.onSavePresetAs();
                    }
                });
                this.buttonPresetSaveAs.setEnabled(true);
                presetsPanelLayout.set((UIControl)this.buttonPresetSaveAs, Integer.valueOf(2 + nDropDown), Integer.valueOf(2), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
            }
            this.presetsPanel.layout();
        }
        this.updatePresetsButtons();
        this.updateTuningButtons();
    }

    private void updatePresetsButtons() {
        if (this.currentSelectedPreset == null || this.isCustomTuningPreset(this.currentSelectedPreset)) {
            boolean isModifiedTuning = this.isNewPreset && this.currentSelectedPreset != null;
            this.buttonPresetDelete.setEnabled(this.currentSelectedPreset != null);
            this.buttonPresetSave.setEnabled(isModifiedTuning);
            if (this.isNewPreset) {
                this.newPresetName.setText(this.findUnsavedPresetName());
            }
        }
    }

    private void initTuningOptions(UILayoutContainer parent, TGTrack track) {
        UIFactory factory = this.getUIFactory();
        UITableLayout parentLayout = (UITableLayout)parent.getLayout();
        UITableLayout panelLayout = new UITableLayout();
        UIPanel panel = factory.createPanel((UIContainer)parent, false);
        panel.setLayout((UILayout)panelLayout);
        parentLayout.set((UIControl)panel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout topLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel top = factory.createPanel((UIContainer)panel, false);
        top.setLayout((UILayout)topLayout);
        panelLayout.set((UIControl)top, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        UILabel offsetLabel = factory.createLabel((UIContainer)top);
        offsetLabel.setText(TuxGuitar.getProperty("tuning.offset") + ":");
        topLayout.set((UIControl)offsetLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.offsetSpinner = factory.createSpinner((UIContainer)top);
        this.offsetSpinner.setMinimum(-24);
        this.offsetSpinner.setMaximum(24);
        this.offsetSpinner.setValue(track.getOffset());
        topLayout.set((UIControl)this.offsetSpinner, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
    }

    private void initButtons(UILayoutContainer parent) {
        UIFactory factory = this.getUIFactory();
        UITableLayout parentLayout = (UITableLayout)parent.getLayout();
        UIButton buttonOK = factory.createButton((UIContainer)parent);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                new TGSyncProcessLocked(TGTrackTuningDialog.this.getContext().getContext(), new Runnable(){

                    @Override
                    public void run() {
                        if (TGTrackTuningDialog.this.updateTrackTuning()) {
                            TGTrackTuningDialog.this.dialog.dispose();
                        }
                    }
                }).process();
            }
        });
        parentLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = factory.createButton((UIContainer)parent);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTrackTuningDialog.this.dialog.dispose();
            }
        });
        parentLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        parentLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
    }

    private void onSelectGroup(UIDropDownSelect<TuningGroup> select) {
        this.updatePresetsPanel((TuningGroup)select.getSelectedValue(), null);
    }

    private void onSelectPreset(UIDropDownSelect<TuningPreset> select) {
        this.currentSelectedPreset = (TuningPreset)select.getSelectedValue();
        this.updateTuningTable((TuningPreset)select.getSelectedValue());
        this.updatePresetsButtons();
        this.updateTuningButtons();
    }

    private void onSavePreset() {
        TuningGroup customTuningsGroup = (TuningGroup)this.allTuningsGroup.getGroups().get(0);
        TuningPreset preset = this.convertTuning(customTuningsGroup, this.currentSelectedPreset.getName(), this.tuning);
        customTuningsGroup.removeTuningPreset(this.currentSelectedPreset);
        customTuningsGroup.addTuningPreset(preset);
        TuxGuitar.getInstance().getTuningManager().saveCustomTunings(customTuningsGroup);
        this.updatePresetsPanel(null, preset);
    }

    private void onSavePresetAs() {
        TuningGroup customTuningsGroup = (TuningGroup)this.allTuningsGroup.getGroups().get(0);
        TuningPreset preset = this.convertTuning(customTuningsGroup, this.newPresetName.getText(), this.tuning);
        customTuningsGroup.addTuningPreset(preset);
        TuxGuitar.getInstance().getTuningManager().saveCustomTunings(customTuningsGroup);
        this.updatePresetsPanel(null, preset);
    }

    private void onDeletePreset() {
        TuningGroup customTuningsGroup = (TuningGroup)this.allTuningsGroup.getGroups().get(0);
        customTuningsGroup.removeTuningPreset(this.currentSelectedPreset);
        TuxGuitar.getInstance().getTuningManager().saveCustomTunings(customTuningsGroup);
        this.currentSelectedPreset = null;
        this.updatePresetsPanel(null, null);
    }

    private void updateTuningTable(TuningPreset preset) {
        this.tuning.clear();
        if (preset != null && preset.getValues().length > 0) {
            for (int value : preset.getValues()) {
                TGTrackTuningModel model = new TGTrackTuningModel();
                model.setValue(value);
                this.tuning.add(model);
            }
            this.updateTuningTable();
        }
    }

    private void onAddTuningModel() {
        new TGTrackTuningChooserDialog(this).select(new TGTrackTuningChooserHandler(){

            @Override
            public void handleSelection(TGTrackTuningModel model) {
                TGTrackTuningDialog.this.addTuningModel(model);
            }
        });
    }

    private void onEditTuningModel() {
        final TGTrackTuningModel editingModel = (TGTrackTuningModel)this.tuningTable.getSelectedValue();
        if (editingModel != null) {
            new TGTrackTuningChooserDialog(this).select(new TGTrackTuningChooserHandler(){
                final /* synthetic */ TGTrackTuningDialog this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void handleSelection(TGTrackTuningModel model) {
                    editingModel.setValue(model.getValue());
                    this.this$0.updateTuningControls();
                }
            }, editingModel);
        }
    }

    private void onRemoveTuningModel() {
        TGTrackTuningModel model = (TGTrackTuningModel)this.tuningTable.getSelectedValue();
        if (model != null) {
            this.removeTuningModel(model);
        }
    }

    private List<TuningGroup> findParentGroups(TuningGroup group) {
        if (group == null) {
            return null;
        }
        ArrayList<TuningGroup> listGroups = new ArrayList<TuningGroup>();
        do {
            listGroups.add(0, group);
        } while ((group = group.getParent()) != null);
        return listGroups;
    }

    private List<TuningGroup> findParentGroups(TuningPreset preset) {
        return this.findParentGroups(preset.getParent());
    }

    private void moveString(int delta) {
        TGTrackTuningModel model = (TGTrackTuningModel)this.tuningTable.getSelectedValue();
        if (model != null) {
            int index = this.tuning.indexOf(model);
            this.tuning.remove(index);
            this.tuning.add(index + delta, model);
            this.updateTuningControls();
        }
    }

    private boolean isCustomTuningPreset(TuningPreset preset) {
        if (preset == null) {
            return false;
        }
        for (TuningGroup parent = preset.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.equals(this.allTuningsGroup.getGroups().get(0))) continue;
            return true;
        }
        return false;
    }

    private TuningPreset convertTuning(TuningGroup parent, String name, List<TGTrackTuningModel> tuningModel) {
        int[] noteValues = new int[tuningModel.size()];
        for (int i = 0; i < tuningModel.size(); ++i) {
            noteValues[i] = tuningModel.get(i).getValue();
        }
        return new TuningPreset(parent, name, noteValues);
    }

    private boolean areTuningsEqual(List<TGTrackTuningModel> tuningModel, TuningPreset tuningPreset) {
        if (tuningModel == null && tuningPreset == null) {
            return true;
        }
        if (tuningModel != null && tuningPreset == null) {
            return false;
        }
        if (tuningModel == null && tuningPreset != null) {
            return false;
        }
        if (tuningPreset.getValues().length != tuningModel.size()) {
            return false;
        }
        for (int i = 0; i < tuningModel.size(); ++i) {
            if (tuningPreset.getValues()[i] == tuningModel.get(i).getValue()) continue;
            return false;
        }
        return true;
    }

    private void updateTuningTable() {
        TGTrackTuningModel selection = (TGTrackTuningModel)this.tuningTable.getSelectedValue();
        this.tuningTable.removeItems();
        for (TGTrackTuningModel model : this.tuning) {
            UITableItem item = new UITableItem((Object)model);
            item.setText(0, TGMusicKeyUtils.sharpNoteName((int)model.getValue()));
            item.setText(1, TGMusicKeyUtils.sharpNoteFullName((int)model.getValue()));
            this.tuningTable.addItem(item);
        }
        if (selection != null) {
            this.tuningTable.setSelectedValue((Object)selection);
        }
    }

    private void updateTuningButtons() {
        TGTrackTuningModel model = (TGTrackTuningModel)this.tuningTable.getSelectedValue();
        int index = model != null ? this.tuning.indexOf(model) : -1;
        this.buttonEdit.setEnabled(model != null);
        this.buttonDelete.setEnabled(model != null);
        this.buttonMoveUp.setEnabled(model != null && index > 0);
        this.buttonMoveDown.setEnabled(model != null && index < this.tuning.size() - 1);
    }

    private void updateTuningControls() {
        this.updateTuningTable();
        this.updatePresetsPanel(null, this.findTuningInGroup(this.tuning, this.allTuningsGroup));
        this.updateTuningButtons();
    }

    private static List<TGTrackTuningModel> getTuningFromTrack(TGTrack track) {
        ArrayList<TGTrackTuningModel> tuning = new ArrayList<TGTrackTuningModel>();
        for (int i = 0; i < track.stringCount(); ++i) {
            TGString string = track.getString(i + 1);
            TGTrackTuningModel model = new TGTrackTuningModel();
            model.setValue(string.getValue());
            tuning.add(model);
        }
        return tuning;
    }

    private void addTuningModel(TGTrackTuningModel model) {
        if (this.tuning.add(model)) {
            this.updateTuningControls();
        }
    }

    private void removeTuningModel(TGTrackTuningModel model) {
        if (this.tuning.remove(model)) {
            this.updateTuningControls();
        }
    }

    private boolean updateTrackTuning() {
        TGSongManager songManager = this.findSongManager();
        TGSong song = this.findSong();
        TGTrack track = this.findTrack();
        ArrayList<TGString> strings = new ArrayList<TGString>();
        for (int i = 0; i < this.tuning.size(); ++i) {
            strings.add(TGSongManager.newString((TGFactory)this.findSongManager().getFactory(), (int)(i + 1), (int)this.tuning.get(i).getValue()));
        }
        Integer offset = songManager.isPercussionChannel(song, track.getChannelId()) ? 0 : this.offsetSpinner.getValue();
        boolean offsetChanges = offset != null && !offset.equals(track.getOffset());
        boolean tuningChanges = this.hasTuningChanges(track, strings);
        if (this.validateTrackTuning(strings)) {
            if (tuningChanges || offsetChanges) {
                TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context.getContext(), "action.track.change-tuning");
                tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)song);
                tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)track);
                if (tuningChanges) {
                    tgActionProcessor.setAttribute("strings", strings);
                }
                if (offsetChanges) {
                    tgActionProcessor.setAttribute("offset", (Object)offset);
                }
                tgActionProcessor.process();
            }
            return true;
        }
        return false;
    }

    private boolean validateTrackTuning(List<TGString> strings) {
        if (strings.size() < 1 || strings.size() > 25) {
            TGMessageDialogUtil.errorMessage(this.getContext().getContext(), this.dialog, TuxGuitar.getProperty("tuning.strings.range-error", new String[]{Integer.toString(1), Integer.toString(25)}));
            return false;
        }
        return true;
    }

    private boolean hasTuningChanges(TGTrack track, List<TGString> newStrings) {
        List oldStrings = track.getStrings();
        if (oldStrings.size() != newStrings.size()) {
            return true;
        }
        for (int i = 0; i < oldStrings.size(); ++i) {
            TGString oldString = (TGString)oldStrings.get(i);
            boolean stringExists = false;
            for (int j = 0; j < newStrings.size(); ++j) {
                TGString newString = newStrings.get(j);
                if (!newString.isEqual(oldString)) continue;
                stringExists = true;
            }
            if (stringExists) continue;
            return true;
        }
        return false;
    }

    private TGSongManager findSongManager() {
        return (TGSongManager)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG_MANAGER);
    }

    private TGSong findSong() {
        return (TGSong)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
    }

    private TGTrack findTrack() {
        return (TGTrack)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
    }

    public TGViewContext getContext() {
        return this.context;
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.context.getContext()).getFactory();
    }

    public UIWindow getDialog() {
        return this.dialog;
    }
}

