/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.timesignature;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.component.tab.TablatureEditor;
import app.tuxguitar.app.view.controller.TGViewContext;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGMeasureHeader;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.song.models.TGTimeSignature;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UICheckBox;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIDropDownSelect;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UISelectItem;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;

public class TGTimeSignatureDialog {
    public void show(final TGViewContext context) {
        final TGSongManager songManager = (TGSongManager)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG_MANAGER);
        final TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        final TGMeasureHeader header = (TGMeasureHeader)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER);
        UIFactory uiFactory = TGApplication.getInstance(context.getContext()).getFactory();
        UIWindow uiParent = (UIWindow)context.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty("composition.timesignature"));
        UITableLayout timeSignatureLayout = new UITableLayout();
        UILegendPanel timeSignature = uiFactory.createLegendPanel((UIContainer)dialog);
        timeSignature.setLayout((UILayout)timeSignatureLayout);
        timeSignature.setText(TuxGuitar.getProperty("composition.timesignature"));
        dialogLayout.set((UIControl)timeSignature, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        TGTimeSignature currentTimeSignature = header.getTimeSignature();
        UILabel numeratorLabel = uiFactory.createLabel((UIContainer)timeSignature);
        numeratorLabel.setText(TuxGuitar.getProperty("composition.timesignature.Numerator") + ":");
        timeSignatureLayout.set((UIControl)numeratorLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UIDropDownSelect numerator = uiFactory.createDropDownSelect((UIContainer)timeSignature);
        for (int i = 1; i <= 32; ++i) {
            numerator.addItem(new UISelectItem(Integer.toString(i), (Object)i));
        }
        numerator.setSelectedValue((Object)currentTimeSignature.getNumerator());
        timeSignatureLayout.set((UIControl)numerator, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(150.0f), null, null);
        UILabel denominatorLabel = uiFactory.createLabel((UIContainer)timeSignature);
        denominatorLabel.setText(TuxGuitar.getProperty("composition.timesignature.denominator") + ":");
        timeSignatureLayout.set((UIControl)denominatorLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UIDropDownSelect denominator = uiFactory.createDropDownSelect((UIContainer)timeSignature);
        for (int i = 1; i <= 32; i *= 2) {
            denominator.addItem(new UISelectItem(Integer.toString(i), (Object)i));
        }
        denominator.setSelectedValue((Object)currentTimeSignature.getDenominator().getValue());
        timeSignatureLayout.set((UIControl)denominator, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(150.0f), null, null);
        UITableLayout checkLayout = new UITableLayout();
        UILegendPanel check = uiFactory.createLegendPanel((UIContainer)dialog);
        check.setLayout((UILayout)checkLayout);
        check.setText(TuxGuitar.getProperty("options"));
        dialogLayout.set((UIControl)check, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UICheckBox toEnd = uiFactory.createCheckBox((UIContainer)check);
        toEnd.setText(TuxGuitar.getProperty("composition.timesignature.to-the-end"));
        toEnd.setSelected(true);
        checkLayout.set((UIControl)toEnd, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGTimeSignatureDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                this.this$0.changeTimeSignature(context.getContext(), song, header, this.this$0.parseTimeSignature(songManager, (UIDropDownSelect<Integer>)numerator, (UIDropDownSelect<Integer>)denominator), toEnd.isSelected());
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGTimeSignatureDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog(dialog, 5);
    }

    public TGTimeSignature parseTimeSignature(TGSongManager songManager, UIDropDownSelect<Integer> numerator, UIDropDownSelect<Integer> denominator) {
        TGTimeSignature tgTimeSignature = songManager.getFactory().newTimeSignature();
        tgTimeSignature.setNumerator(((Integer)numerator.getSelectedValue()).intValue());
        tgTimeSignature.getDenominator().setValue(((Integer)denominator.getSelectedValue()).intValue());
        return tgTimeSignature;
    }

    public void changeTimeSignature(TGContext context, TGSong song, TGMeasureHeader header, TGTimeSignature timeSignature, Boolean applyToEnd) {
        TablatureEditor.getInstance(context).getTablature().getSelector().clearSelection();
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.composition.change-time-signature");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER, (Object)header);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TIME_SIGNATURE, (Object)timeSignature);
        tgActionProcessor.setAttribute("applyToEnd", (Object)applyToEnd);
        tgActionProcessor.processOnNewThread();
    }
}

