/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.settings.items;

import app.tuxguitar.app.system.config.TGConfigManager;
import app.tuxguitar.app.view.component.tab.TablatureEditor;
import app.tuxguitar.app.view.controller.TGViewContext;
import app.tuxguitar.app.view.dialog.settings.TGSettingsEditor;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UIDisposeEvent;
import app.tuxguitar.ui.event.UIDisposeListener;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.resource.UICursor;
import app.tuxguitar.ui.resource.UIFont;
import app.tuxguitar.ui.resource.UIImage;
import app.tuxguitar.ui.toolbar.UIToolBar;
import app.tuxguitar.ui.toolbar.UIToolCheckableItem;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIImageView;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILayoutContainer;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.properties.TGProperties;

public abstract class TGSettingsOption
implements UISelectionListener {
    public static final float DEFAULT_INDENT = 20.0f;
    private TGSettingsEditor configEditor;
    private UIToolBar toolBar;
    private UIToolCheckableItem toolItem;
    private UILegendPanel group;
    private UIPanel composite;

    public TGSettingsOption(TGSettingsEditor configEditor, UIToolBar toolBar, UILayoutContainer parent, String text, int horizontalAlignment, int verticalAlignment) {
        UIFactory uiFactory = configEditor.getUIFactory();
        UITableLayout parentLayout = (UITableLayout)parent.getLayout();
        UITableLayout groupLayout = new UITableLayout();
        this.configEditor = configEditor;
        this.toolBar = toolBar;
        this.toolItem = this.toolBar.createCheckItem();
        this.group = uiFactory.createLegendPanel((UIContainer)parent);
        this.group.setLayout((UILayout)groupLayout);
        this.group.setText(text);
        this.composite = uiFactory.createPanel((UIContainer)this.group, false);
        this.composite.setLayout((UILayout)new UITableLayout());
        groupLayout.set((UIControl)this.composite, Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(horizontalAlignment), Integer.valueOf(verticalAlignment), Boolean.valueOf(true), Boolean.valueOf(true));
        parentLayout.set((UIControl)this.group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), null, null, null, null, Float.valueOf(0.0f));
    }

    public TGSettingsOption(TGSettingsEditor configEditor, UIToolBar toolBar, UILayoutContainer parent, String text) {
        this(configEditor, toolBar, parent, text, UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP);
    }

    public abstract void createOption();

    public abstract void updateConfig();

    public abstract void updateDefaults();

    public void setVisible(boolean visible) {
        this.toolItem.setChecked(visible);
        this.group.setVisible(visible);
        this.group.setFocus();
        if (visible) {
            this.pack();
        }
    }

    public void dispose() {
    }

    protected UILabel showLabel(UILayoutContainer parent, String text, boolean bold, int row, int col) {
        return this.showLabel(parent, text, bold, row, col, UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER);
    }

    protected UILabel showLabel(UILayoutContainer parent, String text, boolean bold, int row, int col, int alignX, int alignY) {
        return this.showLabel(parent, text, bold, row, col, alignX, alignY, true, false);
    }

    protected UILabel showLabel(UILayoutContainer parent, String text, boolean bold, int row, int col, int alignX, int alignY, boolean fillX, boolean fillY) {
        UIFont defaultFont;
        UIFactory uiFactory = this.configEditor.getUIFactory();
        UILabel label = uiFactory.createLabel((UIContainer)parent);
        label.setText(text);
        UITableLayout parentLayout = (UITableLayout)parent.getLayout();
        parentLayout.set((UIControl)label, Integer.valueOf(row), Integer.valueOf(col), Integer.valueOf(alignX), Integer.valueOf(alignY), Boolean.valueOf(fillX), Boolean.valueOf(fillY));
        if (bold && (defaultFont = label.getFont()) != null) {
            final UIFont font = uiFactory.createFont(defaultFont.getName(), defaultFont.getHeight(), true, defaultFont.isItalic());
            label.setFont(font);
            label.addDisposeListener(new UIDisposeListener(){
                final /* synthetic */ TGSettingsOption this$0;
                {
                    this.this$0 = this$0;
                }

                public void onDispose(UIDisposeEvent event) {
                    font.dispose();
                }
            });
        }
        return label;
    }

    protected UIImageView showImageLabel(UILayoutContainer parent, UIImage image, int row, int col) {
        return this.showImageLabel(parent, image, row, col, UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, true, true);
    }

    protected UIImageView showImageLabel(UILayoutContainer parent, UIImage image, int row, int col, int alignX, int alignY, boolean fillX, boolean fillY) {
        UIFactory uiFactory = this.configEditor.getUIFactory();
        UIImageView uiImageView = uiFactory.createImageView((UIContainer)parent);
        uiImageView.setImage(image);
        UITableLayout parentLayout = (UITableLayout)parent.getLayout();
        parentLayout.set((UIControl)uiImageView, Integer.valueOf(row), Integer.valueOf(col), Integer.valueOf(alignX), Integer.valueOf(alignY), Boolean.valueOf(fillX), Boolean.valueOf(fillY));
        return uiImageView;
    }

    protected void indent(UIControl control, int row, int col) {
        this.indent(control, row, col, UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, true, true);
    }

    protected void indent(UIControl control, int row, int col, int alignX, int alignY, boolean fillX, boolean fillY) {
        this.indent(control, row, col, alignX, alignY, fillX, fillY, 20.0f);
    }

    protected void indent(UIControl control, int row, int col, int alignX, int alignY, boolean fillX, boolean fillY, float indent) {
        UILayoutContainer parent = (UILayoutContainer)control.getParent();
        UITableLayout layout = (UITableLayout)parent.getLayout();
        layout.set(control, Integer.valueOf(row), Integer.valueOf(col), Integer.valueOf(alignX), Integer.valueOf(alignY), Boolean.valueOf(fillX), Boolean.valueOf(fillY));
        layout.set(control, "margin_left", (Object)Float.valueOf(indent));
    }

    public void onSelect(UISelectionEvent event) {
        this.configEditor.select(this);
    }

    public UIPanel getPanel() {
        return this.composite;
    }

    public UIToolCheckableItem getToolItem() {
        return this.toolItem;
    }

    public TGConfigManager getConfig() {
        return this.configEditor.getConfig();
    }

    public TGViewContext getViewContext() {
        return this.configEditor.getViewContext();
    }

    public TGProperties getDefaults() {
        return this.configEditor.getDefaults();
    }

    public TablatureEditor getEditor() {
        return this.configEditor.getEditor();
    }

    public UIWindow getWindow() {
        return this.configEditor.getWindow();
    }

    public UIFactory getUIFactory() {
        return this.configEditor.getUIFactory();
    }

    protected boolean isDisposed() {
        return this.configEditor.isDisposed();
    }

    public void pack() {
        this.configEditor.pack();
    }

    public void loadCursor(UICursor cursor) {
        this.configEditor.loadCursor(cursor);
    }

    protected void addSyncThread(Runnable runnable) {
        this.configEditor.addSyncThread(runnable);
    }
}

