/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.settings.items;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.system.icons.TGSkinManager;
import app.tuxguitar.app.util.TGFileUtils;
import app.tuxguitar.app.view.dialog.settings.TGSettingsEditor;
import app.tuxguitar.app.view.dialog.settings.items.TGSettingsOption;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UIPaintEvent;
import app.tuxguitar.ui.event.UIPaintListener;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.resource.UICursor;
import app.tuxguitar.ui.resource.UIImage;
import app.tuxguitar.ui.resource.UIRectangle;
import app.tuxguitar.ui.toolbar.UIToolBar;
import app.tuxguitar.ui.widget.UICanvas;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIDropDownSelect;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILayoutContainer;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UISelectItem;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGSynchronizer;
import app.tuxguitar.util.properties.TGProperties;
import app.tuxguitar.util.properties.TGPropertiesUtil;
import java.util.ArrayList;
import java.util.List;

public class SkinOption
extends TGSettingsOption {
    private static final float PREVIEW_WIDTH = 450.0f;
    private static final float PREVIEW_HEIGHT = 324.0f;
    private boolean initialized = false;
    private List<SkinInfo> skins;
    private UIDropDownSelect<SkinInfo> combo;
    private UILabel nameLabel;
    private UILabel authorLabel;
    private UILabel versionLabel;
    private UILabel descriptionLabel;
    private UIImage preview;
    private UICanvas previewArea;
    private UIPanel skinInfoComposite;

    public SkinOption(TGSettingsEditor configEditor, UIToolBar toolBar, UILayoutContainer parent) {
        super(configEditor, toolBar, parent, TuxGuitar.getProperty("settings.config.skin"), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL);
    }

    @Override
    public void createOption() {
        UIFactory uiFactory = this.getUIFactory();
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.skin"));
        this.getToolItem().setImage(TuxGuitar.getInstance().getIconManager().getOptionSkin());
        this.getToolItem().addSelectionListener((UISelectionListener)this);
        this.showLabel((UILayoutContainer)this.getPanel(), TuxGuitar.getProperty("settings.config.skin.choose"), true, 1, 1);
        UITableLayout compositeLayout = new UITableLayout();
        UIPanel composite = uiFactory.createPanel((UIContainer)this.getPanel(), false);
        composite.setLayout((UILayout)compositeLayout);
        this.indent((UIControl)composite, 2, 1, UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, true, false);
        this.combo = uiFactory.createDropDownSelect((UIContainer)composite);
        compositeLayout.set(this.combo, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout skinInfoLayout = new UITableLayout();
        this.skinInfoComposite = uiFactory.createPanel((UIContainer)this.getPanel(), false);
        this.skinInfoComposite.setLayout((UILayout)skinInfoLayout);
        this.indent((UIControl)this.skinInfoComposite, 3, 1, UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_FILL, true, false);
        this.showLabel((UILayoutContainer)this.skinInfoComposite, TuxGuitar.getProperty("name") + ": ", true, 1, 1);
        this.nameLabel = this.showLabel((UILayoutContainer)this.skinInfoComposite, "-", false, 1, 2);
        this.showLabel((UILayoutContainer)this.skinInfoComposite, TuxGuitar.getProperty("author") + ": ", true, 2, 1);
        this.authorLabel = this.showLabel((UILayoutContainer)this.skinInfoComposite, "-", false, 2, 2);
        this.showLabel((UILayoutContainer)this.skinInfoComposite, TuxGuitar.getProperty("version") + ": ", true, 3, 1);
        this.versionLabel = this.showLabel((UILayoutContainer)this.skinInfoComposite, "-", false, 3, 2);
        this.showLabel((UILayoutContainer)this.skinInfoComposite, TuxGuitar.getProperty("description") + ": ", true, 4, 1);
        this.descriptionLabel = this.showLabel((UILayoutContainer)this.skinInfoComposite, "-", false, 4, 2);
        UITableLayout skinPreviewLayout = new UITableLayout();
        UIPanel skinPreviewComposite = uiFactory.createPanel((UIContainer)this.getPanel(), false);
        skinPreviewComposite.setLayout((UILayout)skinPreviewLayout);
        this.indent((UIControl)skinPreviewComposite, 4, 1, UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, true, false);
        this.previewArea = uiFactory.createCanvas((UIContainer)skinPreviewComposite, false);
        this.previewArea.addPaintListener(new UIPaintListener(){

            public void onPaint(UIPaintEvent event) {
                if (SkinOption.this.preview != null && !SkinOption.this.preview.isDisposed()) {
                    event.getPainter().drawImage(SkinOption.this.preview, 0.0f, 0.0f);
                }
            }
        });
        skinPreviewLayout.set((UIControl)this.previewArea, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        skinPreviewLayout.set((UIControl)this.previewArea, "packed_width", (Object)Float.valueOf(450.0f));
        skinPreviewLayout.set((UIControl)this.previewArea, "packed_height", (Object)Float.valueOf(324.0f));
        this.loadConfig();
    }

    public void loadConfig() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SkinOption.this.skins = new ArrayList();
                String[] skinNames = TGFileUtils.getFileNames(SkinOption.this.getViewContext().getContext(), "skins");
                if (skinNames != null) {
                    for (int i = 0; i < skinNames.length; ++i) {
                        TGProperties properties = TGSkinManager.getInstance(SkinOption.this.getViewContext().getContext()).getSkinInfo(skinNames[i]);
                        SkinInfo info = new SkinInfo(skinNames[i]);
                        info.setName(TGPropertiesUtil.getStringValue((TGProperties)properties, (String)"name", (String)info.getSkin()));
                        info.setAuthor(TGPropertiesUtil.getStringValue((TGProperties)properties, (String)"author", (String)"Not available."));
                        info.setVersion(TGPropertiesUtil.getStringValue((TGProperties)properties, (String)"version", (String)"Not available."));
                        info.setDescription(TGPropertiesUtil.getStringValue((TGProperties)properties, (String)"description", (String)"Not available."));
                        info.setDate(TGPropertiesUtil.getStringValue((TGProperties)properties, (String)"date"));
                        info.setPreview(TGPropertiesUtil.getStringValue((TGProperties)properties, (String)"preview"));
                        SkinOption.this.skins.add(info);
                    }
                }
                TGSynchronizer.getInstance((TGContext)SkinOption.this.getViewContext().getContext()).executeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!SkinOption.this.isDisposed()) {
                            for (SkinInfo info : SkinOption.this.skins) {
                                UISelectItem item = new UISelectItem(info.getName(), (Object)info);
                                SkinOption.this.combo.addItem(item);
                                if (!info.getSkin().equals(SkinOption.this.getConfig().getStringValue("skin"))) continue;
                                SkinOption.this.combo.setSelectedItem(item);
                            }
                            SkinOption.this.combo.addSelectionListener(new UISelectionListener(){

                                public void onSelect(UISelectionEvent event) {
                                    SkinOption.this.showSkinInfo();
                                }
                            });
                            SkinOption.this.showSkinInfo();
                            SkinOption.this.initialized = true;
                            SkinOption.this.pack();
                        }
                    }
                });
            }
        }).start();
    }

    public void showSkinInfo() {
        SkinInfo skinInfo = (SkinInfo)this.combo.getSelectedValue();
        if (skinInfo != null) {
            this.showSkinInfo(skinInfo);
        }
    }

    public void showSkinInfo(final SkinInfo info) {
        this.loadCursor(UICursor.WAIT);
        TGSynchronizer.getInstance((TGContext)this.getViewContext().getContext()).executeLater(new Runnable(){
            final /* synthetic */ SkinOption this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (!this.this$0.isDisposed()) {
                    this.this$0.disposePreview();
                    this.this$0.nameLabel.setText(info.getName());
                    this.this$0.authorLabel.setText(info.getAuthor());
                    this.this$0.descriptionLabel.setText(info.getDescription());
                    this.this$0.versionLabel.setText((String)(info.getDate() == null ? info.getVersion() : info.getVersion() + " (" + info.getDate() + ")"));
                    this.this$0.skinInfoComposite.computePackedSize(null, null);
                    UIRectangle skinInfoRect = this.this$0.skinInfoComposite.getBounds();
                    skinInfoRect.setSize(this.this$0.skinInfoComposite.getPackedContentSize());
                    this.this$0.skinInfoComposite.setBounds(skinInfoRect);
                    if (info.getPreview() != null) {
                        this.this$0.preview = TGFileUtils.loadImage(this.this$0.getViewContext().getContext(), info.getSkin(), info.getPreview());
                    }
                    this.this$0.previewArea.redraw();
                    this.this$0.loadCursor(UICursor.NORMAL);
                }
            }
        });
    }

    @Override
    public void updateConfig() {
        SkinInfo skinInfo;
        if (this.initialized && (skinInfo = (SkinInfo)this.combo.getSelectedValue()) != null) {
            this.getConfig().setValue("skin", skinInfo.getSkin());
        }
    }

    @Override
    public void updateDefaults() {
        if (this.initialized) {
            this.getConfig().setValue("skin", this.getDefaults().getValue("skin"));
        }
    }

    @Override
    public void dispose() {
        this.disposePreview();
    }

    public void disposePreview() {
        if (this.preview != null && !this.preview.isDisposed()) {
            this.preview.dispose();
        }
    }

    private class SkinInfo {
        private String skin;
        private String name;
        private String date;
        private String author;
        private String version;
        private String description;
        private String preview;

        public SkinInfo(String skin) {
            this.skin = skin;
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getSkin() {
            return this.skin;
        }

        public String getPreview() {
            return this.preview;
        }

        public void setPreview(String preview) {
            this.preview = preview;
        }
    }
}

