/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.measure;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.controller.TGViewContext;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.song.models.TGMeasureHeader;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UICheckBox;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UISpinner;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGBeatRange;
import app.tuxguitar.util.TGContext;
import java.util.Iterator;

public class TGMeasureCopyDialog {
    static boolean initCopyAllTracks = true;
    static boolean initCopyMarkers = false;

    public void show(final TGViewContext context) {
        int to;
        int from;
        final TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        TGTrack track = (TGTrack)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
        TGMeasureHeader header = (TGMeasureHeader)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER);
        TGBeatRange beats = (TGBeatRange)context.getAttribute("beat-range");
        UIFactory uiFactory = TGApplication.getInstance(context.getContext()).getFactory();
        UIWindow uiParent = (UIWindow)context.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty("edit.copy"));
        UITableLayout rangeLayout = new UITableLayout();
        UILegendPanel range = uiFactory.createLegendPanel((UIContainer)dialog);
        range.setLayout((UILayout)rangeLayout);
        range.setText(TuxGuitar.getProperty("edit.copy"));
        dialogLayout.set((UIControl)range, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        int measureCount = song.countMeasureHeaders();
        UILabel fromLabel = uiFactory.createLabel((UIContainer)range);
        fromLabel.setText(TuxGuitar.getProperty("edit.from") + ":");
        rangeLayout.set((UIControl)fromLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        if (beats != null && !beats.isEmpty()) {
            from = beats.firstMeasure().getNumber();
            to = beats.lastMeasure().getNumber();
        } else {
            from = header.getNumber();
            to = header.getNumber();
        }
        final UISpinner fromSpinner = uiFactory.createSpinner((UIContainer)range);
        fromSpinner.setMinimum(1);
        fromSpinner.setMaximum(measureCount);
        fromSpinner.setValue(from);
        rangeLayout.set((UIControl)fromSpinner, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(180.0f), null, null);
        UILabel toLabel = uiFactory.createLabel((UIContainer)range);
        toLabel.setText(TuxGuitar.getProperty("edit.to") + ":");
        rangeLayout.set((UIControl)toLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UISpinner toSpinner = uiFactory.createSpinner((UIContainer)range);
        toSpinner.setMinimum(1);
        toSpinner.setMaximum(measureCount);
        toSpinner.setValue(to);
        rangeLayout.set((UIControl)toSpinner, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(180.0f), null, null);
        boolean minSelection = true;
        final int maxSelection = track.countMeasures();
        UICheckBox allTracks = null;
        UITableLayout optionsLayout = new UITableLayout();
        UILegendPanel options = uiFactory.createLegendPanel((UIContainer)dialog);
        options.setLayout((UILayout)optionsLayout);
        options.setText(TuxGuitar.getProperty("options"));
        dialogLayout.set((UIControl)options, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        int rowCheckBox = 1;
        if (song.countTracks() > 1) {
            allTracks = uiFactory.createCheckBox((UIContainer)options);
            allTracks.setText(TuxGuitar.getProperty("edit.all-tracks"));
            allTracks.setSelected(initCopyAllTracks);
            optionsLayout.set((UIControl)allTracks, Integer.valueOf(rowCheckBox), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            ++rowCheckBox;
        }
        final UICheckBox allTracksFinal = allTracks;
        final UICheckBox copyMarkers = uiFactory.createCheckBox((UIContainer)options);
        copyMarkers.setText(TuxGuitar.getProperty("edit.copy-markers"));
        copyMarkers.setSelected(initCopyMarkers);
        optionsLayout.set((UIControl)copyMarkers, Integer.valueOf(rowCheckBox), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        fromSpinner.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGMeasureCopyDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                int fromSelection = fromSpinner.getValue();
                int toSelection = toSpinner.getValue();
                if (fromSelection < 1) {
                    fromSpinner.setValue(1);
                    fromSelection = 1;
                } else if (fromSelection > toSelection) {
                    fromSpinner.setValue(toSelection);
                    fromSelection = toSelection;
                }
                this.this$0.updateCopyMarkers(song, fromSelection, toSelection, copyMarkers);
            }
        });
        toSpinner.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGMeasureCopyDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                int fromSelection;
                int toSelection = toSpinner.getValue();
                if (toSelection < (fromSelection = fromSpinner.getValue())) {
                    toSpinner.setValue(fromSelection);
                    toSelection = fromSelection;
                } else if (toSelection > maxSelection) {
                    toSpinner.setValue(maxSelection);
                    toSelection = maxSelection;
                }
                this.this$0.updateCopyMarkers(song, fromSelection, toSelection, copyMarkers);
            }
        });
        this.updateCopyMarkers(song, fromSpinner.getValue(), toSpinner.getValue(), copyMarkers);
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGMeasureCopyDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                if (allTracksFinal != null) {
                    initCopyAllTracks = allTracksFinal.isSelected();
                }
                initCopyMarkers = copyMarkers.isSelected();
                this.this$0.processAction(context.getContext(), fromSpinner.getValue(), toSpinner.getValue(), allTracksFinal != null ? allTracksFinal.isSelected() : false, copyMarkers.isSelected());
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGMeasureCopyDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog(dialog, 5);
    }

    public void processAction(TGContext context, Integer measure1, Integer measure2, Boolean copyAllTracks, Boolean copyMarkers) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.measure.copy");
        tgActionProcessor.setAttribute("measureNumber1", (Object)measure1);
        tgActionProcessor.setAttribute("measureNumber2", (Object)measure2);
        tgActionProcessor.setAttribute("copyAllTracks", (Object)copyAllTracks);
        tgActionProcessor.setAttribute("copyMarkers", (Object)copyMarkers);
        tgActionProcessor.process();
    }

    private void updateCopyMarkers(TGSong song, int from, int to, UICheckBox copyMarkers) {
        boolean atLeastOneMarker = false;
        Iterator headers = song.getMeasureHeaders();
        while (headers.hasNext() && !atLeastOneMarker) {
            TGMeasureHeader header = (TGMeasureHeader)headers.next();
            int measureNb = header.getNumber();
            atLeastOneMarker = measureNb >= from && measureNb <= to && header.getMarker() != null;
        }
        copyMarkers.setEnabled(atLeastOneMarker);
        if (!atLeastOneMarker) {
            copyMarkers.setSelected(false);
        }
    }
}

