/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.keysignature;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.controller.TGViewContext;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UICheckBox;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIDropDownSelect;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UISelectItem;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGBeatRange;
import app.tuxguitar.util.TGContext;

public class TGKeySignatureDialog {
    public void show(final TGViewContext context) {
        final TGTrack track = (TGTrack)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
        final TGMeasure measure = (TGMeasure)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE);
        final TGBeatRange beatRange = (TGBeatRange)context.getAttribute("beat-range");
        Boolean isSelectionActive = (Boolean)context.getAttribute("selection-is-active");
        UIFactory uiFactory = TGApplication.getInstance(context.getContext()).getFactory();
        UIWindow uiParent = (UIWindow)context.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty("composition.keysignature"));
        UITableLayout keySignatureLayout = new UITableLayout();
        UILegendPanel keySignature = uiFactory.createLegendPanel((UIContainer)dialog);
        keySignature.setLayout((UILayout)keySignatureLayout);
        keySignature.setText(TuxGuitar.getProperty("composition.keysignature"));
        dialogLayout.set((UIControl)keySignature, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel keySignatureLabel = uiFactory.createLabel((UIContainer)keySignature);
        keySignatureLabel.setText(TuxGuitar.getProperty("composition.keysignature") + ":");
        keySignatureLayout.set((UIControl)keySignatureLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UIDropDownSelect keySignatures = uiFactory.createDropDownSelect((UIContainer)keySignature);
        keySignatures.addItem(new UISelectItem(TuxGuitar.getProperty("composition.keysignature.natural"), (Object)0));
        keySignatures.addItem(new UISelectItem(TuxGuitar.getProperty("composition.keysignature.sharp-1"), (Object)1));
        keySignatures.addItem(new UISelectItem(TuxGuitar.getProperty("composition.keysignature.sharp-2"), (Object)2));
        keySignatures.addItem(new UISelectItem(TuxGuitar.getProperty("composition.keysignature.sharp-3"), (Object)3));
        keySignatures.addItem(new UISelectItem(TuxGuitar.getProperty("composition.keysignature.sharp-4"), (Object)4));
        keySignatures.addItem(new UISelectItem(TuxGuitar.getProperty("composition.keysignature.sharp-5"), (Object)5));
        keySignatures.addItem(new UISelectItem(TuxGuitar.getProperty("composition.keysignature.sharp-6"), (Object)6));
        keySignatures.addItem(new UISelectItem(TuxGuitar.getProperty("composition.keysignature.sharp-7"), (Object)7));
        keySignatures.addItem(new UISelectItem(TuxGuitar.getProperty("composition.keysignature.flat-1"), (Object)8));
        keySignatures.addItem(new UISelectItem(TuxGuitar.getProperty("composition.keysignature.flat-2"), (Object)9));
        keySignatures.addItem(new UISelectItem(TuxGuitar.getProperty("composition.keysignature.flat-3"), (Object)10));
        keySignatures.addItem(new UISelectItem(TuxGuitar.getProperty("composition.keysignature.flat-4"), (Object)11));
        keySignatures.addItem(new UISelectItem(TuxGuitar.getProperty("composition.keysignature.flat-5"), (Object)12));
        keySignatures.addItem(new UISelectItem(TuxGuitar.getProperty("composition.keysignature.flat-6"), (Object)13));
        keySignatures.addItem(new UISelectItem(TuxGuitar.getProperty("composition.keysignature.flat-7"), (Object)14));
        keySignatures.setSelectedValue((Object)measure.getKeySignature());
        keySignatureLayout.set((UIControl)keySignatures, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(150.0f), null, null);
        UITableLayout checkLayout = new UITableLayout();
        UILegendPanel check = uiFactory.createLegendPanel((UIContainer)dialog);
        check.setLayout((UILayout)checkLayout);
        check.setText(TuxGuitar.getProperty("options"));
        dialogLayout.set((UIControl)check, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UICheckBox applyToSelection = uiFactory.createCheckBox((UIContainer)check);
        applyToSelection.setText(TuxGuitar.getProperty("composition.keysignature.apply-to-selection"));
        checkLayout.set((UIControl)applyToSelection, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UICheckBox toEnd = uiFactory.createCheckBox((UIContainer)check);
        toEnd.setText(TuxGuitar.getProperty("composition.keysignature.to-the-end"));
        checkLayout.set((UIControl)toEnd, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        if (isSelectionActive.booleanValue() && beatRange != null && !beatRange.isEmpty()) {
            applyToSelection.setEnabled(true);
            applyToSelection.setSelected(true);
            toEnd.setSelected(false);
        } else {
            applyToSelection.setEnabled(false);
            applyToSelection.setSelected(false);
            toEnd.setSelected(true);
        }
        toEnd.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGKeySignatureDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                applyToSelection.setSelected(false);
            }
        });
        applyToSelection.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGKeySignatureDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                toEnd.setSelected(false);
            }
        });
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGKeySignatureDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                this.this$0.changeKeySignature(context.getContext(), track, measure, (Integer)keySignatures.getSelectedValue(), beatRange, applyToSelection.isSelected(), toEnd.isSelected());
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGKeySignatureDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog(dialog, 5);
    }

    public void changeKeySignature(TGContext context, TGTrack track, TGMeasure measure, Integer value, TGBeatRange beatRange, Boolean applyToSelection, Boolean applyToEnd) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.composition.change-key-signature");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)track);
        tgActionProcessor.setAttribute("keySignature", (Object)value);
        tgActionProcessor.setAttribute("beat-range", (Object)beatRange);
        tgActionProcessor.setAttribute("changeKeySignature-applyToSelection", (Object)applyToSelection);
        if (applyToSelection.booleanValue() && beatRange != null && !beatRange.isEmpty()) {
            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, beatRange.getMeasures().get(0));
            tgActionProcessor.setAttribute("applyToEnd", (Object)Boolean.TRUE);
        } else {
            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)measure);
            tgActionProcessor.setAttribute("applyToEnd", (Object)applyToEnd);
        }
        tgActionProcessor.processOnNewThread();
    }
}

