/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.keybindings;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.system.keybindings.KeyBindingAction;
import app.tuxguitar.app.system.keybindings.KeyBindingActionDefaults;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.controller.TGViewContext;
import app.tuxguitar.app.view.dialog.keybindings.TGKeyBindingSelector;
import app.tuxguitar.app.view.dialog.keybindings.TGKeyBindingSelectorHandler;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UIDisposeEvent;
import app.tuxguitar.ui.event.UIDisposeListener;
import app.tuxguitar.ui.event.UIModifyEvent;
import app.tuxguitar.ui.event.UIModifyListener;
import app.tuxguitar.ui.event.UIMouseDoubleClickListener;
import app.tuxguitar.ui.event.UIMouseEvent;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.resource.UIKeyCombination;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UITable;
import app.tuxguitar.ui.widget.UITableItem;
import app.tuxguitar.ui.widget.UITextField;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGKeyBindFormatter;
import java.util.ArrayList;
import java.util.List;

public class TGKeyBindingEditor {
    private TGViewContext context;
    private UITextField filterText;
    private UIWindow dialog;
    private UITable<KeyBindingAction> table;
    private List<KeyBindingAction> kbActions;

    public TGKeyBindingEditor(TGViewContext context) {
        this.context = context;
        this.kbActions = new ArrayList<KeyBindingAction>();
    }

    public void show() {
        UIFactory uiFactory = TGApplication.getInstance(this.context.getContext()).getFactory();
        UIWindow uiParent = (UIWindow)this.context.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = uiFactory.createWindow(uiParent, true, false);
        this.dialog.setLayout((UILayout)dialogLayout);
        this.dialog.setText(TuxGuitar.getProperty("key-bindings-editor"));
        this.filterText = uiFactory.createTextField((UIContainer)this.dialog);
        this.filterText.addModifyListener(new UIModifyListener(){

            public void onModify(UIModifyEvent event) {
                TGKeyBindingEditor.this.updateTableItems();
            }
        });
        dialogLayout.set((UIControl)this.filterText, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.table = uiFactory.createTable((UIContainer)this.dialog, true);
        this.table.setColumns(2);
        this.table.setColumnName(0, TuxGuitar.getProperty("key-bindings-editor-action-column"));
        this.table.setColumnName(1, TuxGuitar.getProperty("key-bindings-editor-shortcut-column"));
        this.table.addMouseDoubleClickListener(new UIMouseDoubleClickListener(){

            public void onMouseDoubleClick(UIMouseEvent event) {
                final KeyBindingAction kbAction = (KeyBindingAction)TGKeyBindingEditor.this.table.getSelectedValue();
                if (kbAction != null) {
                    TGKeyBindingSelector keyBindingSelector = new TGKeyBindingSelector(TGKeyBindingEditor.this, kbAction, new TGKeyBindingSelectorHandler(){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void handleSelection(UIKeyCombination kb) {
                            this.this$1.TGKeyBindingEditor.this.removeKeyBindingAction(kb);
                            kbAction.setCombination(kb);
                            this.this$1.TGKeyBindingEditor.this.updateTableItems();
                        }
                    });
                    keyBindingSelector.select(TGKeyBindingEditor.this.dialog);
                }
            }
        });
        dialogLayout.set(this.table, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        dialogLayout.set(this.table, "maximum_packed_width", (Object)Float.valueOf(500.0f));
        dialogLayout.set(this.table, "packed_height", (Object)Float.valueOf(250.0f));
        this.loadCurrentKeyBindingActions();
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)this.dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton defaults = uiFactory.createButton((UIContainer)buttons);
        defaults.setText(TuxGuitar.getProperty("defaults"));
        defaults.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGKeyBindingEditor.this.loadDefaultKeyBindingActions();
            }
        });
        buttonsLayout.set((UIControl)defaults, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton close = uiFactory.createButton((UIContainer)buttons);
        close.setText(TuxGuitar.getProperty("close"));
        close.setDefaultButton();
        close.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGKeyBindingEditor.this.dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)close, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)close, "margin_right", (Object)Float.valueOf(0.0f));
        this.dialog.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TGKeyBindingEditor.this.save();
            }
        });
        TGDialogUtil.openDialog(this.dialog, 5);
    }

    public void createKeyBindingActions(List<KeyBindingAction> keyBindingActions) {
        this.kbActions.clear();
        List<String> actionIds = TuxGuitar.getInstance().getActionAdapterManager().getKeyBindingActionIds().getActionIds();
        for (String actionId : actionIds) {
            this.kbActions.add(new KeyBindingAction(actionId, this.findKeyBinding(keyBindingActions, actionId)));
        }
    }

    public UIKeyCombination findKeyBinding(List<KeyBindingAction> keyBindingActions, String actionId) {
        for (KeyBindingAction keyBindingAction : keyBindingActions) {
            if (!keyBindingAction.getAction().equals(actionId)) continue;
            return (UIKeyCombination)keyBindingAction.getCombination().clone();
        }
        return null;
    }

    public void loadCurrentKeyBindingActions() {
        this.createKeyBindingActions(TuxGuitar.getInstance().getKeyBindingManager().getKeyBindingActions());
        this.updateTableItems();
    }

    public void loadDefaultKeyBindingActions() {
        this.createKeyBindingActions(KeyBindingActionDefaults.getDefaultKeyBindings(this.getContext().getContext()));
        this.updateTableItems();
    }

    public void updateTableItems() {
        KeyBindingAction selection = (KeyBindingAction)this.table.getSelectedValue();
        this.table.removeItems();
        TGKeyBindFormatter formatter = TGKeyBindFormatter.getInstance();
        for (KeyBindingAction kbAction : this.kbActions) {
            UITableItem item = new UITableItem((Object)kbAction);
            item.setText(0, TuxGuitar.getProperty(kbAction.getAction()));
            item.setText(1, kbAction.getCombination() != null ? formatter.format(kbAction.getCombination().getKeyStrings()) : "");
            if (!item.getText(0).toLowerCase().contains(this.filterText.getText().toLowerCase())) continue;
            this.table.addItem(item);
        }
        this.table.setSelectedValue((Object)selection);
    }

    public KeyBindingAction findKeyBindingAction(UIKeyCombination kb) {
        if (kb != null) {
            for (KeyBindingAction kbAction : this.kbActions) {
                if (!kb.equals((Object)kbAction.getCombination())) continue;
                return kbAction;
            }
        }
        return null;
    }

    public void removeKeyBindingAction(UIKeyCombination kb) {
        KeyBindingAction kbAction = this.findKeyBindingAction(kb);
        if (kbAction != null) {
            kbAction.setCombination(null);
        }
    }

    public boolean exists(UIKeyCombination kb) {
        KeyBindingAction kbAction = this.findKeyBindingAction(kb);
        return kbAction != null;
    }

    public void save() {
        ArrayList<KeyBindingAction> list = new ArrayList<KeyBindingAction>();
        for (KeyBindingAction kbAction : this.kbActions) {
            if (kbAction.getAction() == null || kbAction.getCombination() == null) continue;
            list.add(kbAction);
        }
        TuxGuitar.getInstance().getKeyBindingManager().reset(list);
        TuxGuitar.getInstance().getKeyBindingManager().saveKeyBindings();
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context.getContext(), "action.system.reload-language");
        tgActionProcessor.setAttribute("force", (Object)true);
        tgActionProcessor.process();
    }

    public TGViewContext getContext() {
        return this.context;
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }
}

