/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.fretboard;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.editor.TGExternalBeatViewerManager;
import app.tuxguitar.app.view.dialog.fretboard.TGFretBoard;
import app.tuxguitar.app.view.main.TGWindow;
import app.tuxguitar.editor.TGEditorManager;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGSynchronizer;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;

public class TGFretBoardEditor
implements TGEventListener {
    private TGContext context;
    private TGFretBoard fretBoard;
    private boolean visible;

    public TGFretBoardEditor(TGContext context) {
        this.context = context;
        this.appendListeners();
    }

    public void appendListeners() {
        TuxGuitar.getInstance().getSkinManager().addLoader(this);
        TuxGuitar.getInstance().getLanguageManager().addLoader(this);
        TuxGuitar.getInstance().getScaleManager().addListener(this);
    }

    public TGFretBoard getFretBoard() {
        return this.fretBoard;
    }

    public void createFretBoard(UIPanel parent, boolean visible) {
        this.fretBoard = new TGFretBoard(this.context, (UIContainer)parent);
        this.fretBoard.setVisible(visible);
        UITableLayout uiLayout = (UITableLayout)parent.getLayout();
        uiLayout.set((UIControl)this.fretBoard.getControl(), Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        if (visible) {
            this.showFretBoard();
        }
    }

    public void hideFretBoard() {
        this.visible = false;
        this.getFretBoard().setVisible(this.visible);
        TGEditorManager.getInstance((TGContext)this.context).removeRedrawListener((TGEventListener)this);
        TGExternalBeatViewerManager.getInstance(this.context).removeBeatViewerListener(this);
        TGWindow tgWindow = TGWindow.getInstance(this.context);
        tgWindow.getWindow().layout();
    }

    public void showFretBoard() {
        this.visible = true;
        this.getFretBoard().setVisible(this.visible);
        this.getFretBoard().computePackedSize();
        TGEditorManager.getInstance((TGContext)this.context).addRedrawListener((TGEventListener)this);
        TGExternalBeatViewerManager.getInstance(this.context).addBeatViewerListener(this);
        TGWindow tgWindow = TGWindow.getInstance(this.context);
        tgWindow.getWindow().layout();
    }

    public void dispose() {
        if (this.getFretBoard() != null && !this.getFretBoard().isDisposed()) {
            this.getFretBoard().dispose();
        }
    }

    public void redraw() {
        if (this.getFretBoard() != null && !this.getFretBoard().isDisposed()) {
            this.getFretBoard().redraw();
        }
    }

    public void redrawPlayingMode() {
        if (this.getFretBoard() != null && !this.getFretBoard().isDisposed() && !TuxGuitar.getInstance().isLocked()) {
            this.getFretBoard().redrawPlayingMode();
        }
    }

    public boolean isVisible() {
        return this.getFretBoard() != null && !this.getFretBoard().isDisposed() && this.visible;
    }

    public void loadProperties() {
        if (this.getFretBoard() != null && !this.getFretBoard().isDisposed()) {
            this.getFretBoard().loadProperties();
        }
    }

    public void loadIcons() {
        if (this.getFretBoard() != null && !this.getFretBoard().isDisposed()) {
            this.getFretBoard().loadIcons();
        }
    }

    public void loadScale() {
        if (this.getFretBoard() != null) {
            this.getFretBoard().loadScale();
        }
    }

    public void showExternalBeat(TGBeat beat) {
        if (this.getFretBoard() != null && !this.getFretBoard().isDisposed()) {
            this.getFretBoard().setExternalBeat(beat);
        }
    }

    public void hideExternalBeat() {
        if (this.getFretBoard() != null && !this.getFretBoard().isDisposed()) {
            this.getFretBoard().setExternalBeat(null);
        }
    }

    public void processRedrawEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("redrawMode");
        if (type == 1) {
            this.redraw();
        } else if (type == 3) {
            this.redrawPlayingMode();
        }
    }

    public void processExternalBeatEvent(TGEvent event) {
        if ("show".equals(event.getAttribute("action"))) {
            this.showExternalBeat((TGBeat)event.getAttribute("beat"));
        } else if ("hide".equals(event.getAttribute("action"))) {
            this.hideExternalBeat();
        }
    }

    public void processEvent(final TGEvent event) {
        TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){
            final /* synthetic */ TGFretBoardEditor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if ("ui-skin".equals(event.getEventType())) {
                    this.this$0.loadIcons();
                } else if ("language".equals(event.getEventType())) {
                    this.this$0.loadProperties();
                } else if ("ui-redraw".equals(event.getEventType())) {
                    this.this$0.processRedrawEvent(event);
                } else if ("ui-external-beat-viewer".equals(event.getEventType())) {
                    this.this$0.processExternalBeatEvent(event);
                } else if ("ui-scale-changed".equals(event.getEventType())) {
                    this.this$0.loadScale();
                }
            }
        });
    }

    public static TGFretBoardEditor getInstance(TGContext context) {
        return (TGFretBoardEditor)TGSingletonUtil.getInstance((TGContext)context, (String)TGFretBoardEditor.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGFretBoardEditor>(){

            public TGFretBoardEditor createInstance(TGContext context) {
                return new TGFretBoardEditor(context);
            }
        });
    }
}

