/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.chord.xml;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.song.models.TGChord;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TGChordXMLReader {
    public static List<TGChord> getChords(String fileName) {
        ArrayList<TGChord> chords = new ArrayList<TGChord>();
        try {
            File file = new File(fileName);
            if (file.exists()) {
                Document doc = TGChordXMLReader.getDocument(file);
                TGChordXMLReader.loadChords(doc.getFirstChild(), chords);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return chords;
    }

    private static Document getDocument(File file) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setXIncludeAware(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(file);
        }
        catch (SAXException sxe) {
            sxe.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return document;
    }

    private static void loadChords(Node chordsNode, List<TGChord> chords) {
        try {
            NodeList chordList = chordsNode.getChildNodes();
            for (int i = 0; i < chordList.getLength(); ++i) {
                Node chordItem = chordList.item(i);
                if (!chordItem.getNodeName().equals("chord")) continue;
                NamedNodeMap chordAttributes = chordItem.getAttributes();
                String name = chordAttributes.getNamedItem("name").getNodeValue();
                String strings = chordAttributes.getNamedItem("strings").getNodeValue();
                String firstFret = chordAttributes.getNamedItem("first-fret").getNodeValue();
                TGChord chord = TuxGuitar.getInstance().getSongManager().getFactory().newChord(Integer.parseInt(strings));
                chord.setName(name);
                chord.setFirstFret(Integer.parseInt(firstFret));
                NodeList stringList = chordItem.getChildNodes();
                for (int j = 0; j < stringList.getLength(); ++j) {
                    Node stringItem = stringList.item(j);
                    if (!stringItem.getNodeName().equals("string")) continue;
                    NamedNodeMap stringAttributes = stringItem.getAttributes();
                    String number = stringAttributes.getNamedItem("number").getNodeValue();
                    String fret = stringAttributes.getNamedItem("fret").getNodeValue();
                    chord.addFretValue(Integer.parseInt(number), Integer.parseInt(fret));
                }
                chords.add(chord);
            }
        }
        catch (Exception e) {
            chords.clear();
            e.printStackTrace();
        }
    }
}

