/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.browser.main;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.tools.browser.TGBrowserCollection;
import app.tuxguitar.app.tools.browser.TGBrowserManager;
import app.tuxguitar.app.tools.browser.base.TGBrowserFactory;
import app.tuxguitar.app.view.dialog.browser.main.TGBrowserBar;
import app.tuxguitar.app.view.dialog.browser.main.TGBrowserDialog;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.menu.UIMenuActionItem;
import app.tuxguitar.ui.menu.UIMenuBar;
import app.tuxguitar.ui.menu.UIMenuItem;
import app.tuxguitar.ui.menu.UIMenuSubMenuItem;
import app.tuxguitar.ui.widget.UIWindow;
import java.util.Iterator;
import java.util.List;

public class TGBrowserMenuBar
extends TGBrowserBar {
    private UIMenuBar menu;
    private UIMenuSubMenuItem menuFileItem;
    private UIMenuSubMenuItem menuCollectionItem;
    private UIMenuSubMenuItem menuGoItem;
    private UIMenuActionItem open;
    private UIMenuActionItem exit;
    private UIMenuSubMenuItem newItem;
    private UIMenuSubMenuItem openItem;
    private UIMenuSubMenuItem removeItem;
    private UIMenuActionItem close;
    private UIMenuActionItem root;
    private UIMenuActionItem back;
    private UIMenuActionItem refresh;

    public TGBrowserMenuBar(TGBrowserDialog browser) {
        super(browser);
    }

    public void createMenuBar(UIWindow window) {
        this.menu = this.getBrowser().getUIFactory().createMenuBar(window);
        this.menuFileItem = this.menu.createSubMenuItem();
        this.open = this.menuFileItem.getMenu().createActionItem();
        this.open.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("open.png"));
        this.open.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGBrowserMenuBar.this.getBrowser().openElement();
            }
        });
        this.menuFileItem.getMenu().createSeparator();
        this.exit = this.menuFileItem.getMenu().createActionItem();
        this.exit.setImage(TuxGuitar.getInstance().getIconManager().getFileExit());
        this.exit.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGBrowserMenuBar.this.getBrowser().dispose();
            }
        });
        this.menuCollectionItem = this.menu.createSubMenuItem();
        this.newItem = this.menuCollectionItem.getMenu().createSubMenuItem();
        this.newItem.setImage(TuxGuitar.getInstance().getIconManager().getBrowserNew());
        this.updateTypes();
        this.openItem = this.menuCollectionItem.getMenu().createSubMenuItem();
        this.openItem.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("open.png"));
        this.removeItem = this.menuCollectionItem.getMenu().createSubMenuItem();
        this.removeItem.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("list_remove.png"));
        this.menuCollectionItem.getMenu().createSeparator();
        this.close = this.menuCollectionItem.getMenu().createActionItem();
        this.close.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("close.png"));
        this.close.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGBrowserMenuBar.this.closeCollection();
            }
        });
        this.menuGoItem = this.menu.createSubMenuItem();
        this.root = this.menuGoItem.getMenu().createActionItem();
        this.root.setImage(TuxGuitar.getInstance().getIconManager().getBrowserRoot());
        this.root.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGBrowserMenuBar.this.getBrowser().cdRoot();
            }
        });
        this.back = this.menuGoItem.getMenu().createActionItem();
        this.back.setImage(TuxGuitar.getInstance().getIconManager().getBrowserBack());
        this.back.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGBrowserMenuBar.this.getBrowser().cdUp();
            }
        });
        this.refresh = this.menuGoItem.getMenu().createActionItem();
        this.refresh.setImage(TuxGuitar.getInstance().getIconManager().getBrowserRefresh());
        this.refresh.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGBrowserMenuBar.this.getBrowser().listElements();
            }
        });
    }

    @Override
    public void updateItems() {
        this.open.setEnabled(!this.getBrowser().getConnection().isLocked() && this.getBrowser().getConnection().isOpen());
        this.root.setEnabled(!this.getBrowser().getConnection().isLocked() && this.getBrowser().getConnection().isOpen());
        this.back.setEnabled(!this.getBrowser().getConnection().isLocked() && this.getBrowser().getConnection().isOpen());
        this.refresh.setEnabled(!this.getBrowser().getConnection().isLocked() && this.getBrowser().getConnection().isOpen());
        this.newItem.setEnabled(!this.getBrowser().getConnection().isLocked());
        this.openItem.setEnabled(!this.getBrowser().getConnection().isLocked());
        this.removeItem.setEnabled(!this.getBrowser().getConnection().isLocked());
        this.close.setEnabled(!this.getBrowser().getConnection().isLocked());
    }

    @Override
    public void loadProperties() {
        this.menuFileItem.setText(TuxGuitar.getProperty("browser.menu.file"));
        this.menuCollectionItem.setText(TuxGuitar.getProperty("browser.menu.collection"));
        this.menuGoItem.setText(TuxGuitar.getProperty("browser.menu.go"));
        this.open.setText(TuxGuitar.getProperty("browser.open"));
        this.exit.setText(TuxGuitar.getProperty("browser.exit"));
        this.newItem.setText(TuxGuitar.getProperty("browser.collection.new"));
        this.openItem.setText(TuxGuitar.getProperty("browser.collection.open"));
        this.removeItem.setText(TuxGuitar.getProperty("browser.collection.remove"));
        this.close.setText(TuxGuitar.getProperty("browser.collection.close"));
        this.root.setText(TuxGuitar.getProperty("browser.go-root"));
        this.back.setText(TuxGuitar.getProperty("browser.go-back"));
        this.refresh.setText(TuxGuitar.getProperty("browser.refresh"));
    }

    @Override
    public void updateCollections(TGBrowserCollection selection) {
        List openItems = this.openItem.getMenu().getItems();
        for (Object uiMenuItem : openItems) {
            uiMenuItem.dispose();
        }
        List removeItems = this.removeItem.getMenu().getItems();
        for (UIMenuItem uiMenuItem : removeItems) {
            uiMenuItem.dispose();
        }
        Iterator<TGBrowserCollection> it = TGBrowserManager.getInstance(this.getBrowser().getContext()).getCollections();
        while (it.hasNext()) {
            final TGBrowserCollection collection = it.next();
            if (collection.getData() == null) continue;
            UIMenuActionItem openItem = this.openItem.getMenu().createActionItem();
            openItem.setText(collection.getData().getTitle());
            openItem.setImage(TuxGuitar.getInstance().getIconManager().getBrowserCollection());
            openItem.addSelectionListener(new UISelectionListener(){
                final /* synthetic */ TGBrowserMenuBar this$0;
                {
                    this.this$0 = this$0;
                }

                public void onSelect(UISelectionEvent event) {
                    this.this$0.openCollection(collection);
                }
            });
            UIMenuActionItem removeItem = this.removeItem.getMenu().createActionItem();
            removeItem.setText(collection.getData().getTitle());
            removeItem.setImage(TuxGuitar.getInstance().getIconManager().getBrowserCollection());
            removeItem.addSelectionListener(new UISelectionListener(){
                final /* synthetic */ TGBrowserMenuBar this$0;
                {
                    this.this$0 = this$0;
                }

                public void onSelect(UISelectionEvent event) {
                    this.this$0.removeCollection(collection);
                }
            });
        }
    }

    public void updateTypes() {
        List newItems = this.newItem.getMenu().getItems();
        for (UIMenuItem uiMenuItem : newItems) {
            uiMenuItem.dispose();
        }
        Iterator<TGBrowserFactory> bookTypes = TGBrowserManager.getInstance(this.getBrowser().getContext()).getFactories();
        while (bookTypes.hasNext()) {
            final TGBrowserFactory bookType = bookTypes.next();
            UIMenuActionItem item = this.newItem.getMenu().createActionItem();
            item.setText(bookType.getName());
            item.setImage(bookType.getIcon());
            item.addSelectionListener(new UISelectionListener(){
                final /* synthetic */ TGBrowserMenuBar this$0;
                {
                    this.this$0 = this$0;
                }

                public void onSelect(UISelectionEvent event) {
                    this.this$0.newCollection(bookType.getType());
                }
            });
        }
    }

    public void reload(UIWindow window) {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.createMenuBar(window);
        this.loadProperties();
        this.updateItems();
    }
}

