/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.component.table;

import app.tuxguitar.app.view.component.table.TGTable;
import app.tuxguitar.app.view.component.table.TGTableCanvasPainter;
import app.tuxguitar.app.view.component.table.TGTableRowButtonsCell;
import app.tuxguitar.app.view.component.table.TGTableRowLayout;
import app.tuxguitar.app.view.component.table.TGTableRowTextCell;
import app.tuxguitar.app.view.util.TGBufferedPainterListenerLocked;
import app.tuxguitar.app.view.util.TGBufferedPainterLocked;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UIMouseDoubleClickListener;
import app.tuxguitar.ui.event.UIMouseDownListener;
import app.tuxguitar.ui.event.UIMouseEvent;
import app.tuxguitar.ui.event.UIMouseUpListener;
import app.tuxguitar.ui.event.UIPaintListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.resource.UIColor;
import app.tuxguitar.ui.resource.UIPainter;
import app.tuxguitar.ui.widget.UICanvas;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIPanel;

public class TGTableRow {
    private TGTable table;
    private UIPanel row;
    private TGTableRowTextCell number;
    private TGTableRowButtonsCell soloMute;
    private TGTableRowTextCell name;
    private TGTableRowTextCell instrument;
    private UICanvas painter;
    private UIMouseUpListener mouseUpListenerLabel;
    private UIMouseDownListener mouseDownListenerLabel;
    private UIMouseDoubleClickListener mouseDoubleClickListenerLabel;
    private UIMouseUpListener mouseUpListenerCanvas;
    private UIMouseDownListener mouseDownListenerCanvas;
    private UIMouseDoubleClickListener mouseDoubleClickListenerCanvas;
    private TGTableCanvasPainter paintListenerCanvas;

    public TGTableRow(TGTable table) {
        this.table = table;
        this.init();
    }

    public void init() {
        UIFactory uiFactory = this.table.getUIFactory();
        MouseListenerLabel mouseListenerLabel = new MouseListenerLabel();
        MouseListenerCanvas mouseListenerCanvas = new MouseListenerCanvas();
        this.row = uiFactory.createPanel((UIContainer)this.table.getRowControl(), false);
        this.row.setLayout((UILayout)new TGTableRowLayout(this));
        this.number = new TGTableRowTextCell(this);
        this.number.addMouseDownListener(mouseListenerLabel);
        this.number.addMouseUpListener(mouseListenerLabel);
        this.number.addMouseDoubleClickListener(mouseListenerLabel);
        this.soloMute = new TGTableRowButtonsCell(this);
        this.soloMute.getLayout().set("margin_left", (Object)Float.valueOf(0.0f));
        this.soloMute.getLayout().set("margin_right", (Object)Float.valueOf(0.0f));
        this.name = new TGTableRowTextCell(this);
        this.name.addMouseDownListener(mouseListenerLabel);
        this.name.addMouseUpListener(mouseListenerLabel);
        this.name.addMouseDoubleClickListener(mouseListenerLabel);
        this.instrument = new TGTableRowTextCell(this);
        this.instrument.addMouseDownListener(mouseListenerLabel);
        this.instrument.addMouseUpListener(mouseListenerLabel);
        this.instrument.addMouseDoubleClickListener(mouseListenerLabel);
        this.painter = uiFactory.createCanvas((UIContainer)this.row, false);
        this.painter.addMouseDownListener((UIMouseDownListener)mouseListenerCanvas);
        this.painter.addMouseUpListener((UIMouseUpListener)mouseListenerCanvas);
        this.painter.addMouseDoubleClickListener((UIMouseDoubleClickListener)mouseListenerCanvas);
        this.painter.addPaintListener((UIPaintListener)new TGBufferedPainterListenerLocked(this.table.getContext(), new TGTableRowPaintHandle()));
        this.table.appendListeners((UIControl)this.painter);
    }

    public void setBgColor(UIColor background) {
        this.number.setBgColor(background);
        this.soloMute.setBgColor(background);
        this.name.setBgColor(background);
        this.instrument.setBgColor(background);
    }

    public void setFgColor(UIColor foreground) {
        this.number.setFgColor(foreground);
        this.soloMute.setFgColor(foreground);
        this.name.setFgColor(foreground);
        this.instrument.setFgColor(foreground);
    }

    public void dispose() {
        this.row.dispose();
    }

    public TGTable getTable() {
        return this.table;
    }

    public UIPanel getControl() {
        return this.row;
    }

    public UICanvas getPainter() {
        return this.painter;
    }

    public TGTableRowTextCell getInstrument() {
        return this.instrument;
    }

    public TGTableRowTextCell getName() {
        return this.name;
    }

    public TGTableRowTextCell getNumber() {
        return this.number;
    }

    public TGTableRowButtonsCell getSoloMute() {
        return this.soloMute;
    }

    public UIMouseUpListener getMouseUpListenerLabel() {
        return this.mouseUpListenerLabel;
    }

    public void setMouseUpListenerLabel(UIMouseUpListener mouseUpListenerLabel) {
        this.mouseUpListenerLabel = mouseUpListenerLabel;
    }

    public UIMouseDownListener getMouseDownListenerLabel() {
        return this.mouseDownListenerLabel;
    }

    public void setMouseDownListenerLabel(UIMouseDownListener mouseDownListenerLabel) {
        this.mouseDownListenerLabel = mouseDownListenerLabel;
    }

    public UIMouseDoubleClickListener getMouseDoubleClickListenerLabel() {
        return this.mouseDoubleClickListenerLabel;
    }

    public void setMouseDoubleClickListenerLabel(UIMouseDoubleClickListener mouseDoubleClickListenerLabel) {
        this.mouseDoubleClickListenerLabel = mouseDoubleClickListenerLabel;
    }

    public UIMouseUpListener getMouseUpListenerCanvas() {
        return this.mouseUpListenerCanvas;
    }

    public void setMouseUpListenerCanvas(UIMouseUpListener mouseUpListenerCanvas) {
        this.mouseUpListenerCanvas = mouseUpListenerCanvas;
    }

    public UIMouseDownListener getMouseDownListenerCanvas() {
        return this.mouseDownListenerCanvas;
    }

    public void setMouseDownListenerCanvas(UIMouseDownListener mouseDownListenerCanvas) {
        this.mouseDownListenerCanvas = mouseDownListenerCanvas;
    }

    public UIMouseDoubleClickListener getMouseDoubleClickListenerCanvas() {
        return this.mouseDoubleClickListenerCanvas;
    }

    public void setMouseDoubleClickListenerCanvas(UIMouseDoubleClickListener mouseDoubleClickListenerCanvas) {
        this.mouseDoubleClickListenerCanvas = mouseDoubleClickListenerCanvas;
    }

    public TGTableCanvasPainter getPaintListenerCanvas() {
        return this.paintListenerCanvas;
    }

    public void setPaintListenerCanvas(TGTableCanvasPainter paintListenerCanvas) {
        this.paintListenerCanvas = paintListenerCanvas;
    }

    private class MouseListenerLabel
    implements UIMouseUpListener,
    UIMouseDownListener,
    UIMouseDoubleClickListener {
        public void onMouseDoubleClick(UIMouseEvent event) {
            if (TGTableRow.this.getMouseDoubleClickListenerLabel() != null) {
                TGTableRow.this.getMouseDoubleClickListenerLabel().onMouseDoubleClick(event);
            }
        }

        public void onMouseDown(UIMouseEvent event) {
            if (TGTableRow.this.getMouseDownListenerLabel() != null) {
                TGTableRow.this.getMouseDownListenerLabel().onMouseDown(event);
            }
        }

        public void onMouseUp(UIMouseEvent event) {
            if (TGTableRow.this.getMouseUpListenerLabel() != null) {
                TGTableRow.this.getMouseUpListenerLabel().onMouseUp(event);
            }
        }
    }

    private class MouseListenerCanvas
    implements UIMouseUpListener,
    UIMouseDownListener,
    UIMouseDoubleClickListener {
        public void onMouseDoubleClick(UIMouseEvent event) {
            if (TGTableRow.this.getMouseDoubleClickListenerCanvas() != null) {
                TGTableRow.this.getMouseDoubleClickListenerCanvas().onMouseDoubleClick(event);
            }
        }

        public void onMouseDown(UIMouseEvent event) {
            if (TGTableRow.this.getMouseDownListenerCanvas() != null) {
                TGTableRow.this.getMouseDownListenerCanvas().onMouseDown(event);
            }
        }

        public void onMouseUp(UIMouseEvent event) {
            if (TGTableRow.this.getMouseUpListenerCanvas() != null) {
                TGTableRow.this.getMouseUpListenerCanvas().onMouseUp(event);
            }
        }
    }

    private class TGTableRowPaintHandle
    implements TGBufferedPainterLocked.TGBufferedPainterHandle {
        @Override
        public void paintControl(UIPainter painter) {
            if (TGTableRow.this.getPaintListenerCanvas() != null) {
                TGTableRow.this.getPaintListenerCanvas().paintTrack(TGTableRow.this, painter);
            }
        }

        @Override
        public UICanvas getPaintableControl() {
            return TGTableRow.this.getPainter();
        }
    }
}

