/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.component.table;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.util.TGContinousControlSelectionListener;
import app.tuxguitar.app.util.TGContinuousControl;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGChannel;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UIScale;
import app.tuxguitar.ui.widget.UIScrollBarPanel;
import app.tuxguitar.util.TGContext;
import java.util.ArrayList;
import java.util.List;

public class TGTableMixer {
    private TGContext context;
    private UIPanel panel;
    private UITableLayout layout;
    private UIFactory uiFactory;
    private List<VolumeControl> volumeControls;

    public TGTableMixer(UIScrollBarPanel parent, UIFactory uiFactory, TGContext context) {
        this.uiFactory = uiFactory;
        this.context = context;
        this.panel = this.uiFactory.createPanel((UIContainer)parent, true);
        this.layout = new UITableLayout();
        this.panel.setLayout((UILayout)this.layout);
        this.volumeControls = new ArrayList<VolumeControl>();
    }

    public void update(TGSong song) {
        boolean listControlChanged;
        TGSongManager songManager = TuxGuitar.getInstance().getSongManager();
        ArrayList<TGChannel> newChannels = new ArrayList<TGChannel>();
        for (int nTrack = 0; nTrack < song.countTracks(); ++nTrack) {
            int channelId = song.getTrack(nTrack).getChannelId();
            TGChannel tGChannel = songManager.getChannel(song, channelId);
            if (newChannels.contains(tGChannel) || tGChannel == null) continue;
            newChannels.add(tGChannel);
        }
        boolean bl = listControlChanged = newChannels.size() != this.volumeControls.size();
        if (!listControlChanged) {
            for (int i = 0; i < this.volumeControls.size(); ++i) {
                if (((TGChannel)newChannels.get(i)).equals(this.volumeControls.get(i).getChannel())) continue;
                listControlChanged = true;
            }
        }
        if (listControlChanged) {
            for (UIControl uIControl : this.panel.getChildren()) {
                uIControl.dispose();
            }
            this.volumeControls.clear();
            int nRow = 1;
            for (TGChannel channel : newChannels) {
                VolumeControl volumeControl = new VolumeControl(channel, this.context, this.uiFactory, (UIContainer)this.panel);
                this.layout.set(volumeControl.getLabel(), Integer.valueOf(nRow), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), null, null, null);
                this.layout.set(volumeControl.getScale(), "maximum_packed_width", (Object)Float.valueOf(80.0f));
                this.layout.set(volumeControl.getScale(), Integer.valueOf(nRow), Integer.valueOf(2), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), null, null, null);
                ++nRow;
                this.volumeControls.add(volumeControl);
            }
            this.panel.layout();
        } else {
            for (VolumeControl volumeControl : this.volumeControls) {
                volumeControl.updateVolume();
            }
        }
    }

    public void updateInstrumentsNames() {
        for (VolumeControl control : this.volumeControls) {
            control.instrumentLabel.setText(control.getChannel().getName());
        }
    }

    private class VolumeControl
    implements TGContinuousControl {
        private UIScale volumeScale;
        private UILabel instrumentLabel;
        private TGChannel channel;
        private TGContext context;
        private TGContinousControlSelectionListener volumeListener;

        VolumeControl(TGChannel channel, TGContext context, UIFactory uiFactory, UIContainer parent) {
            this.channel = channel;
            this.context = context;
            this.instrumentLabel = uiFactory.createLabel(parent);
            this.instrumentLabel.setText(channel.getName());
            this.volumeScale = uiFactory.createHorizontalScale(parent);
            this.volumeScale.setMinimum(0);
            this.volumeScale.setMaximum(127);
            this.volumeScale.setValue((int)channel.getVolume());
            this.updateToolTipText();
            this.volumeScale.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    VolumeControl.this.updateToolTipText();
                    VolumeControl.this.volumeListener.onSelect(null);
                }
            });
            this.volumeListener = new TGContinousControlSelectionListener(this, 250);
        }

        private void updateToolTipText() {
            int percent = 100 * (this.volumeScale.getValue() - 0) / 127;
            this.volumeScale.setToolTipText(String.valueOf(percent) + "%");
        }

        TGChannel getChannel() {
            return this.channel;
        }

        UIControl getScale() {
            return this.volumeScale;
        }

        UIControl getLabel() {
            return this.instrumentLabel;
        }

        void updateVolume() {
            this.volumeScale.setValue((int)this.channel.getVolume());
        }

        @Override
        public void doActionWhenStable() {
            if (this.channel != null) {
                short newVolume = (short)this.volumeScale.getValue();
                TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.channel.update");
                tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)TuxGuitar.getInstance().getDocumentManager().getSong());
                tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_CHANNEL, (Object)this.channel);
                tgActionProcessor.setAttribute("bank", (Object)this.channel.getBank());
                tgActionProcessor.setAttribute("program", (Object)this.channel.getProgram());
                tgActionProcessor.setAttribute("volume", (Object)newVolume);
                tgActionProcessor.setAttribute("balance", (Object)this.channel.getBalance());
                tgActionProcessor.setAttribute("chorus", (Object)this.channel.getChorus());
                tgActionProcessor.setAttribute("reverb", (Object)this.channel.getReverb());
                tgActionProcessor.setAttribute("phaser", (Object)this.channel.getPhaser());
                tgActionProcessor.setAttribute("tremolo", (Object)this.channel.getTremolo());
                tgActionProcessor.setAttribute("name", (Object)this.channel.getName());
                tgActionProcessor.process();
            }
        }

        @Override
        public TGContext getContext() {
            return this.context;
        }
    }
}

