/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.component.table;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.view.component.table.TGTableRow;
import app.tuxguitar.app.view.component.table.TGTableViewer;
import app.tuxguitar.graphics.control.TGLayout;
import app.tuxguitar.graphics.control.TGMeasureImpl;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.ui.resource.UIColor;
import app.tuxguitar.ui.resource.UIPainter;
import app.tuxguitar.util.TGBeatRange;

public class TGTableCanvasPainter {
    private TGTableViewer viewer;
    private TGTrack track;
    private static final int SELECTION_ALPHA = 128;

    public TGTableCanvasPainter(TGTableViewer viewer, TGTrack track) {
        this.viewer = viewer;
        this.track = track;
    }

    protected void paintTrack(TGTableRow row, UIPainter painter) {
        int x = -this.viewer.getHScrollSelection();
        int y = 0;
        float size = this.viewer.getTable().getRowHeight();
        float width = row.getPainter().getBounds().getWidth();
        boolean playing = TuxGuitar.getInstance().getPlayer().isRunning();
        UIColor colorBackground = this.viewer.getColorModel().getColor(9);
        painter.setLineWidth(0.0f);
        painter.setBackground(colorBackground);
        painter.initPath(2);
        painter.setAntialias(false);
        painter.addRectangle(0.0f, (float)y, width, size);
        painter.closePath();
        UIColor trackColor = this.viewer.getUIFactory().createColor(this.track.getColor().getR(), this.track.getColor().getG(), this.track.getColor().getB());
        TGLayout layout = this.viewer.getEditor().getTablature().getViewLayout();
        TGBeatRange beatRange = this.viewer.getEditor().getTablature().getSelector().getBeatRange();
        int count = this.track.countMeasures();
        for (int j = 0; j < count; ++j) {
            UIColor cellBackgroundColor = trackColor;
            TGMeasureImpl measure = (TGMeasureImpl)this.track.getMeasure(j);
            if (this.isRestMeasure(measure)) {
                cellBackgroundColor = this.viewer.getColorModel().getColor(10);
            }
            painter.setBackground(cellBackgroundColor);
            painter.setForeground(cellBackgroundColor);
            painter.initPath(2);
            painter.setAntialias(false);
            painter.addRectangle((float)x, (float)y, size - 1.0f, size);
            painter.closePath();
            boolean hasCaret = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getMeasure().equals(measure);
            if (playing && measure.isPlaying(this.viewer.getEditor().getTablature().getViewLayout()) || !playing && hasCaret) {
                painter.setBackground(this.getCaretColor(cellBackgroundColor));
                painter.initPath(2);
                painter.setAntialias(false);
                painter.addRoundedRectangle((float)(x + 4), (float)(y + 4), size - 9.0f, size - 8.0f, 3.0f);
                painter.closePath();
                painter.setBackground(trackColor);
            }
            if (beatRange.containsMeasure((TGMeasure)measure)) {
                painter.setBackground(layout.getResources().getSelectionColor());
                painter.setAlpha(128);
                painter.initPath(2);
                painter.addRectangle((float)x + 1.5f, (float)y + 1.5f, size - 3.0f, size - 3.0f);
                painter.closePath();
                painter.setAlpha(255);
                painter.setBackground(trackColor);
            }
            x = (int)((float)x + size);
        }
        trackColor.dispose();
    }

    private UIColor getCaretColor(UIColor backgroundColor) {
        int brightness = backgroundColor.getRed() + backgroundColor.getGreen() + backgroundColor.getBlue();
        int index = brightness > 240 ? 1 : 11;
        return this.viewer.getColorModel().getColor(index);
    }

    private boolean isRestMeasure(TGMeasureImpl measure) {
        int beatCount = measure.countBeats();
        for (int i = 0; i < beatCount; ++i) {
            if (measure.getBeat(i).isRestBeat()) continue;
            return false;
        }
        return true;
    }
}

