/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.transport;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.transport.TGTransport;
import app.tuxguitar.editor.TGEditorManager;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.player.base.MidiPlayer;
import app.tuxguitar.thread.TGThreadLoop;
import app.tuxguitar.thread.TGThreadManager;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.error.TGErrorManager;

public class TGTransportListener
implements TGEventListener {
    private TGContext context;

    public TGTransportListener(TGContext context) {
        this.context = context;
    }

    public void startLoop() {
        TGThreadManager.getInstance((TGContext)this.context).loop(new TGThreadLoop(){

            public Long process() {
                return TGTransportListener.this.processLoop() ? 25L : BREAK;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processLoop() {
        try {
            TGEditorManager tgEditorManager = TGEditorManager.getInstance((TGContext)this.context);
            TGTransport tgTransport = TGTransport.getInstance(this.context);
            MidiPlayer midiPlayer = MidiPlayer.getInstance((TGContext)this.context);
            if (midiPlayer.isRunning()) {
                tgEditorManager.lock();
                try {
                    tgTransport.getCache().updatePlayMode();
                }
                finally {
                    tgEditorManager.unlock();
                }
                if (tgTransport.getCache().shouldRedraw()) {
                    tgEditorManager.redrawPlayingNewBeat();
                } else if (!tgEditorManager.isLocked()) {
                    tgEditorManager.redrawPlayingThread();
                }
                return true;
            }
            this.notifyStopped();
        }
        catch (Throwable throwable) {
            TGErrorManager.getInstance((TGContext)this.context).handleError(throwable);
        }
        return false;
    }

    public void notifyStarted() {
        TGEditorManager tgEditorManager = TGEditorManager.getInstance((TGContext)this.context);
        tgEditorManager.asyncRunLocked(new Runnable(){

            @Override
            public void run() {
                try {
                    TGTransport tgTransport = TGTransport.getInstance(TGTransportListener.this.context);
                    tgTransport.getCache().reset();
                    TuxGuitar.getInstance().updateCache(true);
                    TGTransportListener.this.startLoop();
                }
                catch (Throwable throwable) {
                    TGErrorManager.getInstance((TGContext)TGTransportListener.this.context).handleError(throwable);
                }
            }
        });
    }

    public void notifyStopped() {
        TGEditorManager tgEditorManager = TGEditorManager.getInstance((TGContext)this.context);
        tgEditorManager.asyncRunLocked(new Runnable(){

            @Override
            public void run() {
                try {
                    TGTransport tgTransport = TGTransport.getInstance(TGTransportListener.this.context);
                    tgTransport.gotoPlayerPosition();
                    tgTransport.getCache().reset();
                }
                catch (Throwable throwable) {
                    TGErrorManager.getInstance((TGContext)TGTransportListener.this.context).handleError(throwable);
                }
            }
        });
    }

    public void processEvent(TGEvent event) {
        if ("midi-player-notification".equals(event.getEventType())) {
            int type = (Integer)event.getAttribute("notificationType");
            if (type == 1) {
                this.notifyStarted();
            } else if (type == 2) {
                this.notifyStopped();
            }
        }
    }
}

