/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.tools.browser.filesystem;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.tools.browser.base.TGBrowserFactorySettingsHandler;
import app.tuxguitar.app.tools.browser.filesystem.TGBrowserSettingsModel;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.util.TGMessageDialogUtil;
import app.tuxguitar.app.view.dialog.browser.main.TGBrowserDialog;
import app.tuxguitar.app.view.main.TGWindow;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.chooser.UIDirectoryChooser;
import app.tuxguitar.ui.chooser.UIDirectoryChooserHandler;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UITextField;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;
import java.io.File;

public class TGBrowserDataDialog {
    private TGContext context;
    private TGBrowserFactorySettingsHandler handler;

    public TGBrowserDataDialog(TGContext context, TGBrowserFactorySettingsHandler handler) {
        this.context = context;
        this.handler = handler;
    }

    public void open() {
        TGBrowserDialog browser = TGBrowserDialog.getInstance(this.context);
        this.open(!browser.isDisposed() ? browser.getWindow() : TGWindow.getInstance(this.context).getWindow());
    }

    public void open(UIWindow parent) {
        final UIFactory uiFactory = TGApplication.getInstance(this.context).getFactory();
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(parent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty("browser.collection.fs.editor-title"));
        UITableLayout groupLayout = new UITableLayout();
        UILegendPanel group = uiFactory.createLegendPanel((UIContainer)dialog);
        group.setLayout((UILayout)groupLayout);
        group.setText(TuxGuitar.getProperty("browser.collection.fs.editor-tip"));
        dialogLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(420.0f), null, null);
        UILabel titleLabel = uiFactory.createLabel((UIContainer)group);
        titleLabel.setText(TuxGuitar.getProperty("browser.collection.fs.name") + ":");
        groupLayout.set((UIControl)titleLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UITextField titleValue = uiFactory.createTextField((UIContainer)group);
        groupLayout.set((UIControl)titleValue, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(2));
        UILabel pathLabel = uiFactory.createLabel((UIContainer)group);
        pathLabel.setText(TuxGuitar.getProperty("browser.collection.fs.path") + ":");
        groupLayout.set((UIControl)pathLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UITextField pathValue = uiFactory.createTextField((UIContainer)group);
        groupLayout.set((UIControl)pathValue, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UIButton pathChooser = uiFactory.createButton((UIContainer)group);
        pathChooser.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("open.png"));
        pathChooser.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGBrowserDataDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                String defaultPath = pathValue.getText();
                UIDirectoryChooser chooser = uiFactory.createDirectoryChooser(dialog);
                chooser.setDefaultPath(defaultPath != null ? new File(defaultPath) : null);
                chooser.choose(new UIDirectoryChooserHandler(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void onSelectDirectory(File file) {
                        if (file != null) {
                            pathValue.setText(file.getAbsolutePath());
                        }
                    }
                });
            }
        });
        groupLayout.set((UIControl)pathChooser, Integer.valueOf(2), Integer.valueOf(3), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGBrowserDataDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                String selectedTitle = titleValue.getText();
                String selectedPath = pathValue.getText();
                if (!this.this$0.isValidPath(selectedPath)) {
                    TGMessageDialogUtil.errorMessage(this.this$0.context, dialog, TuxGuitar.getProperty("browser.collection.fs.invalid-path"));
                    return;
                }
                if (this.this$0.isBlank(selectedTitle)) {
                    selectedTitle = selectedPath;
                }
                dialog.dispose();
                this.this$0.handler.onCreateSettings(new TGBrowserSettingsModel(selectedTitle, selectedPath).toBrowserSettings());
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGBrowserDataDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog(dialog, 5);
    }

    public boolean isBlank(String s) {
        return s == null || s.length() == 0;
    }

    public boolean isValidPath(String path) {
        if (!this.isBlank(path)) {
            File file = new File(path);
            return file.exists() && file.isDirectory();
        }
        return false;
    }
}

