/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.system.icons;

import app.tuxguitar.app.system.config.TGConfigManager;
import app.tuxguitar.app.system.icons.TGColorManager;
import app.tuxguitar.app.system.icons.TGIconManager;
import app.tuxguitar.app.system.icons.TGSkinEvent;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.event.TGEventManager;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.properties.TGProperties;
import app.tuxguitar.util.properties.TGPropertiesManager;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;

public class TGSkinManager {
    private TGContext context;
    private String currentSkin;

    private TGSkinManager(TGContext context) {
        this.context = context;
        this.loadSkin();
    }

    public void addLoader(TGEventListener listener) {
        TGEventManager.getInstance((TGContext)this.context).addListener("ui-skin", listener);
    }

    public void removeLoader(TGEventListener listener) {
        TGEventManager.getInstance((TGContext)this.context).removeListener("ui-skin", listener);
    }

    private void fireChanges() {
        TGEventManager.getInstance((TGContext)this.context).fireEvent((TGEvent)new TGSkinEvent());
    }

    public void loadSkin() {
        this.currentSkin = this.getCurrentSkin();
    }

    public void reloadSkin() {
        this.loadSkin();
        TGIconManager.getInstance(this.context).onSkinChange();
        TGColorManager.getInstance(this.context).onSkinChange();
        this.fireChanges();
    }

    public boolean shouldReload() {
        return this.currentSkin == null || !this.currentSkin.equals(this.getCurrentSkin());
    }

    public String getCurrentSkin() {
        String configuredSkin = TGConfigManager.getInstance(this.context).getStringValue("skin");
        TGProperties skinInfo = this.getSkinInfo(configuredSkin);
        if (skinInfo.getValue("name") != null) {
            return configuredSkin;
        }
        TGConfigManager.getInstance(this.context).setValue("skin", "Breeze");
        return "Breeze";
    }

    public TGProperties getCurrentSkinInfo() {
        return this.getSkinInfo(this.getCurrentSkin());
    }

    public TGProperties getSkinInfo(String skin) {
        TGPropertiesManager propertiesManager = TGPropertiesManager.getInstance((TGContext)this.context);
        TGProperties properties = propertiesManager.createProperties();
        propertiesManager.readProperties(properties, "tuxguitar-skin-info", skin);
        return properties;
    }

    public TGProperties getCurrentSkinProperties() {
        return this.getSkinProperties(this.getCurrentSkin());
    }

    public TGProperties getSkinProperties(String skin) {
        TGPropertiesManager propertiesManager = TGPropertiesManager.getInstance((TGContext)this.context);
        TGProperties properties = propertiesManager.createProperties();
        propertiesManager.readProperties(properties, "tuxguitar-skin-properties", skin);
        return properties;
    }

    public void dispose() {
        TGIconManager.getInstance(this.context).onSkinDisposed();
        TGColorManager.getInstance(this.context).onSkinDisposed();
    }

    public static TGSkinManager getInstance(TGContext context) {
        return (TGSkinManager)TGSingletonUtil.getInstance((TGContext)context, (String)TGSkinManager.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGSkinManager>(){

            public TGSkinManager createInstance(TGContext context) {
                return new TGSkinManager(context);
            }
        });
    }
}

