/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.system.config;

import app.tuxguitar.app.system.config.TGConfigDefaults;
import app.tuxguitar.app.system.properties.TGFilePropertiesHandler;
import app.tuxguitar.app.system.properties.TGResourcePropertiesReader;
import app.tuxguitar.app.util.TGFileUtils;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.properties.TGProperties;
import app.tuxguitar.util.properties.TGPropertiesException;
import app.tuxguitar.util.properties.TGPropertiesReader;
import app.tuxguitar.util.properties.TGPropertiesWriter;
import java.io.File;

public class TGConfigPropertiesHandler
implements TGPropertiesReader,
TGPropertiesWriter {
    private static final String DEFAULT_MODULE = "tuxguitar";
    private static final String DEFAULT_FILE_PREFIX = TGFileUtils.PATH_USER_CONFIG + File.separator;
    private static final String DEFAULT_FILE_SUFFIX = ".cfg";
    private static final String DEFAULT_RESOURCE_PREFIX = "";
    private static final String DEFAULT_RESOURCE_SUFFIX = ".cfg";
    private static final String PLUGINS_FILE_PREFIX = TGFileUtils.PATH_USER_PLUGINS_CONFIG + File.separator;
    private TGContext context;

    public TGConfigPropertiesHandler(TGContext context) {
        this.context = context;
    }

    public void writeProperties(TGProperties properties, String module) throws TGPropertiesException {
        this.storeProperties(properties, module);
    }

    public void readProperties(TGProperties properties, String module) throws TGPropertiesException {
        this.readDefaultProperties(properties, module);
        this.readStoredProperties(properties, module);
    }

    private void readDefaultProperties(TGProperties properties, String module) {
        if (DEFAULT_MODULE.equals(module)) {
            TGConfigDefaults.loadProperties(properties);
        }
        TGResourcePropertiesReader tgPropertiesReader = new TGResourcePropertiesReader(this.context, DEFAULT_RESOURCE_PREFIX, ".cfg");
        tgPropertiesReader.readProperties(properties, module);
    }

    private void readStoredProperties(TGProperties properties, String module) {
        TGFilePropertiesHandler tgPropertiesReader = new TGFilePropertiesHandler(this.getModulePrefix(module), this.getModuleSuffix(module));
        tgPropertiesReader.readProperties(properties, module);
    }

    private void storeProperties(TGProperties properties, String module) {
        TGFilePropertiesHandler tgPropertiesWriter = new TGFilePropertiesHandler(this.getModulePrefix(module), this.getModuleSuffix(module));
        tgPropertiesWriter.writeProperties(properties, module);
    }

    private String getModulePrefix(String module) {
        return DEFAULT_MODULE.equals(module) ? DEFAULT_FILE_PREFIX : PLUGINS_FILE_PREFIX;
    }

    private String getModuleSuffix(String module) {
        return ".cfg";
    }
}

