/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.action.listener.undoable;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.view.component.tab.Caret;
import app.tuxguitar.editor.undo.TGCannotRedoException;
import app.tuxguitar.editor.undo.TGCannotUndoException;
import app.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import app.tuxguitar.song.models.TGDuration;
import app.tuxguitar.song.models.TGString;
import app.tuxguitar.util.TGContext;

public class TGUndoableCaretState
extends TGUndoableEditBase {
    private int doAction;
    private SelectionState undoableState;
    private SelectionState redoableState;

    public TGUndoableCaretState(TGContext context) {
        super(context);
        this.startUndo();
    }

    public void startUndo() {
        this.doAction = 1;
        this.undoableState = this.findCurrentState();
    }

    public void endUndo() {
        this.redoableState = this.findCurrentState();
    }

    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.updateCaret(this.redoableState);
        this.doAction = 1;
    }

    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.updateCaret(this.undoableState);
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    private SelectionState findCurrentState() {
        Caret caret = this.getCaret();
        SelectionState state = new SelectionState();
        state.setTrack(caret.getTrack().getNumber());
        state.setPosition(caret.getPosition());
        state.setVelocity(caret.getVelocity());
        state.setDuration(caret.getDuration().clone(this.getSongManager().getFactory()));
        state.setString(1);
        TGString instrumentString = caret.getSelectedString();
        if (instrumentString != null) {
            state.setString(instrumentString.getNumber());
        }
        return state;
    }

    private void updateCaret(SelectionState state) {
        this.getCaret().update(state.getTrack(), state.getPosition(), state.getString(), state.getVelocity());
        this.getCaret().setSelectedDuration(state.getDuration().clone(this.getSongManager().getFactory()));
    }

    private Caret getCaret() {
        return TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret();
    }

    private static class SelectionState {
        private long position;
        private int track;
        private int string;
        private int velocity;
        private TGDuration duration;

        public long getPosition() {
            return this.position;
        }

        public void setPosition(long position) {
            this.position = position;
        }

        public int getTrack() {
            return this.track;
        }

        public void setTrack(int track) {
            this.track = track;
        }

        public int getString() {
            return this.string;
        }

        public void setString(int string) {
            this.string = string;
        }

        public int getVelocity() {
            return this.velocity;
        }

        public void setVelocity(int velocity) {
            this.velocity = velocity;
        }

        public TGDuration getDuration() {
            return this.duration;
        }

        public void setDuration(TGDuration duration) {
            this.duration = duration;
        }
    }
}

