/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.action.listener.cache;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.app.action.TGActionAdapterManager;
import app.tuxguitar.app.action.TGActionMap;
import app.tuxguitar.app.action.listener.cache.TGUpdateContext;
import app.tuxguitar.app.action.listener.cache.TGUpdateController;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.util.TGAbstractContext;

public class TGUpdateListener
implements TGEventListener {
    private TGActionAdapterManager manager;
    private TGActionMap<TGUpdateController> controllers;

    public TGUpdateListener(TGActionAdapterManager manager) {
        this.manager = manager;
        this.controllers = new TGActionMap();
    }

    public TGActionMap<TGUpdateController> getControllers() {
        return this.controllers;
    }

    public void processUpdate(String actionId, TGActionContext actionContext) {
        TGUpdateController controller = this.controllers.get(actionId);
        if (controller != null) {
            controller.update(this.manager.getContext(), actionContext);
        }
    }

    public void processPreExecution(String actionId, TGActionContext actionContext) {
        if (this.controllers.get(actionId) != null) {
            TGUpdateContext updateContext = TGUpdateContext.getInstance(this.manager.getContext(), actionContext);
            if (updateContext.getLevel().equals(0)) {
                updateContext.getBuffer().clear();
            }
            updateContext.incrementLevel();
        }
    }

    public void processPostExecution(String actionId, TGActionContext actionContext) {
        if (this.controllers.get(actionId) != null) {
            TGUpdateContext updateContext = TGUpdateContext.getInstance(this.manager.getContext(), actionContext);
            updateContext.decrementLevel();
            this.processUpdate(actionId, actionContext);
            if (updateContext.getLevel().equals(0)) {
                updateContext.getBuffer().apply((TGAbstractContext)actionContext);
            }
        }
    }

    public void processPreExecution(TGEvent event) {
        String actionId = (String)event.getAttribute("actionId");
        TGActionContext actionContext = (TGActionContext)event.getAttribute("sourceContext");
        this.processPreExecution(actionId, actionContext);
    }

    public void processPostExecution(TGEvent event) {
        String actionId = (String)event.getAttribute("actionId");
        TGActionContext actionContext = (TGActionContext)event.getAttribute("sourceContext");
        this.processPostExecution(actionId, actionContext);
    }

    public void processEvent(TGEvent event) {
        if ("action-pre-execution".equals(event.getEventType())) {
            this.processPreExecution(event);
        } else if ("action-post-execution".equals(event.getEventType())) {
            this.processPostExecution(event);
        }
    }
}

