/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.action.impl.file;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.action.TGActionException;
import app.tuxguitar.action.TGActionManager;
import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.action.impl.view.TGOpenViewAction;
import app.tuxguitar.app.document.TGDocument;
import app.tuxguitar.app.document.TGDocumentListManager;
import app.tuxguitar.app.util.TGFileUtils;
import app.tuxguitar.app.view.dialog.message.TGMessageDialog;
import app.tuxguitar.app.view.dialog.message.TGMessageDialogController;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionBase;
import app.tuxguitar.editor.action.file.TGReadSongAction;
import app.tuxguitar.io.base.TGFileFormatUtils;
import app.tuxguitar.util.TGContext;
import java.io.InputStream;
import java.net.URL;

public class TGReadURLAction
extends TGActionBase {
    public static final String NAME = "action.url.read";
    public static final String ATTRIBUTE_URL = URL.class.getName();

    public TGReadURLAction(TGContext context) {
        super(context, NAME);
    }

    protected void processAction(TGActionContext context) {
        TGDocumentListManager docListManager = TGDocumentListManager.getInstance(this.getContext());
        try {
            URL url = (URL)context.getAttribute(ATTRIBUTE_URL);
            TGDocument alreadyOpenedDoc = null;
            for (TGDocument doc : docListManager.getDocuments()) {
                if (!url.toURI().equals(doc.getUri())) continue;
                alreadyOpenedDoc = doc;
                break;
            }
            if (alreadyOpenedDoc != null) {
                context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)alreadyOpenedDoc.getSong());
                TGActionManager tgActionManager = TGActionManager.getInstance((TGContext)this.getContext());
                tgActionManager.execute("action.song.load", context);
            } else {
                InputStream stream = TGFileUtils.isLocalFile(url) ? url.openStream() : TGFileFormatUtils.getInputStream((InputStream)url.openStream());
                context.setAttribute("formatCode", (Object)TGFileFormatUtils.getFileFormatCode((String)url.getFile()));
                context.setAttribute(TGReadSongAction.ATTRIBUTE_INPUT_STREAM, (Object)stream);
                TGActionManager tgActionManager = TGActionManager.getInstance((TGContext)this.getContext());
                tgActionManager.execute("action.song.read", context);
                if (Boolean.TRUE.equals(context.getAttribute("action.song.read.newerFileFormat"))) {
                    context.setAttribute("title", (Object)TuxGuitar.getProperty("warning"));
                    context.setAttribute("style", (Object)TGMessageDialog.STYLE_WARNING);
                    context.setAttribute("message", (Object)TuxGuitar.getProperty("warning.new-minor-version"));
                    context.setAttribute(TGOpenViewAction.ATTRIBUTE_CONTROLLER, (Object)new TGMessageDialogController());
                    tgActionManager.execute("action.gui.open-view", context);
                }
            }
        }
        catch (Throwable e) {
            throw new TGActionException(e.getMessage(), e);
        }
    }
}

