/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.pdf;

import app.tuxguitar.io.pdf.PDFSettings;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.configuration.TGConfigManager;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;
import java.util.Map;

public class PDFSettingsManager {
    private TGConfigManager configMgr;
    private PDFSettings settings = new PDFSettings();

    public PDFSettingsManager(TGContext context) {
        this.configMgr = new TGConfigManager(context, "tuxguitar-pdf");
        this.loadSettings();
    }

    private void loadSettings() {
        Map<String, Float> map = this.settings.getSettingsMap();
        for (String key : map.keySet()) {
            map.put(key, Float.valueOf(this.configMgr.getFloatValue(key, map.get(key).floatValue())));
        }
    }

    public PDFSettings getSettings() {
        return this.settings;
    }

    public float getSetting(String key) {
        return this.settings.getSettingsMap().get(key).floatValue();
    }

    public void setSetting(String key, float value) {
        this.settings.getSettingsMap().put(key, Float.valueOf(value));
    }

    public void saveSettings() {
        Map<String, Float> map = this.settings.getSettingsMap();
        for (String key : map.keySet()) {
            this.configMgr.setValue(key, map.get(key).floatValue());
        }
        this.configMgr.save();
    }

    public static PDFSettingsManager getInstance(TGContext context) {
        return (PDFSettingsManager)TGSingletonUtil.getInstance((TGContext)context, (String)PDFSettingsManager.class.getName(), (TGSingletonFactory)new TGSingletonFactory<PDFSettingsManager>(){

            public PDFSettingsManager createInstance(TGContext context) {
                return new PDFSettingsManager(context);
            }
        });
    }
}

