/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.ui.swt.widget;

import app.tuxguitar.ui.UIComponent;
import app.tuxguitar.ui.event.UIMouseDownListener;
import app.tuxguitar.ui.event.UIMouseDragListener;
import app.tuxguitar.ui.event.UIMouseEvent;
import app.tuxguitar.ui.event.UIMouseWheelEvent;
import app.tuxguitar.ui.event.UIMouseWheelListener;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.event.UISelectionListenerManager;
import app.tuxguitar.ui.resource.UIPosition;
import app.tuxguitar.ui.resource.UIRectangle;
import app.tuxguitar.ui.swt.resource.SWTPainter;
import app.tuxguitar.ui.swt.widget.SWTContainer;
import app.tuxguitar.ui.swt.widget.SWTControl;
import app.tuxguitar.ui.widget.UIScale;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class SWTCustomScale
extends SWTControl<Composite>
implements UIScale,
UIMouseDownListener,
UIMouseDragListener,
UIMouseWheelListener,
PaintListener {
    private static final int DEFAULT_MAXIMUM = 100;
    private static final int DEFAULT_MINIMUM = 0;
    private static final int DEFAULT_INCREMENT = 1;
    private static final float DEFAULT_PACKED_WIDTH = 32.0f;
    private static final float DEFAULT_PACKED_HEIGHT = 32.0f;
    private static final float MARGIN = 12.0f;
    private static final float TRACK_WIDTH = 8.0f;
    private static final float INDICATOR_WIDTH = 12.0f;
    private int maximum;
    private int minimum;
    private int increment;
    private int value;
    private boolean horizontal;
    private UIPosition mousePosition;
    private UISelectionListenerManager selectionHandler;

    public SWTCustomScale(SWTContainer<? extends Composite> parent, boolean horizontal) {
        super(new Composite(parent.getControl(), 0x20000000), parent);
        this.horizontal = horizontal;
        this.maximum = 100;
        this.minimum = 0;
        this.increment = 1;
        this.mousePosition = new UIPosition();
        this.selectionHandler = new UISelectionListenerManager();
        this.addMouseDownListener(this);
        this.addMouseDragListener(this);
        this.addMouseWheelListener(this);
        ((Composite)this.getControl()).addPaintListener((PaintListener)this);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        if (this.value != value) {
            this.value = value;
            this.invalidate();
            this.fireSelectionEvent();
        }
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        if (this.maximum != maximum) {
            if (this.minimum > maximum) {
                this.minimum = maximum;
            }
            if (this.value > maximum) {
                this.value = maximum;
            }
            this.maximum = maximum;
            this.invalidate();
        }
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        if (this.minimum != minimum) {
            if (this.maximum < minimum) {
                this.maximum = minimum;
            }
            if (this.value < minimum) {
                this.value = minimum;
            }
            this.minimum = minimum;
            this.invalidate();
        }
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
        this.invalidate();
    }

    public void addSelectionListener(UISelectionListener listener) {
        this.selectionHandler.addListener(listener);
    }

    public void removeSelectionListener(UISelectionListener listener) {
        this.selectionHandler.removeListener(listener);
    }

    public void fireSelectionEvent() {
        if (!this.isIgnoreEvents()) {
            this.selectionHandler.onSelect(new UISelectionEvent((UIComponent)this));
        }
    }

    @Override
    public void computePackedSize(Float fixedWidth, Float fixedHeight) {
        super.computePackedSize(Float.valueOf(fixedWidth != null ? fixedWidth.floatValue() : 32.0f), Float.valueOf(fixedHeight != null ? fixedHeight.floatValue() : 32.0f));
    }

    public void invalidate() {
        ((Composite)this.getControl()).redraw();
    }

    public UIRectangle getTrackBounds() {
        Rectangle area = ((Composite)this.getControl()).getClientArea();
        UIRectangle bounds = new UIRectangle();
        bounds.getSize().setWidth(this.horizontal ? (float)area.width - 12.0f : Math.min((float)area.width - 12.0f, 8.0f));
        bounds.getSize().setHeight(this.horizontal ? Math.min((float)area.height - 12.0f, 8.0f) : (float)area.height - 12.0f);
        bounds.getPosition().setX((float)area.x + (this.horizontal ? 6.0f : (float)area.width / 2.0f - (bounds.getWidth() - 2.0f)));
        bounds.getPosition().setY((float)area.y + (this.horizontal ? (float)area.height / 2.0f - (bounds.getHeight() - 2.0f) : 6.0f));
        return bounds;
    }

    public void updateValueFromPosition(UIPosition position) {
        UIRectangle bounds = this.getTrackBounds();
        float trackSize = this.horizontal ? bounds.getWidth() : bounds.getHeight();
        float trackSelection = this.horizontal ? position.getX() - bounds.getX() : trackSize - (position.getY() - bounds.getY());
        float percent = trackSize > 0.0f && trackSelection > 0.0f ? trackSelection / trackSize : 0.0f;
        this.setValue(Math.round(Math.max(Math.min((float)(this.maximum - this.minimum) * percent, (float)this.maximum), (float)this.minimum)));
    }

    public void paintControl(PaintEvent e) {
        UIRectangle bounds = this.getTrackBounds();
        float value = this.value - this.minimum;
        float maximum = this.maximum - this.minimum;
        float percent = value > 0.0f && maximum > 0.0f ? value / maximum : 0.0f;
        float valueX = bounds.getX() + (this.horizontal ? bounds.getWidth() * percent : bounds.getWidth() / 2.0f);
        float valueY = bounds.getY() + (this.horizontal ? bounds.getHeight() / 2.0f : bounds.getHeight() - bounds.getHeight() * percent);
        SWTPainter uiPainter = new SWTPainter(e.gc);
        uiPainter.initPath(1);
        uiPainter.moveTo(bounds.getX(), bounds.getY());
        uiPainter.addRectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        uiPainter.closePath();
        uiPainter.initPath(3);
        uiPainter.moveTo(valueX, valueY);
        uiPainter.addCircle(valueX, valueY, 12.0f);
        uiPainter.closePath();
    }

    public void onMouseWheel(UIMouseWheelEvent event) {
        this.setValue(Math.round(Math.max(Math.min((float)this.value + Math.signum(event.getValue().intValue()) * (float)this.increment, (float)this.maximum), (float)this.minimum)));
    }

    public void onMouseDrag(UIMouseEvent event) {
        UIPosition uiPosition = new UIPosition();
        uiPosition.setX(this.mousePosition.getX() + event.getPosition().getX());
        uiPosition.setY(this.mousePosition.getY() + event.getPosition().getY());
        this.updateValueFromPosition(uiPosition);
    }

    public void onMouseDown(UIMouseEvent event) {
        this.mousePosition.setX(event.getPosition().getX());
        this.mousePosition.setY(event.getPosition().getY());
        this.updateValueFromPosition(this.mousePosition);
    }
}

