/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.ui.swt.resource;

import app.tuxguitar.ui.resource.UIKey;
import app.tuxguitar.ui.resource.UIKeyCombination;

public class SWTKey {
    private static final SWTKeyMap[] KEY_MAP = new SWTKeyMap[]{new SWTKeyMap(0x100000A, UIKey.F1), new SWTKeyMap(0x100000B, UIKey.F2), new SWTKeyMap(0x100000C, UIKey.F3), new SWTKeyMap(0x100000D, UIKey.F4), new SWTKeyMap(0x100000E, UIKey.F5), new SWTKeyMap(0x100000F, UIKey.F6), new SWTKeyMap(0x1000010, UIKey.F7), new SWTKeyMap(0x1000011, UIKey.F8), new SWTKeyMap(0x1000012, UIKey.F9), new SWTKeyMap(0x1000013, UIKey.F10), new SWTKeyMap(0x1000014, UIKey.F11), new SWTKeyMap(0x1000015, UIKey.F12), new SWTKeyMap(27, UIKey.ESC), new SWTKeyMap(0x1000055, UIKey.PAUSE), new SWTKeyMap(16777303, UIKey.PRINT_SCREEN), new SWTKeyMap(0x1000009, UIKey.INSERT), new SWTKeyMap(127, UIKey.DELETE), new SWTKeyMap(0x1000007, UIKey.HOME), new SWTKeyMap(0x1000005, UIKey.PAGE_UP), new SWTKeyMap(0x1000006, UIKey.PAGE_DOWN), new SWTKeyMap(0x1000008, UIKey.END), new SWTKeyMap(65536, UIKey.ALT), new SWTKeyMap(262144, UIKey.CONTROL), new SWTKeyMap(0x400000, UIKey.COMMAND), new SWTKeyMap(131072, UIKey.SHIFT), new SWTKeyMap(9, UIKey.TAB), new SWTKeyMap(8, UIKey.BACKSPACE), new SWTKeyMap(32, UIKey.SPACE), new SWTKeyMap(13, UIKey.ENTER), new SWTKeyMap(0x1000050, UIKey.NUMPAD_ENTER), new SWTKeyMap(0x1000001, UIKey.UP), new SWTKeyMap(0x1000002, UIKey.DOWN), new SWTKeyMap(0x1000003, UIKey.LEFT), new SWTKeyMap(0x1000004, UIKey.RIGHT)};

    public UIKey getKey(int keyCode) {
        for (SWTKeyMap keyMap : KEY_MAP) {
            if (keyMap.getCode() != keyCode) continue;
            return keyMap.getKey();
        }
        return new UIKey(Character.toString((char)(keyCode & 0xFFFF)));
    }

    public UIKeyCombination getCombination(int keyCode, int stateMask, Character character) {
        UIKey principalKey;
        UIKeyCombination keyCombination = new UIKeyCombination();
        boolean isDigit = Character.isDigit(character.charValue());
        if ((stateMask & keyCode) == 0) {
            if ((stateMask & 0x10000) != 0) {
                keyCombination.getKeys().add(UIKey.ALT);
            }
            if ((stateMask & 0x20000) != 0 && !isDigit) {
                keyCombination.getKeys().add(UIKey.SHIFT);
            }
            if ((stateMask & 0x40000) != 0) {
                keyCombination.getKeys().add(UIKey.CONTROL);
            }
            if ((stateMask & 0x400000) != 0) {
                keyCombination.getKeys().add(UIKey.COMMAND);
            }
        }
        if (!keyCombination.contains(principalKey = this.getKey(keyCode)) && !isDigit) {
            keyCombination.getKeys().add(principalKey);
        } else if (isDigit) {
            keyCombination.getKeys().add(new UIKey(character.toString()));
        }
        return keyCombination;
    }

    private static class SWTKeyMap {
        private int code;
        private UIKey key;

        public SWTKeyMap(int code, UIKey key) {
            this.code = code;
            this.key = key;
        }

        public int getCode() {
            return this.code;
        }

        public UIKey getKey() {
            return this.key;
        }
    }
}

