/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.ui.swt.menu;

import app.tuxguitar.ui.UIComponent;
import app.tuxguitar.ui.menu.UIMenu;
import app.tuxguitar.ui.menu.UIMenuActionItem;
import app.tuxguitar.ui.menu.UIMenuCheckableItem;
import app.tuxguitar.ui.menu.UIMenuItem;
import app.tuxguitar.ui.menu.UIMenuSubMenuItem;
import app.tuxguitar.ui.swt.menu.SWTMenuActionItem;
import app.tuxguitar.ui.swt.menu.SWTMenuCheckableItem;
import app.tuxguitar.ui.swt.menu.SWTMenuItem;
import app.tuxguitar.ui.swt.menu.SWTMenuSubMenuItem;
import app.tuxguitar.ui.swt.widget.SWTEventReceiver;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class SWTMenu
extends SWTEventReceiver<Menu>
implements UIMenu {
    private List<UIMenuItem> menuItems = new ArrayList<UIMenuItem>();

    public SWTMenu(Shell shell, int style) {
        super(new Menu((Decorations)shell, style));
    }

    public Integer getItemCount() {
        return this.menuItems.size();
    }

    public UIMenuItem getItem(int index) {
        return index >= 0 && index < this.menuItems.size() ? this.menuItems.get(index) : null;
    }

    public List<UIMenuItem> getItems() {
        return new ArrayList<UIMenuItem>(this.menuItems);
    }

    public UIComponent createSeparator() {
        MenuItem menuItem = new MenuItem((Menu)this.getControl(), 2);
        return this.append(new SWTMenuItem(menuItem, this));
    }

    public UIMenuActionItem createActionItem() {
        MenuItem menuItem = new MenuItem((Menu)this.getControl(), 8);
        return (UIMenuActionItem)this.append(new SWTMenuActionItem(menuItem, this));
    }

    public UIMenuCheckableItem createCheckItem() {
        MenuItem menuItem = new MenuItem((Menu)this.getControl(), 32);
        return (UIMenuCheckableItem)this.append(new SWTMenuCheckableItem(menuItem, this));
    }

    public UIMenuCheckableItem createRadioItem() {
        MenuItem menuItem = new MenuItem((Menu)this.getControl(), 16);
        return (UIMenuCheckableItem)this.append(new SWTMenuCheckableItem(menuItem, this));
    }

    public UIMenuSubMenuItem createSubMenuItem() {
        MenuItem menuItem = new MenuItem((Menu)this.getControl(), 64);
        return (UIMenuSubMenuItem)this.append(new SWTMenuSubMenuItem(menuItem, this));
    }

    public <T extends UIMenuItem> T append(UIMenuItem item) {
        this.menuItems.add(item);
        return (T)item;
    }

    public void dispose(SWTMenuItem item) {
        if (this.menuItems.contains(item)) {
            this.menuItems.remove(item);
        }
        ((MenuItem)item.getControl()).dispose();
    }

    public void dispose() {
        ((Menu)this.getControl()).dispose();
    }

    public boolean isDisposed() {
        return ((Menu)this.getControl()).isDisposed();
    }
}

