/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.undo.impl.track;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.editor.undo.TGCannotRedoException;
import app.tuxguitar.editor.undo.TGCannotUndoException;
import app.tuxguitar.editor.undo.impl.track.TGUndoableTrackBase;
import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.util.TGContext;

public class TGUndoableTrackGeneric
extends TGUndoableTrackBase {
    private int doAction;
    private TGTrack undoTrack;
    private TGTrack redoTrack;

    private TGUndoableTrackGeneric(TGContext context) {
        super(context);
    }

    @Override
    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.copyTrackFrom(actionContext, this.getSong(), this.getTrack(this.redoTrack.getNumber()), this.redoTrack);
        this.doAction = 1;
    }

    @Override
    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.copyTrackFrom(actionContext, this.getSong(), this.getTrack(this.undoTrack.getNumber()), this.undoTrack);
        this.doAction = 2;
    }

    @Override
    public boolean canRedo() {
        return this.doAction == 2;
    }

    @Override
    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableTrackGeneric startUndo(TGContext context, TGTrack track) {
        TGUndoableTrackGeneric undoable = new TGUndoableTrackGeneric(context);
        undoable.doAction = 1;
        undoable.undoTrack = track.clone(new TGFactory(), TGUndoableTrackGeneric.getSong(context));
        return undoable;
    }

    public TGUndoableTrackGeneric endUndo(TGTrack track) {
        this.redoTrack = track.clone(new TGFactory(), this.getSong());
        return this;
    }

    public TGTrack getTrack(int number) {
        return this.getSongManager().getTrack(this.getSong(), number);
    }
}

