/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.undo.impl.custom;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.editor.undo.TGCannotRedoException;
import app.tuxguitar.editor.undo.TGCannotUndoException;
import app.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.models.TGMeasureHeader;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.song.models.TGTimeSignature;
import app.tuxguitar.util.TGContext;

public class TGUndoableTimeSignature
extends TGUndoableEditBase {
    private int doAction;
    private TGSong song;
    private long tsStart;
    private boolean tsToEnd;
    private TGTimeSignature ts;

    private TGUndoableTimeSignature(TGContext context) {
        super(context);
    }

    @Override
    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.changeTimeSignature(actionContext, this.getSong(), this.getMeasureHeaderAt(this.tsStart), this.ts, this.tsToEnd);
        this.doAction = 1;
    }

    @Override
    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.copySongFrom(actionContext, this.getSong(), this.song);
        this.doAction = 2;
    }

    @Override
    public boolean canRedo() {
        return this.doAction == 2;
    }

    @Override
    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableTimeSignature startUndo(TGContext context) {
        TGFactory factory = new TGFactory();
        TGSong song = TGUndoableTimeSignature.getSong(context);
        TGUndoableTimeSignature undoable = new TGUndoableTimeSignature(context);
        undoable.doAction = 1;
        undoable.song = song.clone(factory);
        return undoable;
    }

    public TGUndoableTimeSignature endUndo(TGTimeSignature timeSignature, long start, boolean toEnd) {
        this.ts = timeSignature;
        this.tsStart = start;
        this.tsToEnd = toEnd;
        return this;
    }

    public TGMeasureHeader getMeasureHeaderAt(Long start) {
        return this.getSongManager().getMeasureHeaderAt(this.getSong(), start.longValue());
    }

    public void changeTimeSignature(TGActionContext context, TGSong song, TGMeasureHeader header, TGTimeSignature timeSignature, Boolean toEnd) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.composition.change-time-signature");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER, header);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TIME_SIGNATURE, timeSignature);
        tgActionProcessor.setAttribute("applyToEnd", toEnd);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }

    public void copySongFrom(TGActionContext context, TGSong song, TGSong from) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.song.copy.from");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute("from", from);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }
}

